/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacardx.jcwde;

import javacardx.framework.util.UtilException;

public class SimArrayLogic {
    public static final short arrayCopyRepack(short[] src, short srcOff, short srcLen, short[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (srcOff < 0 || srcOff >= src.length || srcLen < 0 || srcOff + srcLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = srcLen;
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(src, srcOff, dest, destOff, srcLen);
        return (short)(destOff + destLen);
    }

    public static final short arrayCopyRepack(byte[] src, short srcOff, short srcLen, byte[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (srcOff < 0 || srcOff >= src.length || srcLen < 0 || srcOff + srcLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = srcLen;
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(src, srcOff, dest, destOff, srcLen);
        return (short)(destOff + destLen);
    }

    public static final short arrayCopyRepack(int[] src, short srcOff, short srcLen, int[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (srcOff < 0 || srcOff >= src.length || srcLen < 0 || srcOff + srcLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = srcLen;
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(src, srcOff, dest, destOff, srcLen);
        return (short)(destOff + destLen);
    }

    public static final short arrayCopyRepack(byte[] src, short srcOff, short bLen, short[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (srcOff < 0 || srcOff >= src.length || bLen < 0 || srcOff + bLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = (short)(bLen / 2);
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bLen % 2 != 0) {
            throw new UtilException(1);
        }
        short i = 0;
        short j = 0;
        while (i < bLen) {
            dest[destOff + j] = (short)((src[srcOff + i] << 8 & 0xFF00) + (src[srcOff + i + 1] & 0xFF));
            i = (short)(i + 2);
            j = (short)(j + 1);
        }
        return (short)(destOff + j);
    }

    public static final short arrayCopyRepack(byte[] src, short srcOff, short bLen, int[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (srcOff < 0 || srcOff >= src.length || bLen < 0 || srcOff + bLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = (short)(bLen / 4);
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bLen % 4 != 0) {
            throw new UtilException(1);
        }
        short i = 0;
        short j = 0;
        while (i < bLen) {
            dest[destOff + j] = (src[srcOff + i] << 24) + (src[srcOff + i + 1] << 16 & 0xFF0000) + (src[srcOff + i + 2] << 8 & 0xFF00) + (src[srcOff + i + 3] & 0xFF);
            i = (short)(i + 4);
            j = (short)(j + 1);
        }
        return (short)(destOff + j);
    }

    public static final short arrayCopyRepack(short[] src, short srcOff, short sLen, byte[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (srcOff < 0 || srcOff >= src.length || sLen < 0 || srcOff + sLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = (short)(2 * sLen);
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short i = 0;
        short j = 0;
        while (i < sLen) {
            dest[destOff + j] = (byte)(src[srcOff + i] >> 8);
            dest[destOff + j + 1] = (byte)src[srcOff + i];
            i = (short)(i + 1);
            j = (short)(j + 2);
        }
        return (short)(destOff + j);
    }

    public static final short arrayCopyRepack(short[] src, short srcOff, short sLen, int[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (srcOff < 0 || srcOff >= src.length || sLen < 0 || srcOff + sLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = (short)(sLen / 2);
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (sLen % 2 != 0) {
            throw new UtilException(1);
        }
        short i = 0;
        short j = 0;
        while (i < sLen) {
            dest[destOff + j] = (src[srcOff + i] << 16) + (src[srcOff + i + 1] & 0xFFFF);
            i = (short)(i + 2);
            j = (short)(j + 1);
        }
        return (short)(destOff + j);
    }

    public static final short arrayCopyRepack(int[] src, short srcOff, short iLen, byte[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (srcOff < 0 || srcOff >= src.length || iLen < 0 || srcOff + iLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = (short)(4 * iLen);
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short i = 0;
        short j = 0;
        while (i < iLen) {
            dest[destOff + j] = (byte)(src[srcOff + i] >> 24);
            dest[destOff + j + 1] = (byte)(src[srcOff + i] >> 16);
            dest[destOff + j + 2] = (byte)(src[srcOff + i] >> 8);
            dest[destOff + j + 3] = (byte)src[srcOff + i];
            i = (short)(i + 1);
            j = (short)(j + 4);
        }
        return (short)(destOff + j);
    }

    public static final short arrayCopyRepack(int[] src, short srcOff, short iLen, short[] dest, short destOff) throws ArrayIndexOutOfBoundsException, NullPointerException, UtilException {
        if (srcOff < 0 || srcOff >= src.length || iLen < 0 || srcOff + iLen > src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short destLen = (short)(2 * iLen);
        if (destOff < 0 || destOff >= dest.length || destOff + destLen > dest.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short i = 0;
        short j = 0;
        while (i < iLen) {
            dest[destOff + j] = (short)(src[srcOff + i] >> 16);
            dest[destOff + j + 1] = (short)src[srcOff + i];
            i = (short)(i + 1);
            j = (short)(j + 2);
        }
        return (short)(destOff + j);
    }

    public static final short arrayFill(byte[] theArray, short off, short len, byte[] valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        while (true) {
            short s = len;
            len = (short)(s - 1);
            if (s <= 0) break;
            short s2 = off;
            off = (short)(off + 1);
            theArray[s2] = valArray[valOff];
        }
        return (short)(off + len + 1);
    }

    public static final short arrayFill(short[] theArray, short off, short len, short[] valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        while (true) {
            short s = len;
            len = (short)(s - 1);
            if (s <= 0) break;
            short s2 = off;
            off = (short)(off + 1);
            theArray[s2] = valArray[valOff];
        }
        return (short)(off + len + 1);
    }

    public static final short arrayFill(int[] theArray, short off, short len, int[] valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        while (true) {
            short s = len;
            len = (short)(s - 1);
            if (s <= 0) break;
            short s2 = off;
            off = (short)(off + 1);
            theArray[s2] = valArray[valOff];
        }
        return (short)(off + len + 1);
    }

    public static final byte arrayCompare(byte[] src, short srcOff, byte[] dest, short destOff, short length) throws ArrayIndexOutOfBoundsException, NullPointerException {
        for (short i = 0; i < length; i = (short)(i + 1)) {
            if (src[srcOff + i] == dest[destOff + i]) continue;
            if (src[srcOff + i] < dest[destOff + i]) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static final byte arrayCompare(short[] src, short srcOff, short[] dest, short destOff, short length) throws ArrayIndexOutOfBoundsException, NullPointerException {
        for (short i = 0; i < length; i = (short)(i + 1)) {
            if (src[srcOff + i] == dest[destOff + i]) continue;
            if (src[srcOff + i] < dest[destOff + i]) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static final byte arrayCompare(int[] src, short srcOff, int[] dest, short destOff, short length) throws ArrayIndexOutOfBoundsException, NullPointerException {
        for (short i = 0; i < length; i = (short)(i + 1)) {
            if (src[srcOff + i] == dest[destOff + i]) continue;
            if (src[srcOff + i] < dest[destOff + i]) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static final short arrayFind(byte[] theArray, short off, byte[] valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        for (short i = 0; i < (short)theArray.length; i = (short)(i + 1)) {
            if (theArray[off + i] != valArray[valOff]) continue;
            return (short)(off + i);
        }
        return -1;
    }

    public static final short arrayFind(short[] theArray, short off, byte[] valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        for (short i = 0; i < (short)theArray.length; i = (short)(i + 1)) {
            if ((byte)(theArray[off + i] >> 8) != valArray[valOff] || (byte)theArray[off + i] != valArray[valOff + 1]) continue;
            return (short)(off + i);
        }
        return -1;
    }

    public static final short arrayFind(int[] theArray, short off, byte[] valArray, short valOff) throws ArrayIndexOutOfBoundsException, NullPointerException {
        for (short i = 0; i < (short)theArray.length; i = (short)(i + 1)) {
            if ((byte)(theArray[off + i] >> 24) != valArray[valOff] || (byte)(theArray[off + i] >> 16) != valArray[valOff + 1] || (byte)(theArray[off + i] >> 8) != valArray[valOff + 2] || (byte)theArray[off + i] != valArray[valOff + 3]) continue;
            return (short)(off + i);
        }
        return -1;
    }
}

