/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.APDUToolTask;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;

public class DeployCapTask
extends APDUToolTask {
    private static final String ScriptgenClassName = "com.sun.javacard.scriptgen.Main";
    protected static final String eol = System.getProperty("line.separator", "\n");
    protected static final String header = "powerup; " + eol + eol + "0x00 0xA4 0x04 0x00 0x09 0xa0 0x00 0x00 0x00 0x62 0x03 0x01 0x08 0x01 0x7F;" + eol + "// 90 00 = SW_NO_ERROR" + eol;
    protected static final String footer = eol + "powerdown;" + eol;
    protected String capName;

    public void setCapFile(String capName) {
        this.capName = capName;
    }

    protected void generateScriptFile() throws BuildException {
        if (this.scriptFileName == null) {
            try {
                File scriptFile = File.createTempFile("APDUToolScriptFile", "");
                this.scriptFileName = scriptFile.getAbsolutePath();
            }
            catch (IOException e) {
                throw new BuildException(messages.getString("deploycap.genScriptFileError"));
            }
        }
        this.clearArgs();
        Commandline.Argument outFileNameOption = this.createArg();
        outFileNameOption.setValue("-o");
        Commandline.Argument outFileNameArg = this.createArg();
        outFileNameArg.setValue(this.scriptFileName);
        if (this.capName == null) {
            throw new BuildException(messages.getString("deploycap.noCapName"));
        }
        Commandline.Argument capFile = this.createArg();
        capFile.setValue(this.capName);
        this.setClassname(ScriptgenClassName);
        this.setFork(true);
        if (this.executeJava() != 0) {
            throw new BuildException(messages.getString("deploycap.scriptgenError"));
        }
        String line = null;
        StringBuffer outputBuffer = new StringBuffer();
        outputBuffer.append(header + eol);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.scriptFileName));
            while ((line = reader.readLine()) != null) {
                outputBuffer.append(line + eol);
            }
            reader.close();
            outputBuffer.append(footer);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.scriptFileName));
            PrintWriter pw = new PrintWriter(os);
            pw.print(outputBuffer.toString());
            pw.flush();
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new BuildException(messages.getString("deploycap.scriptFileError"));
        }
    }

    public void execute() throws BuildException {
        this.printDisclaimer();
        this.generateScriptFile();
        this.initCard();
        this.sendAPDUSToCard(true);
    }
}

