/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimChannelManager;
import com.sun.javacard.jcwde.SimPrivAccess;
import com.sun.javacard.jcwde.SimulationException;
import java.util.Vector;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public class SimSystem {
    private static byte transDepth;
    private static byte MAX_NUM_APPLETS;
    private static Vector clearOnResetTransientObjs;
    private static Vector[] clearOnDeselectTransientObjs;

    public static void init() {
        byte i = 0;
        while (i < MAX_NUM_APPLETS) {
            SimSystem.clearOnDeselectTransientObjs[i] = new Vector(0, 5);
            i = (byte)(i + 1);
        }
    }

    public static byte isTransient(Object object) throws SystemException {
        if (object != null) {
            if (clearOnResetTransientObjs.contains(object)) {
                return 1;
            }
            byte i = 0;
            while (i < MAX_NUM_APPLETS) {
                if (clearOnDeselectTransientObjs[i].contains(object)) {
                    return 2;
                }
                i = (byte)(i + 1);
            }
        }
        return 0;
    }

    private static void addTransientArray(Object array, byte event) throws SystemException {
        byte channelId = SimPrivAccess.getCurrentlySelectedChannel();
        byte arrayDTR = (byte)(SimChannelManager.getActiveContext(channelId) >> 4 & 0xF);
        if (SimSystem.isTransient(array) != 0) {
            SystemException.throwIt((short)3);
        }
        Vector vect = null;
        switch (event) {
            case 1: {
                vect = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vect = clearOnDeselectTransientObjs[arrayDTR];
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        vect.addElement(array);
    }

    public static void clearTransientObjs(byte channelId, byte event) {
        byte dtrToClean = (byte)(SimChannelManager.getActiveContext(channelId) >> 4 & 0xF);
        Vector vect = null;
        switch (event) {
            case 1: {
                byte i = 0;
                while (i < MAX_NUM_APPLETS) {
                    SimSystem.clearTransientObjs(i, (byte)2);
                    i = (byte)(i + 1);
                }
                vect = clearOnResetTransientObjs;
                break;
            }
            case 2: {
                vect = clearOnDeselectTransientObjs[dtrToClean];
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        int i = vect.size() - 1;
        while (i >= 0) {
            int j;
            Object[] array;
            Object object = vect.elementAt(i);
            if (object instanceof boolean[]) {
                array = (boolean[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = false;
                    --j;
                }
            } else if (object instanceof byte[]) {
                array = (byte[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = false;
                    --j;
                }
            } else if (object instanceof short[]) {
                array = (short[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = false;
                    --j;
                }
            } else if (object instanceof Object[]) {
                array = (Object[])object;
                j = array.length - 1;
                while (j >= 0) {
                    array[j] = null;
                    --j;
                }
            } else {
                System.err.println(Globals._messages.getString("ClearTrans"));
                throw new SimulationException();
            }
            --i;
        }
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws SystemException {
        boolean[] array = new boolean[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws SystemException {
        byte[] array = new byte[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static short[] makeTransientShortArray(short length, byte event) throws SystemException {
        short[] array = new short[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws SystemException {
        Object[] array = new Object[length];
        SimSystem.addTransientArray(array, event);
        return array;
    }

    public static void beginTransaction() throws TransactionException {
        if (transDepth != 0) {
            TransactionException.throwIt((short)1);
        }
        transDepth = 1;
    }

    public static void abortTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    public static void commitTransaction() throws TransactionException {
        if (transDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        transDepth = 0;
    }

    public static byte getTransactionDepth() {
        return transDepth;
    }

    public static short getUnusedCommitCapacity() {
        return Short.MAX_VALUE;
    }

    public static short getMaxCommitCapacity() {
        return Short.MAX_VALUE;
    }

    static {
        MAX_NUM_APPLETS = (byte)16;
        clearOnResetTransientObjs = new Vector(0, 5);
        clearOnDeselectTransientObjs = new Vector[16];
    }
}

