/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadT1Client;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1Exception;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ClientT1Protocol
extends ClientProtocol {
    protected boolean numSeq = false;
    protected boolean numSeqTx = true;
    protected boolean numSeqRcv = true;
    protected T1Block blockToCard;
    protected T1Block blockFromCard;
    private int sizeIFSC;
    private int sizeIFSD;

    public ClientT1Protocol(CadT1Client cadT1Client) {
        this.cad = cadT1Client;
        this.sizeIFSC = cadT1Client.getMaxIFSSize();
        this.blockToCard = new T1Block();
        this.blockFromCard = new T1Block();
    }

    public void exchangeApdu(Apdu apdu) throws IOException, T1Exception {
        boolean bl;
        byte by;
        boolean bl2;
        byte by2;
        int n;
        boolean bl3;
        byte[] byArray;
        Object object;
        CadT1Client cadT1Client = (CadT1Client)this.cad;
        boolean bl4 = false;
        boolean bl5 = false;
        block20: while (!bl4) {
            Vector vector = this.prepareT1IBlocks(apdu, this.sizeIFSC);
            object = vector.elements();
            while (object.hasMoreElements() && !bl5) {
                byArray = (byte[])object.nextElement();
                boolean bl6 = !object.hasMoreElements();
                this.blockToCard.setIBlock((byte)0, (byte)0, this.numSeq, bl6, byArray, byArray.length);
                bl3 = true;
                while (bl3) {
                    n = cadT1Client.exchangeBlock(this.blockToCard, this.blockFromCard);
                    if (n == 0) {
                        throw new T1Exception(-126);
                    }
                    this.numSeqTx = this.numSeq;
                    this.numSeq = !this.numSeq;
                    by2 = this.blockFromCard.getBlockType();
                    block0 : switch (by2) {
                        case 0: {
                            if (!bl6) {
                                throw new T1Exception(-126);
                            }
                            bl2 = this.blockFromCard.getSequence();
                            if (bl2 == !this.numSeqRcv) {
                                this.numSeqRcv = bl2;
                                bl3 = false;
                                break;
                            }
                            this.blockToCard.setIBlock((byte)0, (byte)0, this.numSeq, bl6, byArray, byArray.length);
                            break;
                        }
                        case -128: {
                            bl2 = this.blockFromCard.getSequence();
                            if (bl2 == !this.numSeqTx) {
                                bl3 = false;
                                break;
                            }
                            this.blockToCard.setIBlock((byte)0, (byte)0, this.numSeq, bl6, byArray, byArray.length);
                            break;
                        }
                        case -64: {
                            by = this.blockFromCard.getSBlockType();
                            switch (by) {
                                case -64: 
                                case -63: {
                                    throw new T1Exception(-125);
                                }
                                case -62: {
                                    bl = true;
                                    while (bl) {
                                        this.blockToCard.setSBlock((byte)0, (byte)0, -30, 0);
                                        n = cadT1Client.exchangeBlock(this.blockToCard, this.blockFromCard) ? 1 : 0;
                                        if (n == 0) {
                                            throw new T1Exception(-126);
                                        }
                                        by2 = this.blockFromCard.getBlockType();
                                        if (by2 != 0) {
                                            throw new T1Exception(-126);
                                        }
                                        bl2 = this.blockFromCard.getSequence();
                                        if (bl2 != !this.numSeqRcv) continue;
                                        this.numSeqRcv = bl2;
                                        bl = false;
                                    }
                                    bl5 = true;
                                    bl3 = false;
                                    bl4 = true;
                                    break block0;
                                }
                                case -61: {
                                    this.blockToCard.setSBlock((byte)0, (byte)0, -29, this.blockFromCard.getIntINF());
                                    break block0;
                                }
                            }
                            throw new T1Exception(-124);
                        }
                        default: {
                            throw new T1Exception(-124);
                        }
                    }
                }
                if (bl3) continue block20;
                if (!bl6) continue;
                bl4 = true;
            }
        }
        int n2 = 0;
        object = new Vector();
        byArray = this.blockFromCard.getINFBytes();
        byte[] byArray2 = new byte[n2 += this.blockFromCard.getLEN()];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        ((Vector)object).add(byArray2);
        while (!this.blockFromCard.isLastBlock()) {
            bl3 = true;
            this.blockToCard.setRBlock((byte)0, (byte)0, !this.numSeqRcv);
            block25: while (bl3) {
                n = cadT1Client.exchangeBlock(this.blockToCard, this.blockFromCard) ? 1 : 0;
                if (n == 0) {
                    throw new T1Exception(-126);
                }
                by2 = this.blockFromCard.getBlockType();
                bl2 = this.blockFromCard.getSequence();
                switch (by2) {
                    case 0: {
                        if (bl2 == !this.numSeqRcv) {
                            this.numSeqRcv = bl2;
                            bl3 = false;
                            continue block25;
                        }
                        this.blockToCard.setRBlock((byte)0, (byte)0, !this.numSeqRcv);
                        continue block25;
                    }
                    case -128: {
                        if (bl2 == !this.numSeqTx) {
                            throw new T1Exception(-124);
                        }
                        bl3 = true;
                        continue block25;
                    }
                    case -64: {
                        by = this.blockFromCard.getSBlockType();
                        switch (by) {
                            case -64: 
                            case -63: {
                                throw new T1Exception(-125);
                            }
                            case -62: {
                                this.blockToCard.setSBlock((byte)0, (byte)0, -30, 0);
                                n = cadT1Client.exchangeBlock(this.blockToCard, this.blockFromCard) ? 1 : 0;
                                if (n == 0) {
                                    throw new T1Exception(-126);
                                }
                                by2 = this.blockFromCard.getBlockType();
                                if (by2 != 0) {
                                    throw new T1Exception(-126);
                                }
                                bl2 = this.blockFromCard.getSequence();
                                if (bl2 == !this.numSeqRcv) {
                                    this.numSeqRcv = bl2;
                                    bl3 = false;
                                    continue block25;
                                }
                                throw new T1Exception(-126);
                            }
                            case -61: {
                                this.blockToCard.setSBlock((byte)0, (byte)0, -29, this.blockFromCard.getIntINF());
                                continue block25;
                            }
                        }
                        throw new T1Exception(-124);
                    }
                }
                throw new T1Exception(-124);
            }
            byArray = this.blockFromCard.getINFBytes();
            n2 += this.blockFromCard.getLEN();
            byArray2 = new byte[this.blockFromCard.getLEN()];
            System.arraycopy(byArray, 0, byArray2, 0, this.blockFromCard.getLEN());
            ((Vector)object).add(byArray2);
        }
        byte[] byArray3 = new byte[n2 - 2];
        n = 0;
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray4 = (byte[])enumeration.nextElement();
            boolean bl7 = bl = !enumeration.hasMoreElements();
            if (bl) {
                if (byArray4.length > 2) {
                    System.arraycopy(byArray4, 0, byArray3, n, byArray4.length - 2);
                }
                n += byArray4.length - 2;
                apdu.sw1sw2[0] = byArray4[byArray4.length - 2];
                apdu.sw1sw2[1] = byArray4[byArray4.length - 1];
                continue;
            }
            System.arraycopy(byArray4, 0, byArray3, n, byArray4.length);
            n += byArray4.length;
        }
        if (n == 0) {
            byArray3 = new byte[]{};
        }
        apdu.setDataOut(byArray3, n);
    }

    private Vector prepareT1IBlocks(Apdu apdu, int n) throws T1Exception {
        Vector<byte[]> vector = new Vector<byte[]>();
        int n2 = 0;
        switch (apdu.getCase()) {
            case 1: {
                byte[] byArray = new byte[4];
                System.arraycopy(apdu.command, 0, byArray, 0, 4);
                vector.add(byArray);
                break;
            }
            case 2: {
                byte[] byArray = new byte[5];
                System.arraycopy(apdu.command, 0, byArray, 0, 4);
                byArray[4] = (byte)apdu.Le;
                vector.add(byArray);
                break;
            }
            case 3: {
                int n3;
                int n4 = (apdu.Lc + 5) / this.sizeIFSC;
                if (n4 * this.sizeIFSC < apdu.Lc + 5) {
                    ++n4;
                }
                int n5 = n3 = 5 + apdu.Lc;
                int n6 = 0;
                boolean bl = true;
                while (n6 < n4) {
                    int n7 = n5 > this.sizeIFSC ? this.sizeIFSC : n5;
                    int n8 = 0;
                    byte[] byArray = new byte[n7];
                    if (bl) {
                        System.arraycopy(apdu.command, 0, byArray, 0, 4);
                        byArray[4] = (byte)apdu.Lc;
                        n8 += 5;
                        bl = false;
                    }
                    System.arraycopy(apdu.dataIn, n2, byArray, n8, n7 - n8);
                    n2 += n7 - n8;
                    n8 += n7 - n8;
                    vector.add(byArray);
                    ++n6;
                    n5 -= n7;
                }
                break;
            }
            case 4: {
                int n9;
                int n10 = (apdu.Lc + 6) / this.sizeIFSC;
                if (n10 * this.sizeIFSC < apdu.Lc + 6) {
                    ++n10;
                }
                int n11 = n9 = 6 + apdu.Lc;
                int n12 = 0;
                boolean bl = true;
                boolean bl2 = false;
                while (n12 < n10) {
                    int n13;
                    if (n11 > this.sizeIFSC) {
                        n13 = this.sizeIFSC;
                    } else {
                        n13 = n11;
                        bl2 = true;
                    }
                    int n14 = 0;
                    byte[] byArray = new byte[n13];
                    if (bl) {
                        System.arraycopy(apdu.command, 0, byArray, 0, 4);
                        byArray[4] = (byte)apdu.Lc;
                        n14 += 5;
                        bl = false;
                    }
                    if (!bl2) {
                        System.arraycopy(apdu.dataIn, n2, byArray, n14, n13 - n14);
                        n2 += n13 - n14;
                        n14 += n13 - n14;
                    } else {
                        System.arraycopy(apdu.dataIn, n2, byArray, n14, n13 - n14 - 1);
                        byArray[n13 - 1] = (byte)apdu.Le;
                        n2 += n13 - n14;
                        n14 += n13 - n14;
                    }
                    vector.add(byArray);
                    ++n12;
                    n11 -= n13;
                }
                break;
            }
            case 5: {
                byte[] byArray = new byte[7];
                System.arraycopy(apdu.command, 0, byArray, 0, 4);
                byArray[4] = 0;
                byArray[5] = (byte)(apdu.Le >> 8);
                byArray[6] = (byte)apdu.Le;
                vector.add(byArray);
                break;
            }
            case 6: {
                int n15;
                int n16 = (apdu.Lc + 7) / this.sizeIFSC;
                if (n16 * this.sizeIFSC < apdu.Lc + 7) {
                    ++n16;
                }
                int n17 = n15 = 7 + apdu.Lc;
                int n18 = 0;
                boolean bl = true;
                while (n18 < n16) {
                    int n19 = n17 > this.sizeIFSC ? this.sizeIFSC : n17;
                    int n20 = 0;
                    byte[] byArray = new byte[n19];
                    if (bl) {
                        System.arraycopy(apdu.command, 0, byArray, 0, 4);
                        byArray[4] = 0;
                        byArray[5] = (byte)(apdu.Lc >> 8);
                        byArray[6] = (byte)apdu.Lc;
                        n20 += 7;
                        bl = false;
                    }
                    System.arraycopy(apdu.dataIn, n2, byArray, n20, n19 - n20);
                    n2 += n19 - n20;
                    n20 += n19 - n20;
                    vector.add(byArray);
                    ++n18;
                    n17 -= n19;
                }
                break;
            }
            case 7: {
                int n21;
                int n22 = (apdu.Lc + 9) / this.sizeIFSC;
                if (n22 * this.sizeIFSC < apdu.Lc + 9) {
                    ++n22;
                }
                int n23 = n21 = 9 + apdu.Lc;
                int n24 = 0;
                boolean bl = true;
                boolean bl3 = false;
                while (n24 < n22) {
                    int n25;
                    if (n23 > this.sizeIFSC) {
                        n25 = this.sizeIFSC;
                    } else {
                        n25 = n23;
                        bl3 = true;
                    }
                    int n26 = 0;
                    byte[] byArray = new byte[n25];
                    if (bl) {
                        System.arraycopy(apdu.command, 0, byArray, 0, 4);
                        byArray[4] = 0;
                        byArray[5] = (byte)(apdu.Lc >> 8);
                        byArray[6] = (byte)apdu.Lc;
                        n26 += 7;
                        bl = false;
                    }
                    if (!bl3) {
                        if (n23 == n25 + 1) {
                            System.arraycopy(apdu.dataIn, n2, byArray, n26, --n25 - n26);
                            n2 += n25 - n26;
                            n26 += n25 - n26;
                        } else {
                            System.arraycopy(apdu.dataIn, n2, byArray, n26, n25 - n26);
                            n2 += n25 - n26;
                            n26 += n25 - n26;
                        }
                    } else {
                        if (n23 != 2) {
                            System.arraycopy(apdu.dataIn, n2, byArray, n26, n25 - n26 - 2);
                        }
                        byArray[n25 - 2] = (byte)(apdu.Le >> 8);
                        byArray[n25 - 1] = (byte)apdu.Le;
                        n2 += n25 - n26;
                        n26 += n25 - n26;
                    }
                    vector.add(byArray);
                    ++n24;
                    n23 -= n25;
                }
                break;
            }
            default: {
                throw new T1Exception(CadTransportException.STATUS_UNKNOWN);
            }
        }
        return vector;
    }
}

