/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ExportFileManager {
    private String[] export_path;
    private Vector export_files;

    public ExportFileManager(String[] stringArray) {
        this.export_path = stringArray;
        this.export_files = new Vector(20);
    }

    public EfExportFile[] getExportFiles() {
        Object[] objectArray = new EfExportFile[this.export_files.size()];
        this.export_files.copyInto(objectArray);
        return objectArray;
    }

    public EfExportFile load(String string) {
        Object[] objectArray;
        char c = File.separatorChar;
        String string2 = new String(String.valueOf(string.replace('/', c)) + c + "javacard" + c + new String(String.valueOf(Names.getPartialPackageName(string)) + ".exp"));
        int n = 0;
        while (n < this.export_path.length) {
            File file;
            objectArray = this.export_path[n];
            if (!objectArray.endsWith(".jar") && (file = new File((String)objectArray, string2)).isFile()) {
                EfExportFile efExportFile = new EfExportFile();
                try {
                    Notifier.progress("progress.1", file.getCanonicalPath());
                    DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    efExportFile.parse(dataInputStream);
                    efExportFile.resolve();
                    this.export_files.addElement(efExportFile);
                    dataInputStream.close();
                    this.checkBinaryCompatibility(efExportFile);
                    return efExportFile;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object[] objectArray2 = new String[]{new String(String.valueOf(Names.getPartialPackageName(string)) + ".exp"), string.replace('/', '.')};
                    Notifier.error("linking.1", objectArray2);
                    throw new ConverterException();
                }
                catch (IOException iOException) {
                    Notifier.error("converter.1", new String(String.valueOf(Names.getPartialPackageName(string)) + ".exp"));
                    throw new ConverterException();
                }
            }
            ++n;
        }
        objectArray = new String[]{new String(String.valueOf(Names.getPartialPackageName(string)) + ".exp"), string.replace('/', '.')};
        Notifier.error("linking.1", objectArray);
        throw new ConverterException();
    }

    public EfExportFile getExportFile(String string) {
        Enumeration enumeration = this.export_files.elements();
        while (enumeration.hasMoreElements()) {
            EfExportFile efExportFile = (EfExportFile)enumeration.nextElement();
            if (!efExportFile.getPackageName().equals(string)) continue;
            return efExportFile;
        }
        return this.load(string);
    }

    public EfClass getClass(String string) {
        String string2 = Names.getPackageName(string);
        EfExportFile efExportFile = this.getExportFile(string2);
        if (efExportFile == null) {
            return null;
        }
        return efExportFile.getClass(string);
    }

    public EfMethod getMethod(String string, String string2, String string3) {
        EfClass efClass = this.getClass(string);
        if (efClass == null) {
            return null;
        }
        return efClass.getMethod(string2, string3);
    }

    public EfField getField(String string, String string2, String string3) {
        EfClass efClass = this.getClass(string);
        if (efClass == null) {
            return null;
        }
        return efClass.getField(string2, string3);
    }

    private void checkBinaryCompatibility(EfExportFile efExportFile) {
        if (efExportFile.getMajorVersion() != 2) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = efExportFile.getPackageName();
            objectArray[0] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray2)) + ".exp");
            objectArray[1] = "major";
            objectArray2 = objectArray;
            Notifier.error("binary.1", objectArray2);
            throw new ConverterException();
        }
        if (efExportFile.getMinorVersion() != 1) {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = efExportFile.getPackageName();
            objectArray[0] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray3)) + ".exp");
            objectArray[1] = "minor";
            objectArray3 = objectArray;
            Notifier.error("binary.1", objectArray3);
            throw new ConverterException();
        }
    }
}

