/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfConstantPackage;
import com.sun.javacard.exportfile.EfConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfExportFile
extends PackageDefinition {
    public static byte APPLET_PACKAGE;
    public static byte LIBRARY_PACKAGE;
    private int magic = 16435934;
    private byte major_version;
    private byte minor_version;
    private byte flags;
    private EfConstantPool constant_pool;
    private int this_package_index;
    private EfClass[] classes;

    public EfExportFile() {
    }

    public EfExportFile(byte by, byte by2, byte by3, PackageDefinition packageDefinition, EfConstantPool efConstantPool, EfClass[] efClassArray) {
        super(packageDefinition);
        this.major_version = by;
        this.minor_version = by2;
        this.flags = by3;
        this.classes = efClassArray;
        this.constant_pool = efConstantPool;
        this.this_package_index = this.constant_pool.addConstantPackage(packageDefinition, by3);
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.magic = dataInputStream.readInt();
        this.minor_version = dataInputStream.readByte();
        this.major_version = dataInputStream.readByte();
        this.constant_pool = new EfConstantPool();
        this.constant_pool.parse(dataInputStream);
        this.this_package_index = dataInputStream.readUnsignedShort();
        this.classes = new EfClass[dataInputStream.readUnsignedByte()];
        int n = 0;
        while (n < this.classes.length) {
            EfClass efClass = new EfClass(this.constant_pool);
            efClass.parse(dataInputStream);
            this.classes[n] = efClass;
            ++n;
        }
    }

    public void resolve() {
        this.constant_pool.resolve();
        EfConstantPackage efConstantPackage = this.constant_pool.getConstantPackage(this.this_package_index);
        this.package_name = efConstantPackage.getPackageName();
        this.package_minor_version = efConstantPackage.getMinorVersion();
        this.package_major_version = efConstantPackage.getMajorVersion();
        this.aid = efConstantPackage.getAID();
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].resolve();
            ++n;
        }
    }

    public int getMagic() {
        return this.magic;
    }

    public byte getMinorVersion() {
        return this.minor_version;
    }

    public byte getMajorVersion() {
        return this.major_version;
    }

    public int getThisPackageIndex() {
        return this.this_package_index;
    }

    public EfConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public EfClass[] getClasses() {
        return this.classes;
    }

    public EfClass getClass(String string) {
        int n = 0;
        while (n < this.classes.length) {
            if (this.classes[n].getClassName().equals(string)) {
                return this.classes[n];
            }
            ++n;
        }
        return null;
    }

    public void toText(PrintWriter printWriter) throws IOException {
        String string = new String("\t");
        printWriter.println("export file {\t\t// " + this.package_name);
        printWriter.println(String.valueOf(string) + "magic\t" + Strings.toHexString(this.magic) + "\t\t // in hex");
        printWriter.println(String.valueOf(string) + "minor_version\t" + this.minor_version);
        printWriter.println(String.valueOf(string) + "major_version\t" + this.major_version);
        printWriter.println(String.valueOf(string) + "constant_pool_count\t" + this.constant_pool.getSize());
        printWriter.println(String.valueOf(string) + "constant_pool {");
        this.constant_pool.toText(printWriter, 2);
        printWriter.println(String.valueOf(string) + "}");
        printWriter.println(String.valueOf(string) + "this_package\t" + this.this_package_index);
        printWriter.println(String.valueOf(string) + "export_class_count\t" + this.classes.length);
        printWriter.println(String.valueOf(string) + "export_classes {");
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].toText(printWriter, 2);
            ++n;
        }
        printWriter.println(String.valueOf(string) + "}");
        printWriter.println("}");
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.magic);
        dataOutputStream.writeByte(this.minor_version);
        dataOutputStream.writeByte(this.major_version);
        this.constant_pool.toBinary(dataOutputStream);
        dataOutputStream.writeShort(this.this_package_index);
        dataOutputStream.writeByte(this.classes.length);
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].toBinary(dataOutputStream);
            ++n;
        }
    }

    static {
        LIBRARY_PACKAGE = 1;
    }
}

