/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantClassRef;
import com.sun.javacard.exportfile.EfConstantInteger;
import com.sun.javacard.exportfile.EfConstantPackage;
import com.sun.javacard.exportfile.EfConstantUtf8;
import com.sun.javacard.exportfile.ExportFileFormatError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class EfConstantPool {
    Vector constants;

    public EfConstantPool() {
        this.constants = new Vector(50);
    }

    public EfConstantPool(int n) {
        this.constants = new Vector(n);
    }

    public int getSize() {
        return this.constants.size();
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            EfConstant efConstant;
            byte by = dataInputStream.readByte();
            switch (by) {
                case 13: {
                    efConstant = new EfConstantPackage(this);
                    break;
                }
                case 7: {
                    efConstant = new EfConstantClassRef(this);
                    break;
                }
                case 3: {
                    efConstant = new EfConstantInteger(this);
                    break;
                }
                case 1: {
                    efConstant = new EfConstantUtf8(this);
                    break;
                }
                default: {
                    return;
                }
            }
            efConstant.parse(dataInputStream);
            this.constants.addElement(efConstant);
            ++n2;
        }
    }

    public EfConstant[] getConstants() {
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        return objectArray;
    }

    public EfConstant getAt(int n) {
        try {
            return (EfConstant)this.constants.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ExportFileFormatError();
        }
    }

    public EfConstantPackage getConstantPackage(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantPackage)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantPackage)efConstant;
    }

    public EfConstantClassRef getConstantClassRef(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantClassRef)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantClassRef)efConstant;
    }

    public EfConstantInteger getConstantInteger(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantInteger)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantInteger)efConstant;
    }

    public EfConstantUtf8 getConstantUtf8(int n) {
        EfConstant efConstant = this.getAt(n);
        if (!(efConstant instanceof EfConstantUtf8)) {
            throw new ExportFileFormatError();
        }
        return (EfConstantUtf8)efConstant;
    }

    public void resolve() {
        Enumeration enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            EfConstant efConstant = (EfConstant)enumeration.nextElement();
            efConstant.resolve();
        }
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constants.size());
        Enumeration enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            EfConstant efConstant = (EfConstant)enumeration.nextElement();
            efConstant.toBinary(dataOutputStream);
        }
    }

    public int addConstantPackage(PackageDefinition packageDefinition, byte by) {
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof EfConstantPackage) {
                EfConstantPackage efConstantPackage = (EfConstantPackage)objectArray[n];
                if (efConstantPackage.getPackageName().equals(packageDefinition.getPackageName())) {
                    return n;
                }
                throw new ConverterInternalError();
            }
            ++n;
        }
        EfConstantPackage efConstantPackage = new EfConstantPackage(this, packageDefinition, by);
        this.constants.addElement(efConstantPackage);
        return this.constants.size() - 1;
    }

    public int addConstantClassRef(String string) {
        EfConstantClassRef efConstantClassRef;
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof EfConstantClassRef && (efConstantClassRef = (EfConstantClassRef)objectArray[n]).getClassName().equals(string)) {
                return n;
            }
            ++n;
        }
        efConstantClassRef = new EfConstantClassRef(this, string);
        this.constants.addElement(efConstantClassRef);
        return this.constants.size() - 1;
    }

    public int addConstantInteger(int n) {
        EfConstantInteger efConstantInteger;
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof EfConstantInteger && (efConstantInteger = (EfConstantInteger)objectArray[n2]).getIntValue() == n) {
                return n2;
            }
            ++n2;
        }
        efConstantInteger = new EfConstantInteger(this, n);
        this.constants.addElement(efConstantInteger);
        return this.constants.size() - 1;
    }

    public int addConstantUtf8(String string) {
        EfConstantUtf8 efConstantUtf8;
        Object[] objectArray = new EfConstant[this.constants.size()];
        this.constants.copyInto(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof EfConstantUtf8 && (efConstantUtf8 = (EfConstantUtf8)objectArray[n]).getUtf8String().equals(string)) {
                return n;
            }
            ++n;
        }
        efConstantUtf8 = new EfConstantUtf8(this, string);
        this.constants.addElement(efConstantUtf8);
        return this.constants.size() - 1;
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        stringBuffer.toString();
        Enumeration enumeration = this.constants.elements();
        while (enumeration.hasMoreElements()) {
            EfConstant efConstant = (EfConstant)enumeration.nextElement();
            efConstant.toText(printWriter, n);
        }
    }
}

