/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfConstantUtf8;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfConstantPackage
extends EfConstant {
    private byte flags;
    private int name_index;
    private byte minor_version;
    private byte major_version;
    private byte[] aid;
    private String package_name;
    private EfConstantPool constant_pool;

    public EfConstantPackage(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfConstantPackage(EfConstantPool efConstantPool, PackageDefinition packageDefinition, byte by) {
        this.constant_pool = efConstantPool;
        this.flags = by;
        this.minor_version = packageDefinition.getPackageMinorVersion();
        this.major_version = packageDefinition.getPackageMajorVersion();
        this.aid = packageDefinition.getAID();
        this.package_name = packageDefinition.getPackageName();
        EfConstant[] efConstantArray = efConstantPool.getConstants();
        int n = 0;
        while (n < efConstantArray.length) {
            EfConstantUtf8 efConstantUtf8;
            if (efConstantArray[n] instanceof EfConstantUtf8 && (efConstantUtf8 = (EfConstantUtf8)efConstantArray[n]).getUtf8String().equals(this.package_name)) {
                this.name_index = n;
                return;
            }
            ++n;
        }
        this.name_index = this.constant_pool.addConstantUtf8(this.package_name);
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.flags = dataInputStream.readByte();
        this.name_index = dataInputStream.readUnsignedShort();
        this.minor_version = dataInputStream.readByte();
        this.major_version = dataInputStream.readByte();
        this.aid = new byte[dataInputStream.readUnsignedByte()];
        dataInputStream.readFully(this.aid);
    }

    public void resolve() {
        this.package_name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        String string = stringBuffer.toString();
        printWriter.println(String.valueOf(string) + "CONSTANT_Package_info {");
        printWriter.println(String.valueOf(string) + "\ttag\t" + 13);
        printWriter.println(String.valueOf(string) + "\tflags\t" + Integer.toHexString(this.flags));
        printWriter.println(String.valueOf(string) + "\tname_index\t" + this.name_index + "\t\t// " + this.package_name);
        printWriter.println(String.valueOf(string) + "\tminor_version\t" + this.minor_version);
        printWriter.println(String.valueOf(string) + "\tmajor_version\t" + this.major_version);
        printWriter.println(String.valueOf(string) + "\taid_length\t" + this.aid.length);
        printWriter.println(String.valueOf(string) + "\taid\t" + Strings.toHexString(this.aid, ":"));
        printWriter.println(String.valueOf(string) + "}");
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(13);
        dataOutputStream.writeByte(this.flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeByte(this.minor_version);
        dataOutputStream.writeByte(this.major_version);
        dataOutputStream.writeByte(this.aid.length);
        dataOutputStream.write(this.aid, 0, this.aid.length);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public byte getMinorVersion() {
        return this.minor_version;
    }

    public byte getMajorVersion() {
        return this.major_version;
    }

    public byte[] getAID() {
        return this.aid;
    }

    public String getPackageName() {
        return this.package_name;
    }
}

