/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Notifier {
    private static final int NO_LINE_NUMBER = -1;
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    protected static boolean no_warn;
    protected static boolean no_banner;
    protected static PrintWriter progress_writer;
    protected static PrintWriter error_writer;
    protected static PrintWriter output_writer;
    protected static int error_count;
    protected static int warning_count;
    protected static boolean verbose;

    public static int getErrorCount() {
        return error_count;
    }

    public static int getWarningCount() {
        return warning_count;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static PrintWriter getProgressWriter() {
        return progress_writer;
    }

    public static PrintWriter getErrorWriter() {
        return error_writer;
    }

    public static PrintWriter getOutputWriter() {
        return output_writer;
    }

    public static void setNoWarningFlag(boolean bl) {
        no_warn = bl;
    }

    public static boolean getNoWarningFlag() {
        return no_warn;
    }

    public static void setNoBannerFlag(boolean bl) {
        no_banner = bl;
    }

    public static boolean getNoBannerFlag() {
        return no_banner;
    }

    public static void setVerboseFlag(boolean bl) {
        verbose = bl;
    }

    public static boolean getVerboseFlag() {
        return verbose;
    }

    public static void setProgressWriter(PrintWriter printWriter) {
        progress_writer = printWriter;
    }

    public static void setErrorWriter(PrintWriter printWriter) {
        error_writer = printWriter;
    }

    public static void setOutputWriter(PrintWriter printWriter) {
        output_writer = printWriter;
    }

    public static void newLine() {
        if (!no_banner) {
            output_writer.println();
        }
    }

    public static void out(String string) {
        if (!no_banner) {
            output_writer.println(messages.getString(string));
        }
    }

    public static void out(String string, String string2) {
        if (!no_banner) {
            Object[] objectArray = new Object[]{string2};
            output_writer.println(MessageFormat.format(messages.getString(string), objectArray));
        }
    }

    public static void out(String string, Object[] objectArray) {
        if (!no_banner) {
            output_writer.println(MessageFormat.format(messages.getString(string), objectArray));
        }
    }

    public static void error(int n, String string) {
        ++error_count;
        if (n > 0) {
            Object[] objectArray = new String[]{String.valueOf(n)};
            error_writer.print(MessageFormat.format(messages.getString("key.error.linenumber"), objectArray));
        } else {
            error_writer.print(messages.getString("key.error"));
        }
        error_writer.println(messages.getString(string));
    }

    public static void error(String string) {
        Notifier.error(-1, string);
    }

    public static void error(int n, String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        Notifier.error(n, string, objectArray);
    }

    public static void error(String string, String string2) {
        Notifier.error(-1, string, string2);
    }

    public static void error(int n, String string, Object[] objectArray) {
        ++error_count;
        if (n > 0) {
            Object[] objectArray2 = new String[]{String.valueOf(n)};
            error_writer.print(MessageFormat.format(messages.getString("key.error.linenumber"), objectArray2));
        } else {
            error_writer.print(messages.getString("key.error"));
        }
        error_writer.println(MessageFormat.format(messages.getString(string), objectArray));
    }

    public static void error(String string, Object[] objectArray) {
        Notifier.error(-1, string, objectArray);
    }

    public static void warning(int n, String string) {
        ++warning_count;
        if (no_warn) {
            return;
        }
        if (n > 0) {
            Object[] objectArray = new String[]{String.valueOf(n)};
            error_writer.print(MessageFormat.format(messages.getString("key.warning.linenumber"), objectArray));
        } else {
            error_writer.print(messages.getString("key.warning"));
        }
        error_writer.println(messages.getString(string));
    }

    public static void warning(String string) {
        Notifier.warning(-1, string);
    }

    public static void warning(int n, String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        Notifier.warning(n, string, objectArray);
    }

    public static void warning(String string, String string2) {
        Notifier.warning(-1, string, string2);
    }

    public static void warning(int n, String string, Object[] objectArray) {
        ++warning_count;
        if (no_warn) {
            return;
        }
        if (n > 0) {
            Object[] objectArray2 = new String[]{String.valueOf(n)};
            error_writer.print(MessageFormat.format(messages.getString("key.warning.linenumber"), objectArray2));
        } else {
            error_writer.print(messages.getString("key.warning"));
        }
        error_writer.println(MessageFormat.format(messages.getString(string), objectArray));
    }

    public static void warning(String string, Object[] objectArray) {
        Notifier.warning(-1, string, objectArray);
    }

    public static void progress(String string) {
        if (verbose && !no_banner) {
            output_writer.println(messages.getString(string));
        }
    }

    public static void progress(String string, String string2) {
        if (verbose) {
            Notifier.out(string, string2);
        }
    }

    public static void progress(String string, Object[] objectArray) {
        if (verbose && !no_banner) {
            output_writer.println(MessageFormat.format(messages.getString(string), objectArray));
        }
    }

    static {
        progress_writer = new PrintWriter(System.out, true);
        error_writer = new PrintWriter(System.err, true);
        output_writer = new PrintWriter(System.out, true);
    }
}

