/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import com.sun.javacard.converter.util.MethodDescriptor;

public class Names {
    public static String getPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return new String("");
        }
        return string.substring(0, n);
    }

    public static String getClassName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getClassNameFromDescriptor(String string) {
        if (string.startsWith("L")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("[L")) {
            return string.substring(2, string.length() - 1);
        }
        return null;
    }

    public static String getPartialPackageName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(++n, string.length());
    }

    public static String getMethodNameInJavaStyle(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(string) + "(");
        String[] stringArray = MethodDescriptor.getParamDescriptors(string2);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(Names.getTypeStringInJavaStyle(stringArray[n]));
            if (n != stringArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String getTypeStringInJavaStyle(String string) {
        if (string.equals("V")) {
            return "void";
        }
        if (string.equals("B")) {
            return "byte";
        }
        if (string.equals("S")) {
            return "short";
        }
        if (string.equals("I")) {
            return "int";
        }
        if (string.equals("Z")) {
            return "boolean";
        }
        if (string.equals("[B")) {
            return "byte[]";
        }
        if (string.equals("[S")) {
            return "short[]";
        }
        if (string.equals("[I")) {
            return "int[]";
        }
        if (string.equals("[Z")) {
            return "boolean[]";
        }
        if (string.equals("J")) {
            return "long";
        }
        if (string.equals("F")) {
            return "float";
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("C")) {
            return "char";
        }
        if (string.startsWith("L") || string.startsWith("[L")) {
            return Names.getClassNameFromDescriptor(string).replace('/', '.');
        }
        if (string.equals("[J")) {
            return "long[]";
        }
        if (string.equals("[F")) {
            return "float[]";
        }
        if (string.equals("[D")) {
            return "double[]";
        }
        if (string.equals("[C")) {
            return "char[]";
        }
        return null;
    }

    public static String getExportFileName(String string) {
        return new String(String.valueOf(Names.getPartialPackageName(string)) + ".exp");
    }

    public static String getJcaFileName(String string) {
        return new String(String.valueOf(Names.getPartialPackageName(string)) + ".jca");
    }
}

