/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrIncrement;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class SincInstrOptimizer {
    JcPackage jc_package;
    private int index;
    private int const_value;
    private JcInstruction store_instr;

    public SincInstrOptimizer(JcPackage jcPackage) {
        this.jc_package = jcPackage;
    }

    public JcPackage optimize() {
        JcClass[] jcClassArray = this.jc_package.getClasses();
        int n = 0;
        while (n < jcClassArray.length) {
            JcClass jcClass = jcClassArray[n];
            JcMethod[] jcMethodArray = jcClass.getMethods();
            int n2 = 0;
            while (n2 < jcMethodArray.length) {
                JcMethod jcMethod = jcMethodArray[n2];
                this.optimizeByteCode(jcMethod);
                ++n2;
            }
            ++n;
        }
        return this.jc_package;
    }

    /*
     * Unable to fully structure code
     */
    private void optimizeByteCode(JcMethod var1_1) {
        var2_2 = var1_1.getCode();
        if (var2_2 != null) ** GOTO lbl27
        return;
lbl-1000:
        // 1 sources

        {
            this.index = 0;
            this.const_value = 0;
            this.store_instr = null;
            var3_3 = false;
            var3_3 = this.examinePatten(var2_2);
            if (var3_3) {
                var4_4 = new JcInstrIncrement(89, this.index, this.const_value);
                var5_5 = var2_2.getLabel();
                var4_4.setLabel(var5_5);
                var6_6 = var2_2.getSourceLineNumber();
                var4_4.setSourceLineNumber(var6_6);
                var7_7 = var2_2.getPrevInstr();
                if (var7_7 == null) {
                    var1_1.setCode(var4_4);
                } else {
                    var7_7.setNextInstr(var4_4);
                    var4_4.setPrevInstr(var7_7);
                }
                var8_8 = this.store_instr.getNextInstr();
                var4_4.setNextInstr(var8_8);
                if (var8_8 != null) {
                    var8_8.setPrevInstr(var4_4);
                }
                var2_2 = var4_4;
            }
            var2_2 = var2_2.getNextInstr();
lbl27:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl28:
        // 1 sources

    }

    private boolean examinePatten(JcInstruction jcInstruction) {
        if (!this.checkLoadInstr(jcInstruction)) {
            return false;
        }
        JcInstruction jcInstruction2 = jcInstruction.getNextInstr();
        if (!this.checkConstantInstr(jcInstruction2)) {
            return false;
        }
        if (!this.checkArithmeticInstr(jcInstruction2 = jcInstruction2.getNextInstr())) {
            return false;
        }
        return this.checkStoreInstr(jcInstruction2 = jcInstruction2.getNextInstr());
    }

    private boolean checkLoadInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        switch (n) {
            case 28: {
                this.index = 0;
                return true;
            }
            case 29: {
                this.index = 1;
                return true;
            }
            case 30: {
                this.index = 2;
                return true;
            }
            case 31: {
                this.index = 3;
                return true;
            }
            case 22: {
                this.index = ((JcInstrByteIndex)jcInstruction).getIndex();
                return true;
            }
        }
        return false;
    }

    private boolean checkConstantInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        switch (n) {
            case 2: {
                this.const_value = -1;
                return true;
            }
            case 3: {
                this.const_value = 0;
                return true;
            }
            case 4: {
                this.const_value = 1;
                return true;
            }
            case 5: {
                this.const_value = 2;
                return true;
            }
            case 6: {
                this.const_value = 3;
                return true;
            }
            case 7: {
                this.const_value = 4;
                return true;
            }
            case 8: {
                this.const_value = 5;
                return true;
            }
            case 16: {
                this.const_value = ((JcInstrByteValue)jcInstruction).getValue();
                return true;
            }
        }
        return false;
    }

    private boolean checkArithmeticInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        if (n == 65) {
            return true;
        }
        if (n == 67) {
            this.const_value = -this.const_value;
            return true;
        }
        return false;
    }

    private boolean checkStoreInstr(JcInstruction jcInstruction) {
        if (jcInstruction == null) {
            return false;
        }
        int n = jcInstruction.getOpcode();
        switch (n) {
            case 47: {
                if (this.index == 0) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 48: {
                if (this.index == 1) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 49: {
                if (this.index == 2) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 50: {
                if (this.index == 3) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
            case 41: {
                int n2 = ((JcInstrByteIndex)jcInstruction).getIndex();
                if (n2 == this.index) {
                    this.store_instr = jcInstruction;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void reset() {
        this.index = 0;
        this.const_value = 0;
        this.store_instr = null;
    }
}

