/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.LinkException;
import com.sun.javacard.converter.converters.BaseClassInterfaceConverter;
import com.sun.javacard.converter.converters.ClassConverter;
import com.sun.javacard.converter.converters.InterfaceConverter;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import java.lang.reflect.Modifier;

public class PackageConverter {
    private JPackage java_package;
    private ExportFileManager export_file_manager;
    private JcPackage jc_package;
    private boolean int_support = false;
    private boolean this_exp_provided = false;
    private boolean convert_bc = false;
    private JcConstantPool jc_cp;
    private boolean[] completion_flags;
    private ConversionProfile conversion_profile;

    public PackageConverter(JPackage jPackage, ConversionProfile conversionProfile, ExportFileManager exportFileManager) {
        this.java_package = jPackage;
        this.jc_package = new JcPackage(jPackage);
        this.jc_cp = new JcConstantPool();
        this.jc_package.setConstantPool(this.jc_cp);
        this.jc_package.setAID(conversionProfile.package_profile.aid);
        this.jc_package.setPackageMajorVersion(conversionProfile.package_profile.major_version);
        this.jc_package.setPackageMinorVersion(conversionProfile.package_profile.minor_version);
        this.conversion_profile = conversionProfile;
        this.export_file_manager = exportFileManager;
        this.int_support = conversionProfile.int_supported;
        this.this_exp_provided = conversionProfile.this_exp_provided;
        if (conversionProfile.output == 2) {
            this.convert_bc = false;
            return;
        }
        this.convert_bc = true;
    }

    public JPackage getJavaPackage() {
        return this.java_package;
    }

    public JcPackage getJcPackage() {
        return this.jc_package;
    }

    public JcConstantPool getJcConstantPool() {
        return this.jc_cp;
    }

    public ExportFileManager getExportFileManager() {
        return this.export_file_manager;
    }

    public boolean isIntSupported() {
        return this.int_support;
    }

    public boolean isThisExpProvided() {
        return this.this_exp_provided;
    }

    public boolean convertByteCode() {
        return this.convert_bc;
    }

    public void setIntFlag(boolean bl) {
        this.jc_package.setIntFlag(bl);
    }

    public JcPackage convert() {
        try {
            JcAppletInfo[] jcAppletInfoArray = this.constructAppletInfos();
            this.jc_package.setAppletInfos(jcAppletInfoArray);
            JClassFile[] jClassFileArray = this.java_package.getClasses();
            this.sortClasses(jClassFileArray);
            JcClass[] jcClassArray = new JcClass[jClassFileArray.length];
            this.jc_package.setClasses(jcClassArray);
            this.completion_flags = new boolean[jClassFileArray.length];
            int n = 0;
            while (n < jClassFileArray.length) {
                JClassFile jClassFile = jClassFileArray[n];
                try {
                    BaseClassInterfaceConverter baseClassInterfaceConverter;
                    Notifier.progress("progress.2", jClassFile.getClassName().replace('/', '.'));
                    if (!Names.getPackageName(jClassFile.getClassName()).equals(this.java_package.getPackageName())) {
                        Object[] objectArray = new Object[]{jClassFile.getClassName().replace('/', '.'), this.java_package.getPackageName().replace('/', '.')};
                        Notifier.error("conversion.1", objectArray);
                        throw new ConverterException();
                    }
                    int n2 = jClassFile.getAccessFlags();
                    if (Modifier.isInterface(n2)) {
                        baseClassInterfaceConverter = new InterfaceConverter(jClassFile, this);
                        jcClassArray[n] = ((InterfaceConverter)baseClassInterfaceConverter).convert();
                    } else {
                        baseClassInterfaceConverter = new ClassConverter(jClassFile, this);
                        jcClassArray[n] = ((ClassConverter)baseClassInterfaceConverter).convert();
                    }
                    this.completion_flags[n] = true;
                }
                catch (ConverterException converterException) {
                    jcClassArray[n] = new JcClass(jClassFileArray[n]);
                }
                ++n;
            }
            this.assignClassTokens(jcClassArray);
            this.jc_cp.setIndex();
        }
        catch (ConverterException converterException) {}
        return this.jc_package;
    }

    private JcAppletInfo[] constructAppletInfos() {
        AppletProfile[] appletProfileArray = this.conversion_profile.applets_profile;
        JcAppletInfo[] jcAppletInfoArray = new JcAppletInfo[appletProfileArray.length];
        int n = 0;
        while (n < appletProfileArray.length) {
            jcAppletInfoArray[n] = new JcAppletInfo(appletProfileArray[n].install_class, appletProfileArray[n].aid);
            ++n;
        }
        return jcAppletInfoArray;
    }

    private void assignClassTokens(JcClass[] jcClassArray) {
        if (this.this_exp_provided) {
            int n = 0;
            while (n < jcClassArray.length) {
                JcClass jcClass = jcClassArray[n];
                if (Modifier.isPublic(jcClass.getAccessFlags())) {
                    EfClass efClass = this.export_file_manager.getClass(jcClass.getClassName());
                    if (efClass == null) {
                        Object[] objectArray = new String[3];
                        objectArray[0] = this.java_package.getPackageName().replace('/', '.');
                        objectArray[1] = jcClass.getClassName().replace('/', '.');
                        Object[] objectArray2 = this.java_package.getPackageName();
                        objectArray[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray2)) + ".exp");
                        objectArray2 = objectArray;
                        Notifier.error("linking.6", objectArray2);
                        throw new LinkException();
                    }
                    jcClass.setClassToken(efClass.getClassToken());
                } else {
                    jcClass.setClassToken(255);
                }
                ++n;
            }
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < jcClassArray.length) {
            JcClass jcClass = jcClassArray[n2];
            if (Modifier.isPublic(jcClass.getAccessFlags())) {
                jcClass.setClassToken(n++);
            } else {
                jcClass.setClassToken(255);
            }
            ++n2;
        }
    }

    private void sortClasses(JClassFile[] jClassFileArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < jClassFileArray.length) {
            JClassFile jClassFile = jClassFileArray[n2];
            int n3 = jClassFile.getAccessFlags();
            if (Modifier.isInterface(n3)) {
                if (n2 > n) {
                    jClassFileArray[n2] = jClassFileArray[n];
                    jClassFileArray[n] = jClassFile;
                }
                ++n;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < jClassFileArray.length) {
            Object object;
            JClassFile jClassFile = jClassFileArray[n4];
            int n5 = jClassFile.getAccessFlags();
            if (Modifier.isInterface(n5)) {
                object = jClassFile.getInterfaceNames();
                int n6 = 0;
                while (n6 < ((String[])object).length) {
                    String string = object[n6];
                    if (this.swapClass(n4, string)) {
                        --n4;
                        break;
                    }
                    ++n6;
                }
            } else {
                object = jClassFile.getSuperClassName();
                if (object != null && this.swapClass(n4, (String)object)) {
                    --n4;
                }
            }
            ++n4;
        }
    }

    private boolean swapClass(int n, String string) {
        JClassFile[] jClassFileArray = this.java_package.getClasses();
        int n2 = n + 1;
        while (n2 < jClassFileArray.length) {
            JClassFile jClassFile = jClassFileArray[n2];
            if (jClassFile.getClassName().equals(string)) {
                jClassFileArray[n2] = jClassFileArray[n];
                jClassFileArray[n] = jClassFile;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public JcClass getJcClass(String string) {
        JcClass[] jcClassArray = this.jc_package.getClasses();
        int n = 0;
        while (n < jcClassArray.length) {
            String string2 = jcClassArray[n].getClassName();
            if (string2.equals(string)) {
                if (this.completion_flags[n]) {
                    return jcClassArray[n];
                }
                throw new ConversionException();
            }
            ++n;
        }
        throw new ConverterInternalError();
    }
}

