/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.classfile.instructions.JInstrIntBranch;
import com.sun.javacard.classfile.instructions.JInstrLookupSwitch;
import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.classfile.instructions.JInstrTableSwitch;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.ClassConverter;
import com.sun.javacard.converter.converters.ExceptionTableConverter;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.LocalVariableConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.converters.RollBackException;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

public class MethodConverter {
    private JMethod java_method;
    private JcMethod jc_method;
    private ClassConverter c_converter;
    private PackageConverter p_converter;
    private InstrContainer instr_containers;
    private LocalVariableConverter local_var_converter;
    private JcLocalVariable[] jc_locals;
    private JcException[] jc_exceptions;
    private int nargs;
    private int max_locals;
    private int max_stack;

    public MethodConverter(JMethod jMethod, ClassConverter classConverter, PackageConverter packageConverter) {
        this.java_method = jMethod;
        this.c_converter = classConverter;
        this.p_converter = packageConverter;
        this.jc_method = new JcMethod(jMethod);
    }

    public InstrContainer getInstrContainers() {
        return this.instr_containers;
    }

    public boolean isIntSupported() {
        return this.p_converter.isIntSupported();
    }

    public JcConstantPool getJcConstantPool() {
        return this.p_converter.getJcConstantPool();
    }

    public String getClassName() {
        return this.c_converter.getJavaClass().getClassName();
    }

    public String getMethodName() {
        return this.java_method.getMethodName();
    }

    public String getMethodDescriptor() {
        return this.java_method.getMethodDescriptor();
    }

    public ClassConverter getClassConverter() {
        return this.c_converter;
    }

    public PackageConverter getPackageConverter() {
        return this.p_converter;
    }

    public JMethod getJavaMethod() {
        return this.java_method;
    }

    public JcMethod getJcMethod() {
        return this.jc_method;
    }

    public JcMethod convert() {
        Object object;
        if (!this.p_converter.convertByteCode()) {
            return this.jc_method;
        }
        JInstruction jInstruction = this.java_method.getCode();
        if (jInstruction == null) {
            this.jc_exceptions = new JcException[0];
            this.jc_method.setExceptions(this.jc_exceptions);
            this.jc_locals = new JcLocalVariable[0];
            this.jc_method.setLocalVariables(this.jc_locals);
            this.setNargs();
            return this.jc_method;
        }
        this.local_var_converter = new LocalVariableConverter(this);
        this.jc_locals = this.local_var_converter.convert();
        this.jc_method.setLocalVariables(this.jc_locals);
        this.constructInstrContainers(jInstruction);
        this.constructControlFlowGraph();
        this.jc_exceptions = this.constructExceptions();
        this.jc_method.setExceptions(this.jc_exceptions);
        boolean bl = false;
        this.instr_containers.setOperandStack(new OperandStack());
        while (!bl) {
            bl = true;
            object = this.instr_containers;
            while (object != null) {
                try {
                    Object object2;
                    if (((InstrContainer)object).isCatchFinallyBlockLeader() && ((InstrContainer)object).getOperandStack() == null) {
                        object2 = new OperandStack();
                        ((OperandStack)object2).push(10, null);
                        ((InstrContainer)object).setOperandStack((OperandStack)object2);
                    }
                    if (((InstrContainer)object).hasChanged()) {
                        bl = false;
                        ((InstrContainer)object).reset();
                        ((InstrContainer)object).getJInstr();
                        object2 = InstructionConverter.create((InstrContainer)object, this);
                        JcInstruction jcInstruction = ((InstructionConverter)object2).convert();
                        ((InstrContainer)object).setJcInstr(jcInstruction);
                        this.checkForcedTypeAndPromote((InstrContainer)object);
                        this.propagateInfo((InstrContainer)object);
                        this.setSourceLineNumber((InstrContainer)object);
                        this.setJcInstrLabel((InstrContainer)object);
                        ((InstrContainer)object).setChangedFlag(false);
                    }
                    object = ((InstrContainer)object).getNextInstrContainer();
                }
                catch (RollBackException rollBackException) {
                    object = rollBackException.getRollBackPoint();
                    ((InstrContainer)object).setForcedType(3);
                    ((InstrContainer)object).setChangedFlag(true);
                }
            }
        }
        object = this.linkJcInstructions();
        this.jc_method.setCode((JcInstruction)object);
        this.setNargs();
        this.setMaxLocals();
        this.setMaxStack();
        return this.jc_method;
    }

    private void constructInstrContainers(JInstruction jInstruction) {
        InstrContainer instrContainer = this.instr_containers = new InstrContainer(jInstruction);
        while (jInstruction.getNextInstr() != null) {
            jInstruction = jInstruction.getNextInstr();
            InstrContainer instrContainer2 = new InstrContainer(jInstruction);
            instrContainer.setNextInstrContainer(instrContainer2);
            instrContainer2.setPrevInstrContainer(instrContainer);
            instrContainer = instrContainer2;
        }
    }

    private void constructControlFlowGraph() {
        this.instr_containers.setLabelFlag(true);
        this.linkExceptions();
        InstrContainer instrContainer = this.instr_containers;
        while (instrContainer != null) {
            InstrContainer instrContainer2;
            JInstruction jInstruction = instrContainer.getJInstr();
            if (jInstruction instanceof JInstrShortBranch) {
                this.linkShortBranchInstr(instrContainer);
            } else if (jInstruction instanceof JInstrIntBranch) {
                this.linkIntBranchInstr(instrContainer);
            } else if (jInstruction instanceof JInstrTableSwitch || jInstruction instanceof JInstrLookupSwitch) {
                this.linkSwitchInstr(instrContainer);
            } else if (this.isUnconditionalBranch(jInstruction)) {
                instrContainer2 = instrContainer.getNextInstrContainer();
                if (instrContainer2 != null) {
                    instrContainer2.setLabelFlag(true);
                }
            } else {
                instrContainer2 = instrContainer.getNextInstrContainer();
                if (instrContainer2 != null) {
                    instrContainer.link(instrContainer2);
                }
            }
            instrContainer = instrContainer.getNextInstrContainer();
        }
        this.linkRetInstructions();
        this.setContainerLabels();
    }

    private void linkShortBranchInstr(InstrContainer instrContainer) {
        JInstruction jInstruction = instrContainer.getJInstr();
        int n = ((JInstrShortBranch)jInstruction).getBranchOffset();
        InstrContainer instrContainer2 = this.findTargetInstrContainer(jInstruction.getPC(), n);
        instrContainer2.setLabelFlag(true);
        instrContainer.link(instrContainer2);
        InstrContainer instrContainer3 = instrContainer.getNextInstrContainer();
        if (instrContainer3 != null) {
            instrContainer3.setLabelFlag(true);
            if (!this.isUnconditionalBranch(jInstruction)) {
                instrContainer.link(instrContainer3);
            }
        }
    }

    private void linkIntBranchInstr(InstrContainer instrContainer) {
        JInstruction jInstruction = instrContainer.getJInstr();
        int n = ((JInstrIntBranch)jInstruction).getBranchOffset();
        InstrContainer instrContainer2 = this.findTargetInstrContainer(jInstruction.getPC(), n);
        instrContainer2.setLabelFlag(true);
        instrContainer.link(instrContainer2);
        InstrContainer instrContainer3 = instrContainer.getNextInstrContainer();
        if (instrContainer3 != null) {
            instrContainer3.setLabelFlag(true);
            instrContainer.link(instrContainer3);
        }
    }

    private void linkSwitchInstr(InstrContainer instrContainer) {
        JInstruction jInstruction;
        InstrContainer instrContainer2 = instrContainer.getNextInstrContainer();
        if (instrContainer2 != null) {
            instrContainer2.setLabelFlag(true);
        }
        int n = (jInstruction = instrContainer.getJInstr()) instanceof JInstrTableSwitch ? ((JInstrTableSwitch)jInstruction).getDefaultBranchOffset() : ((JInstrLookupSwitch)jInstruction).getDefaultBranchOffset();
        InstrContainer instrContainer3 = this.findTargetInstrContainer(jInstruction.getPC(), n);
        if (instrContainer3 != null) {
            instrContainer3.setLabelFlag(true);
            instrContainer.link(instrContainer3);
        }
        int[] nArray = jInstruction instanceof JInstrTableSwitch ? ((JInstrTableSwitch)jInstruction).getBranchOffsets() : ((JInstrLookupSwitch)jInstruction).getMatchOffsets();
        int n2 = 0;
        while (n2 < nArray.length) {
            instrContainer3 = this.findTargetInstrContainer(jInstruction.getPC(), nArray[n2]);
            if (instrContainer3 != null) {
                instrContainer3.setLabelFlag(true);
                instrContainer.link(instrContainer3);
            }
            ++n2;
        }
    }

    private void linkRetInstructions() {
        InstrContainer instrContainer = this.instr_containers;
        while (instrContainer != null) {
            JInstruction jInstruction = instrContainer.getJInstr();
            if (jInstruction.getOpcode() == 168) {
                InstrContainer instrContainer2 = instrContainer.findRetInstrContainer();
                if (instrContainer2 == null) {
                    throw new ConverterInternalError();
                }
                InstrContainer instrContainer3 = instrContainer.getNextInstrContainer();
                if (instrContainer3 == null) {
                    throw new ConverterInternalError();
                }
                instrContainer2.link(instrContainer3);
            }
            instrContainer = instrContainer.getNextInstrContainer();
        }
    }

    private void linkExceptions() {
        JCodeAttr jCodeAttr = this.java_method.getCodeAttr();
        JExceptionRecord[] jExceptionRecordArray = jCodeAttr.getExceptions();
        int n = 0;
        while (n < jExceptionRecordArray.length) {
            int n2 = jExceptionRecordArray[n].getStartPc();
            InstrContainer instrContainer = this.findTargetInstrContainer(0, n2);
            instrContainer.setLabelFlag(true);
            int n3 = jExceptionRecordArray[n].getEndPc();
            instrContainer = this.findTargetInstrContainer(0, n3);
            instrContainer.setLabelFlag(true);
            int n4 = jExceptionRecordArray[n].getHandlerPc();
            instrContainer = this.findTargetInstrContainer(0, n4);
            instrContainer.setLabelFlag(true);
            instrContainer.setCatchFinallyBlockLeader(true);
            ++n;
        }
    }

    private void setContainerLabels() {
        InstrContainer instrContainer = this.instr_containers;
        int n = 0;
        while (instrContainer != null) {
            if (instrContainer.hasLabel()) {
                instrContainer.setLabel(n);
                ++n;
            }
            instrContainer = instrContainer.getNextInstrContainer();
        }
    }

    private InstrContainer findTargetInstrContainer(int n, int n2) {
        int n3 = n + n2;
        InstrContainer instrContainer = this.instr_containers;
        while (instrContainer != null) {
            if (instrContainer.getJInstr().getPC() == n3) {
                return instrContainer;
            }
            instrContainer = instrContainer.getNextInstrContainer();
        }
        throw new ConverterInternalError();
    }

    private JcException[] constructExceptions() {
        ExceptionTableConverter exceptionTableConverter = new ExceptionTableConverter(this);
        return exceptionTableConverter.convert();
    }

    private JcLocalVariable[] computeLocals() {
        this.local_var_converter = new LocalVariableConverter(this);
        return this.local_var_converter.convert();
    }

    public LocalVariableConverter getLocalVariableConverter() {
        return this.local_var_converter;
    }

    public void setMaxLocals() {
        JCodeAttr jCodeAttr;
        this.max_locals = !this.isIntSupported() ? ((jCodeAttr = this.java_method.getCodeAttr()) == null ? 0 : jCodeAttr.getMaxLocals()) : this.local_var_converter.getDefinedLocalVariablesSize() + this.local_var_converter.getUndefinedLocalVariablesSize();
        if (this.max_locals != 0) {
            this.max_locals -= this.nargs;
        }
        this.jc_method.setMaxLocals(this.max_locals);
    }

    private void setNargs() {
        String string = this.jc_method.getMethodDescriptor();
        this.nargs = MethodDescriptor.getParamSize(string);
        int n = this.jc_method.getAccessFlags();
        if (!Modifier.isStatic(n)) {
            ++this.nargs;
        }
        this.jc_method.setNargs(this.nargs);
    }

    private void setMaxStack() {
        int n = 0;
        InstrContainer instrContainer = this.instr_containers;
        while (instrContainer != null) {
            OperandStack operandStack = instrContainer.getOperandStack();
            if (n < operandStack.getMaxStackSize()) {
                n = operandStack.getMaxStackSize();
            }
            instrContainer = instrContainer.getNextInstrContainer();
        }
        this.jc_method.setMaxStack(n);
    }

    private boolean isUnconditionalBranch(JInstruction jInstruction) {
        int n = jInstruction.getOpcode();
        switch (n) {
            case 167: 
            case 168: 
            case 169: 
            case 172: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    private void checkForcedTypeAndPromote(InstrContainer instrContainer) {
        if (instrContainer.getForcedType() != 3) {
            return;
        }
        OperandStack operandStack = instrContainer.getOperandStack();
        OperandStackEntry operandStackEntry = operandStack.peek(1);
        if (operandStackEntry.getType() == 3) {
            return;
        }
        JcInstruction jcInstruction = instrContainer.getJcInstr();
        if (jcInstruction == null) {
            if (operandStackEntry.getType() == 2 || operandStackEntry.getType() == 1) {
                JcInstrNoOperands jcInstrNoOperands = new JcInstrNoOperands(92);
                instrContainer.setJcInstr(jcInstrNoOperands);
                operandStack.promote(1);
                return;
            }
            throw new ConverterInternalError();
        }
        switch (jcInstruction.getOpcode()) {
            case 2: {
                jcInstruction.setOpcode(9);
                break;
            }
            case 3: {
                jcInstruction.setOpcode(10);
                break;
            }
            case 4: {
                jcInstruction.setOpcode(11);
                break;
            }
            case 5: {
                jcInstruction.setOpcode(12);
                break;
            }
            case 6: {
                jcInstruction.setOpcode(13);
                break;
            }
            case 7: {
                jcInstruction.setOpcode(14);
                break;
            }
            case 8: {
                jcInstruction.setOpcode(15);
                break;
            }
            case 16: {
                jcInstruction.setOpcode(18);
                break;
            }
            case 17: {
                jcInstruction.setOpcode(19);
                break;
            }
            default: {
                JcInstrNoOperands jcInstrNoOperands = new JcInstrNoOperands(92);
                if (jcInstruction == null) {
                    jcInstruction = jcInstrNoOperands;
                    instrContainer.setJcInstr(jcInstruction);
                    break;
                }
                jcInstruction.setNextInstr(jcInstrNoOperands);
                jcInstrNoOperands.setPrevInstr(jcInstruction);
            }
        }
        operandStack.promote(1);
    }

    private void propagateInfo(InstrContainer instrContainer) {
        InstrContainer[] instrContainerArray = instrContainer.getOutInstrContainers();
        OperandStack operandStack = instrContainer.getOperandStack();
        int n = 0;
        while (n < instrContainerArray.length) {
            if (!instrContainerArray[n].isCatchFinallyBlockLeader()) {
                instrContainerArray[n].setOperandStack((OperandStack)operandStack.clone());
            }
            ++n;
        }
    }

    private void setSourceLineNumber(InstrContainer instrContainer) {
        int n = instrContainer.getJInstr().getSourceLineNumber();
        JcInstruction jcInstruction = instrContainer.getJcInstr();
        while (jcInstruction != null) {
            jcInstruction.setSourceLineNumber(n);
            jcInstruction = jcInstruction.getNextInstr();
        }
    }

    private void setJcInstrLabel(InstrContainer instrContainer) {
        int n = instrContainer.getLabel();
        if (n == -1) {
            return;
        }
        JcInstruction jcInstruction = instrContainer.getJcInstr();
        if (jcInstruction != null) {
            jcInstruction.setLabel(n);
        }
    }

    private JcInstruction linkJcInstructions() {
        InstrContainer instrContainer = this.instr_containers;
        JcInstruction jcInstruction = null;
        JcInstruction jcInstruction2 = null;
        while (instrContainer != null) {
            JcInstruction jcInstruction3 = instrContainer.getJcInstr();
            if (jcInstruction3 != null) {
                if (!instrContainer.hasLabel()) {
                    InstrContainer instrContainer2 = instrContainer.getPrevInstrContainer();
                    while (instrContainer2.getJcInstr() == null) {
                        if (instrContainer2.hasLabel()) {
                            jcInstruction3.setLabel(instrContainer2.getLabel());
                            break;
                        }
                        instrContainer2 = instrContainer2.getPrevInstrContainer();
                    }
                }
                if (jcInstruction == null) {
                    jcInstruction = jcInstruction3;
                    jcInstruction2 = jcInstruction3;
                } else {
                    jcInstruction2.setNextInstr(jcInstruction3);
                    jcInstruction3.setPrevInstr(jcInstruction2);
                }
                jcInstruction2 = jcInstruction3;
                while (jcInstruction2.getNextInstr() != null) {
                    jcInstruction2 = jcInstruction2.getNextInstr();
                }
            }
            instrContainer = instrContainer.getNextInstrContainer();
        }
        return jcInstruction;
    }
}

