/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;

public class LocalVariableConverter {
    private static final int INTEGRAL_TYPE = 1;
    private static final int REFERENCE_TYPE = 2;
    private MethodConverter method_converter;
    private JcLocalVariable[] jc_locals;
    private int defined_local_size;
    private int undefined_local_size;

    public LocalVariableConverter(MethodConverter methodConverter) {
        this.method_converter = methodConverter;
    }

    public JcLocalVariable[] convert() {
        int n;
        JcLocalVariable jcLocalVariable;
        this.constructLocalVariables();
        int n2 = 0;
        while (n2 < this.jc_locals.length) {
            jcLocalVariable = this.jc_locals[n2];
            while (jcLocalVariable != null) {
                n = this.computeJcIndex(jcLocalVariable);
                jcLocalVariable.setJcIndex(n);
                if (jcLocalVariable.getType() == 3 && !this.method_converter.isIntSupported()) {
                    jcLocalVariable.setDescriptor("S");
                }
                jcLocalVariable = jcLocalVariable.getNext();
            }
            ++n2;
        }
        if (this.jc_locals.length == 0) {
            this.defined_local_size = 0;
        } else {
            jcLocalVariable = this.jc_locals[this.jc_locals.length - 1];
            while (jcLocalVariable != null) {
                n = DataType.getSize(jcLocalVariable.getDescriptor());
                if (this.defined_local_size < jcLocalVariable.getJcIndex() + n) {
                    this.defined_local_size = jcLocalVariable.getJcIndex() + n;
                }
                jcLocalVariable = jcLocalVariable.getNext();
            }
        }
        return this.jc_locals;
    }

    private void constructLocalVariables() {
        JCodeAttr jCodeAttr = this.method_converter.getJavaMethod().getCodeAttr();
        if (jCodeAttr == null) {
            this.jc_locals = new JcLocalVariable[0];
            return;
        }
        JLocalVarTableAttr jLocalVarTableAttr = jCodeAttr.getLocalVarTableAttr();
        if (jLocalVarTableAttr == null) {
            if (this.method_converter.isIntSupported()) {
                this.checkParameters();
            }
            this.jc_locals = new JcLocalVariable[0];
            return;
        }
        JLocalVariable[] jLocalVariableArray = jLocalVarTableAttr.getLocalVars();
        int n = -1;
        int n2 = 0;
        while (n2 < jLocalVariableArray.length) {
            if (n < jLocalVariableArray[n2].getIndex()) {
                n = jLocalVariableArray[n2].getIndex();
            }
            ++n2;
        }
        this.jc_locals = new JcLocalVariable[n + 1];
        int n3 = 0;
        while (n3 < this.jc_locals.length) {
            this.jc_locals[n3] = null;
            ++n3;
        }
        int n4 = 0;
        while (n4 < jLocalVariableArray.length) {
            JcLocalVariable jcLocalVariable = new JcLocalVariable(jLocalVariableArray[n4]);
            int n5 = jLocalVariableArray[n4].getIndex();
            jcLocalVariable.setNext(this.jc_locals[n5]);
            this.jc_locals[n5] = jcLocalVariable;
            ++n4;
        }
    }

    private int computeJcIndex(JcLocalVariable jcLocalVariable) {
        int n = jcLocalVariable.getJIndex();
        if (n == 0) {
            return 0;
        }
        JcLocalVariable jcLocalVariable2 = this.jc_locals[n - 1];
        int n2 = 2;
        while (jcLocalVariable2 == null) {
            if (n - n2 < 0) {
                return 0;
            }
            jcLocalVariable2 = this.jc_locals[n - n2];
            ++n2;
        }
        int n3 = 0;
        while (jcLocalVariable2 != null) {
            int n4 = jcLocalVariable2.getJcIndex();
            if (jcLocalVariable2.getDescriptor().equals("I")) {
                if (n3 < n4 + 2) {
                    n3 = n4 + 2;
                }
            } else if (n3 < n4 + 1) {
                n3 = n4 + 1;
            }
            jcLocalVariable2 = jcLocalVariable2.getNext();
        }
        return n3;
    }

    public int getUndefinedLocalVariablesSize() {
        return this.undefined_local_size;
    }

    public int getDefinedLocalVariablesSize() {
        return this.defined_local_size;
    }

    public JcLocalVariable getJcLocalVariable(int n, JInstruction jInstruction) {
        if (n >= this.jc_locals.length) {
            return this.addUndefinedLocalVariable(n, jInstruction);
        }
        JcLocalVariable jcLocalVariable = this.jc_locals[n];
        int n2 = jInstruction.getPC();
        while (jcLocalVariable != null) {
            int n3 = jcLocalVariable.getJStartPC() - 2;
            int n4 = jcLocalVariable.getJLength() + 2;
            if (n3 <= n2 && n2 < n3 + n4) {
                return jcLocalVariable;
            }
            jcLocalVariable = jcLocalVariable.getNext();
        }
        return this.addUndefinedLocalVariable(n, jInstruction);
    }

    private JcLocalVariable addUndefinedLocalVariable(int n, JInstruction jInstruction) {
        int n2 = jInstruction.getOpcode();
        int n3 = this.getOpcodeType(n2);
        if (!this.method_converter.isIntSupported()) {
            if (n3 == 2) {
                return new JcLocalVariable("undefined", "L", n, n);
            }
            return new JcLocalVariable("undefined", "S", n, n);
        }
        if (n * 2 >= this.undefined_local_size) {
            this.undefined_local_size = (n + 1) * 2;
        }
        int n4 = this.defined_local_size + n * 2;
        if (n3 == 1) {
            return new JcLocalVariable("undefined", "I", n, n4);
        }
        return new JcLocalVariable("undefined", "L", n, n4);
    }

    private int getOpcodeType(int n) {
        switch (n) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 132: 
            case 196: {
                return 1;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 169: {
                return 2;
            }
        }
        throw new ClassFormatError();
    }

    private void checkParameters() {
        String string = this.method_converter.getJavaMethod().getMethodDescriptor();
        String[] stringArray = MethodDescriptor.getParamDescriptors(string);
        if (stringArray.length != 0) {
            Notifier.error("conversion.20", this.method_converter.getClassName().replace('/', '.'));
            throw new ConversionException();
        }
    }
}

