/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.constants.JcConstantStaticMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantVirtualMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

class InstrMethodRefConverter
extends InstructionConverter {
    public InstrMethodRefConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    public JcInstruction convert() {
        JInstrMethodRef jInstrMethodRef = (JInstrMethodRef)this.java_instr;
        String string = jInstrMethodRef.getClassName();
        String string2 = jInstrMethodRef.getMethodName();
        String string3 = jInstrMethodRef.getDescriptor();
        this.checkParamAndReturnTypes(string, string2, string3);
        int[] nArray = MethodDescriptor.getParamTypes(string3);
        int n = MethodDescriptor.getReturnType(string3);
        this.checkParamTypesAgainstStackEntryTypes(nArray);
        int n2 = 0;
        while (n2 < nArray.length) {
            this.operand_stack.pop();
            ++n2;
        }
        int n3 = jInstrMethodRef.getOpcode();
        JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
        switch (n3) {
            case 182: {
                this.operand_stack.pop();
                JcConstantVirtualMethodRef jcConstantVirtualMethodRef = jcConstantPool.addConstantVirtualMethodRef(string, string2, string3);
                this.jc_instr = new JcInstrMethodRef(139, jcConstantVirtualMethodRef);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
            case 183: {
                this.operand_stack.pop();
                JcConstantMethodRef jcConstantMethodRef = this.getMethodRef(string, string2, string3);
                this.jc_instr = new JcInstrMethodRef(140, jcConstantMethodRef);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
            case 184: {
                JcConstantStaticMethodRef jcConstantStaticMethodRef = jcConstantPool.addConstantStaticMethodRef(string, string2, string3);
                this.jc_instr = new JcInstrMethodRef(141, jcConstantStaticMethodRef);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
            case 185: {
                this.operand_stack.pop();
                JcConstantClassRef jcConstantClassRef = jcConstantPool.addConstantClassRef(string);
                int n4 = MethodDescriptor.getParamSize(string3) + 1;
                int n5 = this.getMethodToken(string, string2, string3);
                this.jc_instr = new JcInstrInterfaceRef(142, n4, jcConstantClassRef, n5);
                if (n != 9) {
                    this.operand_stack.push(n, this.instr_container);
                }
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private JcConstantMethodRef getMethodRef(String string, String string2, String string3) {
        JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
        if (string2.equals("<init>")) {
            return jcConstantPool.addConstantStaticMethodRef(string, string2, string3);
        }
        JClassFile jClassFile = this.method_converter.getClassConverter().getJavaClass();
        JMethod[] jMethodArray = jClassFile.getMethods();
        int n = 0;
        while (n < jMethodArray.length) {
            JMethod jMethod = jMethodArray[n];
            int n2 = jMethod.getAccessFlags();
            if (Modifier.isPrivate(n2) && jMethod.getMethodName().equals(string2) && jMethod.getMethodDescriptor().equals(string3)) {
                return jcConstantPool.addConstantStaticMethodRef(string, string2, string3);
            }
            ++n;
        }
        return jcConstantPool.addConstantSuperMethodRef(jClassFile.getClassName(), string2, string3);
    }

    private void checkParamAndReturnTypes(String string, String string2, String string3) {
        Object[] objectArray;
        String[] stringArray = MethodDescriptor.getParamDescriptors(string3);
        String string4 = MethodDescriptor.getReturnDescriptor(string3);
        int n = stringArray.length - 1;
        while (n >= 0) {
            if (stringArray[n].equals("I") || stringArray[n].equals("[I")) {
                if (this.method_converter.isIntSupported()) {
                    objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(string.replace('/', '.')) + "." + string2)};
                    Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.2", objectArray);
                    this.method_converter.getPackageConverter().setIntFlag(true);
                } else {
                    objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(string.replace('/', '.')) + "." + string2)};
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.2", objectArray);
                    throw new ConversionException();
                }
            }
            --n;
        }
        if (string4.equals("I") || string4.equals("[I")) {
            if (this.method_converter.isIntSupported()) {
                objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(string.replace('/', '.')) + "." + string2)};
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.3", objectArray);
                this.method_converter.getPackageConverter().setIntFlag(true);
                return;
            }
            objectArray = new Object[]{this.method_converter.getClassName().replace('/', '.'), new String(String.valueOf(string.replace('/', '.')) + "." + string2)};
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.3", objectArray);
            throw new ConversionException();
        }
    }

    private void checkParamTypesAgainstStackEntryTypes(int[] nArray) {
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = nArray.length - n;
            OperandStackEntry operandStackEntry = this.operand_stack.peek(n2);
            switch (nArray[n]) {
                case 3: {
                    if (operandStackEntry.getType() == 3) break;
                    operandStackEntry.rollBack();
                }
            }
            --n;
        }
    }

    private int getMethodToken(String string, String string2, String string3) {
        PackageConverter packageConverter = this.method_converter.getPackageConverter();
        String string4 = packageConverter.getJcPackage().getPackageName();
        if (Names.getPackageName(string).equals(string4)) {
            JcClass jcClass = packageConverter.getJcClass(string);
            if (jcClass == null) {
                Object[] objectArray = new String[]{this.method_converter.getClassName().replace('/', '.'), string.replace('/', '.')};
                Notifier.error(this.java_instr.getSourceLineNumber(), "linking.21", objectArray);
                throw new ConversionException();
            }
            MethodDefinition[] methodDefinitionArray = jcClass.getPublicMethodTable().getMethods();
            int n = 0;
            while (n < methodDefinitionArray.length) {
                if (methodDefinitionArray[n].getMethodName().equals(string2) && methodDefinitionArray[n].getMethodDescriptor().equals(string3)) {
                    return n;
                }
                ++n;
            }
            Object[] objectArray = new String[]{this.method_converter.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.')};
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.17", objectArray);
            throw new ConversionException();
        }
        ExportFileManager exportFileManager = packageConverter.getExportFileManager();
        EfClass efClass = exportFileManager.getClass(string);
        if (efClass == null) {
            Object[] objectArray = new String[3];
            objectArray[0] = this.method_converter.getClassName().replace('/', '.');
            objectArray[1] = string.replace('/', '.');
            Object[] objectArray2 = Names.getPackageName(string);
            objectArray[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray2)) + ".exp");
            objectArray2 = objectArray;
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.20", objectArray2);
            throw new ConversionException();
        }
        EfMethod efMethod = efClass.getMethod(string2, string3);
        if (efMethod == null) {
            Object[] objectArray = new String[4];
            objectArray[0] = this.method_converter.getClassName().replace('/', '.');
            objectArray[1] = Names.getMethodNameInJavaStyle(string2, string3);
            objectArray[2] = string.replace('/', '.');
            Object[] objectArray3 = Names.getPackageName(string);
            objectArray[3] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray3)) + ".exp");
            objectArray3 = objectArray;
            Notifier.error(this.java_instr.getSourceLineNumber(), "linking.20", objectArray3);
            throw new ConversionException();
        }
        return efMethod.getMethodToken();
    }
}

