/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteValue;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrShortValue;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrIntValue;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstrShortValue;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrLoadConstConverter
extends InstructionConverter {
    public InstrLoadConstConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    public JcInstruction convert() {
        int n = this.java_instr.getOpcode();
        switch (n) {
            case 0: {
                this.jc_instr = new JcInstrNoOperands(0);
                return this.jc_instr;
            }
            case 1: {
                this.jc_instr = new JcInstrNoOperands(1);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 2: {
                this.jc_instr = new JcInstrNoOperands(2);
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.jc_instr = new JcInstrNoOperands(3 + n - 3);
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 16: {
                int n2 = ((JInstrByteValue)this.java_instr).getValue();
                this.jc_instr = new JcInstrByteValue(16, n2);
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 17: {
                int n3 = ((JInstrShortValue)this.java_instr).getValue();
                this.jc_instr = new JcInstrShortValue(17, n3);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
            case 18: {
                return this.convertLDC(((JInstrCpByteRef)this.java_instr).getIntValue());
            }
            case 19: {
                return this.convertLDC(((JInstrCpShortRef)this.java_instr).getIntValue());
            }
        }
        throw new ConverterInternalError();
    }

    private JcInstruction convertLDC(int n) {
        int n2 = DataType.getType(n);
        switch (n2) {
            case 1: {
                this.jc_instr = new JcInstrByteValue(16, n);
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 2: {
                this.jc_instr = new JcInstrShortValue(17, n);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
            case 3: {
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.7", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.7", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                this.operand_stack.push(3, this.instr_container);
                this.jc_instr = new JcInstrIntValue(20, n);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }
}

