/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JConstantValueAttr;
import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantInteger;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class JField
extends FieldDefinition {
    private JConstantPool constant_pool;
    private int name_index;
    private int descriptor_index;
    private JAttribute[] attributes;
    private JConstant constant;

    public JField(JConstantPool jConstantPool) {
        this.constant_pool = jConstantPool;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.access_flags = dataInputStream.readUnsignedShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        this.attributes = new JAttribute[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readUnsignedShort();
            this.attributes[n2] = JAttribute.create(this.constant_pool, n3);
            this.attributes[n2].parse(dataInputStream);
            ++n2;
        }
    }

    public JConstant getConstant() {
        return this.constant;
    }

    public void resolve() {
        this.field_name = this.constant_pool.getConstantUtf8(this.name_index).getString();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getString();
        if (!Modifier.isStatic(this.access_flags)) {
            return;
        }
        int n = 0;
        while (n < this.attributes.length) {
            if (this.attributes[n] instanceof JConstantValueAttr) {
                JConstantValueAttr cfr_ignored_0 = (JConstantValueAttr)this.attributes[n];
                if (this.descriptor.length() == 1) {
                    switch (this.descriptor.charAt(0)) {
                        case 'B': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            this.value = new int[1];
                            JConstantInteger jConstantInteger = this.constant_pool.getConstantInteger(((JConstantValueAttr)this.attributes[n]).getValueIndex());
                            if (jConstantInteger == null) {
                                throw new ClassFormatError();
                            }
                            this.value[0] = jConstantInteger.getInt();
                            return;
                        }
                    }
                }
            }
            ++n;
        }
    }
}

