/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class CrefOutputFormatter
extends OutputFormatter {
    protected StringBuffer preamble = new StringBuffer();
    protected StringBuffer rom;
    protected StringBuffer staticFields;
    protected StringBuffer staticInit;
    protected StringBuffer applets;
    protected StringBuffer packages;
    protected StringBuffer exceptionTable;
    protected StringBuffer exportComponent;
    protected int exportComponentLength;
    protected int nExceptionEntries;
    protected StringBuffer defineList;
    protected PackageDirectory packageDirectory;
    protected Vector suppressionVector;
    private int relocPc;
    private int relocFieldPc;
    private int m_romBase;
    private int m_e2Base = 32768;
    private static final int ARRAY_HEADER_SIZE = 6;

    public CrefOutputFormatter(InputStream inputStream) throws IOException {
        super(inputStream);
        String string;
        this.preamble.append("#include \"opcode.h\"" + Msg.eol);
        this.preamble.append("#include \"mask.h\"" + Msg.eol);
        this.rom = new StringBuffer();
        this.staticFields = new StringBuffer();
        this.staticInit = new StringBuffer();
        this.applets = new StringBuffer();
        this.packages = new StringBuffer();
        this.defineList = new StringBuffer();
        this.exceptionTable = new StringBuffer();
        this.exportComponent = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        try {
            string = this.getMapEntry("ROMBASE");
            if (string != null) {
                this.m_romBase = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.0", null);
        }
        try {
            string = this.getMapEntry("E2BASE");
            if (string != null) {
                this.m_e2Base = Integer.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Msg.error("cref.1", null);
        }
        if ((string = this.getMapEntry("NOEXPORTCOMPONENT")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.suppressionVector.addElement(stringTokenizer.nextToken().trim());
            }
        }
        this.relocPc = this.m_romBase;
        this.relocFieldPc = this.m_e2Base;
    }

    public void format(RomMask romMask) {
        this.pass1(romMask);
        if (Globals.errors == 0) {
            this.pass2(romMask);
        }
    }

    protected void pass1(RomMask romMask) {
        Enumeration enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            JCPackage jCPackage = (JCPackage)enumeration.nextElement();
            Enumeration enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                Object object;
                Object object2;
                JCClass jCClass = (JCClass)enumeration2.nextElement();
                jCClass.relocate(this.relocPc);
                this.relocPc += jCClass.size();
                if (Modifier.isInterface(jCClass.getAttributes())) continue;
                Enumeration enumeration3 = jCClass.fieldElements();
                while (enumeration3.hasMoreElements()) {
                    Object[] objectArray;
                    object2 = (Field)enumeration3.nextElement();
                    if (!Modifier.isStatic(((Member)object2).getAttributes())) continue;
                    object = ((Field)object2).getDescriptor();
                    if (Modifier.isFinal(((Member)object2).getAttributes()) && ((FieldDescriptor)object).isPrimitive()) continue;
                    ((Member)object2).relocate(this.relocFieldPc);
                    this.relocFieldPc += ((Field)object2).size();
                    StaticFieldInitializer staticFieldInitializer = ((Field)object2).getFieldInitializer();
                    if (staticFieldInitializer == null || staticFieldInitializer.isPrimitive()) continue;
                    if (jCPackage.appletCount() == 0) {
                        objectArray = new Object[]{((Member)object2).getName(), jCPackage.getName()};
                        Msg.error("mlink.17", objectArray);
                        continue;
                    }
                    objectArray = ((FieldDescriptor)object).getDescriptorString();
                    int[] nArray = staticFieldInitializer.getArrayData();
                    if (objectArray.equals("[B") || objectArray.equals("[Z")) {
                        this.relocFieldPc += 6 + nArray.length;
                        continue;
                    }
                    if (objectArray.equals("[S")) {
                        this.relocFieldPc += 6 + nArray.length * 2;
                        continue;
                    }
                    if (objectArray.equals("[I")) {
                        this.relocFieldPc += 6 + nArray.length * 4;
                        continue;
                    }
                    throw new InternalError();
                }
                object2 = jCClass.methodElements();
                while (object2.hasMoreElements()) {
                    object = (JCMethod)object2.nextElement();
                    ((Member)object).relocate(this.relocPc);
                    this.relocPc += ((JCMethod)object).size();
                    if (!Modifier.isNative(((Member)object).getAttributes())) continue;
                    this.relocPc += 2;
                }
            }
        }
    }

    protected void pass2(RomMask romMask) {
        Enumeration enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            int n;
            Object object;
            Object object2;
            JCPackage jCPackage = (JCPackage)enumeration.nextElement();
            boolean bl = this.suppressionVector.contains(jCPackage.getName());
            ExportComponent exportComponent = new ExportComponent(jCPackage);
            PackageIdentifier packageIdentifier = jCPackage.getIdentifier();
            this.packageDirectory.addPackage(packageIdentifier);
            byte[] byArray = packageIdentifier.getAid().toByteArray();
            this.packages.append("{ { " + byArray.length + ", { ");
            this.packages.append(String.valueOf(Msg.toHexString(byArray, ", ")) + ", ");
            this.packages.append("} }, " + packageIdentifier.getMajorVersion() + ", " + packageIdentifier.getMinorVersion() + ", " + this.exportComponentLength + " }," + Msg.eol);
            Enumeration enumeration2 = jCPackage.appletElements();
            while (enumeration2.hasMoreElements()) {
                object2 = (AppletDeclarator)enumeration2.nextElement();
                object = ((AppletDeclarator)object2).getAid().toByteArray();
                n = ((AppletDeclarator)object2).resolve().getRelocAddr();
                this.applets.append("{ " + this.packageDirectory.indexOf(packageIdentifier) + ", { " + ((Object)object).length + ", { ");
                this.applets.append(String.valueOf(Msg.toHexString((byte[])object, ", ")) + ", ");
                this.applets.append(" } }, " + Msg.toHexString((short)n) + " }," + Msg.eol);
            }
            object2 = jCPackage.classElements();
            while (object2.hasMoreElements()) {
                int n2;
                Object[] objectArray;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                int n3;
                object = (JCClass)object2.nextElement();
                if (!bl) {
                    exportComponent.add((JCClass)object);
                }
                this.rom.append(String.valueOf(Msg.eol) + "/* class@" + Msg.toHexString((short)((Member)object).getRelocAddr()) + ": " + Modifier.toString(((Member)object).getAttributes()) + " " + ((Member)object).getName() + " */" + Msg.eol);
                String string = this.getMapEntry(((Member)object).getName());
                if (string != null) {
                    this.defineList.append("#define " + string + " " + ((Member)object).getRelocAddr() + "\t/* " + ((Member)object).getName() + " */" + Msg.eol);
                }
                int n4 = n3 = ((JCClass)object).isShareable() ? 64 : 0;
                if (Modifier.isInterface(((Member)object).getAttributes())) {
                    int n5 = ((JCClass)object).superInterfaceVector.size();
                    this.rom.append(String.valueOf(Msg.toHexString((byte)((n3 |= 0x80) | n5 & 0xF))) + ", ");
                    object6 = ((JCClass)object).superInterfaceVector.elements();
                    while (object6.hasMoreElements()) {
                        SuperInterface superInterface = (SuperInterface)object6.nextElement();
                        int n6 = superInterface.resolve().getRelocAddr();
                        this.rom.append("HIGH(" + Msg.toHexString((short)n6) + "), ");
                        this.rom.append("LOW(" + Msg.toHexString((short)n6) + "), ");
                        this.rom.append(Msg.eol);
                    }
                    continue;
                }
                this.rom.append(String.valueOf(Msg.toHexString((byte)(n3 | ((JCClass)object).interfaceVector.size() & 0xF))) + ", ");
                Object object7 = ((JCClass)object).getSuperClass();
                if (object7 == null) {
                    this.rom.append(String.valueOf(Msg.toHexString((byte)-1)) + ", ");
                    this.rom.append(String.valueOf(Msg.toHexString((byte)-1)) + ", ");
                } else {
                    this.rom.append("HIGH(" + Msg.toHexString((short)((Member)object7).getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)((Member)object7).getRelocAddr()) + "), ");
                }
                object6 = object;
                int n7 = 0;
                while (object6 != null) {
                    n7 += ((JCClass)object6).getInstanceSize();
                    object6 = ((JCClass)object6).getSuperClass();
                }
                this.rom.append(String.valueOf(Msg.toHexString((byte)n7)) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)((JCClass)object).getFirstReferenceToken())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)((JCClass)object).getReferenceCount())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)((JCClass)object).publicMethodTable.getBase())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)((JCClass)object).publicMethodTable.getCount())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)((JCClass)object).packageMethodTable.getBase())) + ", ");
                this.rom.append(String.valueOf(Msg.toHexString((byte)((JCClass)object).packageMethodTable.getCount())) + ", ");
                this.rom.append(Msg.eol);
                Object object8 = ((JCClass)object).publicMethodTable.elements();
                while (object8.hasMoreElements()) {
                    object5 = (JCMethod)object8.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)((Member)object5).getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)((Member)object5).getRelocAddr()) + "),\t\t/* " + ((Member)object5).getName() + " */" + Msg.eol);
                }
                object5 = ((JCClass)object).packageMethodTable.elements();
                while (object5.hasMoreElements()) {
                    object4 = (JCMethod)object5.nextElement();
                    this.rom.append("HIGH(" + Msg.toHexString((short)((Member)object4).getRelocAddr()) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)((Member)object4).getRelocAddr()) + "),\t\t/* " + ((Member)object4).getName() + " */" + Msg.eol);
                }
                object4 = ((JCClass)object).interfaceVector.elements();
                while (object4.hasMoreElements()) {
                    object3 = (InterfaceTable)object4.nextElement();
                    objectArray = ((InterfaceTable)object3).toByteArray();
                    int n8 = ((InterfaceTable)object3).resolve().getRelocAddr();
                    this.rom.append("HIGH(" + Msg.toHexString((short)n8) + "), ");
                    this.rom.append("LOW(" + Msg.toHexString((short)n8) + "), ");
                    n2 = 2;
                    while (n2 < objectArray.length) {
                        this.rom.append(String.valueOf(objectArray[n2]) + ", ");
                        ++n2;
                    }
                    this.rom.append(Msg.eol);
                }
                object7 = ((JCClass)object).fieldElements();
                while (object7.hasMoreElements()) {
                    object6 = (Field)object7.nextElement();
                    n7 = ((Member)object6).getAttributes();
                    if (Modifier.isStatic(n7) && !Modifier.isFinal(n7) && (string = this.getMapEntry(((Member)object6).getName())) != null) {
                        this.defineList.append("#define " + string + " " + ((Member)object6).getRelocAddr() + "\t/* " + ((Member)object6).getName() + " */" + Msg.eol);
                    }
                    if (!Modifier.isStatic(n7)) continue;
                    object8 = ((Field)object6).getDescriptor();
                    if (Modifier.isFinal(((Member)object6).getAttributes()) && ((FieldDescriptor)object8).isPrimitive()) continue;
                    object5 = ((Field)object6).getFieldInitializer();
                    if (object5 != null && ((StaticFieldInitializer)object5).isPrimitive()) {
                        int n9 = ((StaticFieldInitializer)object5).getPrimitiveData();
                        switch (((Field)object6).size()) {
                            case 1: {
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)n9)) + ",");
                                break;
                            }
                            case 2: {
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(n9 >> 8))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)n9)) + ",");
                                break;
                            }
                            case 4: {
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(n9 >> 24))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(n9 >> 16))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)(n9 >> 8))) + ", ");
                                this.staticInit.append(String.valueOf(Msg.toHexString((byte)n9)) + ",");
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                        this.staticInit.append("\t/* " + ((Member)object6).getName() + " @ " + Msg.toHexString((short)((Member)object6).getRelocAddr()) + " */" + Msg.eol);
                        continue;
                    }
                    if (object5 != null && !((StaticFieldInitializer)object5).isPrimitive()) {
                        byte[] byArray2;
                        int n10 = ((Member)object6).getRelocAddr() + 2;
                        this.staticInit.append(String.valueOf(Msg.toHexString((byte)(n10 >> 8))) + ", ");
                        this.staticInit.append(String.valueOf(Msg.toHexString((byte)n10)) + ",");
                        this.staticInit.append("\t/* " + ((Member)object6).getName() + " @ " + Msg.toHexString((short)((Member)object6).getRelocAddr()) + " */" + Msg.eol);
                        object3 = ((FieldDescriptor)object8).getDescriptorString();
                        objectArray = ((StaticFieldInitializer)object5).getArrayData();
                        if (((String)object3).equals("[B")) {
                            byArray2 = new byte[objectArray.length + 6];
                            byArray2[0] = -128;
                            n10 = ((JCClass)romMask.classSymbolTable.get("[B")).getRelocAddr();
                            n2 = 0;
                            while (n2 < objectArray.length) {
                                byArray2[6 + n2] = objectArray[n2];
                                ++n2;
                            }
                        } else if (((String)object3).equals("[Z")) {
                            byArray2 = new byte[objectArray.length + 6];
                            byArray2[0] = 96;
                            n10 = ((JCClass)romMask.classSymbolTable.get("[Z")).getRelocAddr();
                            n2 = 0;
                            while (n2 < objectArray.length) {
                                byArray2[6 + n2] = objectArray[n2];
                                ++n2;
                            }
                        } else if (((String)object3).equals("[S")) {
                            byArray2 = new byte[objectArray.length * 2 + 6];
                            byArray2[0] = -96;
                            n10 = ((JCClass)romMask.classSymbolTable.get("[S")).getRelocAddr();
                            n2 = 0;
                            while (n2 < objectArray.length) {
                                byArray2[6 + n2 * 2] = (byte)(objectArray[n2] >> 8);
                                byArray2[6 + n2 * 2 + 1] = objectArray[n2];
                                ++n2;
                            }
                        } else if (((String)object3).equals("[I")) {
                            byArray2 = new byte[objectArray.length * 4 + 6];
                            byArray2[0] = -64;
                            n10 = ((JCClass)romMask.classSymbolTable.get("[I")).getRelocAddr();
                            n2 = 0;
                            while (n2 < objectArray.length) {
                                byArray2[6 + n2 * 4] = (byte)(objectArray[n2] >> 24);
                                byArray2[6 + n2 * 4 + 1] = (byte)(objectArray[n2] >> 16);
                                byArray2[6 + n2 * 4 + 2] = (byte)(objectArray[n2] >> 8);
                                byArray2[6 + n2 * 4 + 3] = objectArray[n2];
                                ++n2;
                            }
                        } else {
                            throw new InternalError();
                        }
                        byArray2[1] = (byte)(this.packageDirectory.indexOf(packageIdentifier) << 4);
                        byArray2[2] = (byte)(n10 >> 8);
                        byArray2[3] = (byte)n10;
                        byArray2[4] = (byte)(objectArray.length >> 8);
                        byArray2[5] = (byte)objectArray.length;
                        this.staticInit.append(String.valueOf(Msg.toHexString(byArray2, ", ")) + "," + Msg.eol);
                        continue;
                    }
                    switch (((Field)object6).size()) {
                        case 1: {
                            this.staticInit.append("0,");
                            break;
                        }
                        case 2: {
                            this.staticInit.append("0, 0,");
                            break;
                        }
                        case 4: {
                            this.staticInit.append("0, 0, 0, 0,");
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.staticInit.append("\t/* " + ((Member)object6).getName() + " @ " + Msg.toHexString((short)((Member)object6).getRelocAddr()) + " */" + Msg.eol);
                }
                object6 = ((JCClass)object).methodElements();
                while (object6.hasMoreElements()) {
                    JCMethod jCMethod = (JCMethod)object6.nextElement();
                    string = this.getMapEntry(jCMethod.getName());
                    if (string != null) {
                        this.defineList.append("#define " + string + " " + jCMethod.getRelocAddr() + "\t/* " + jCMethod.getName() + " */" + Msg.eol);
                    }
                    this.rom.append(String.valueOf(Msg.eol) + "/* method@" + Msg.toHexString((short)jCMethod.getRelocAddr()) + ": " + Modifier.toString(jCMethod.getAttributes()) + " " + jCMethod.getName() + " */" + Msg.eol);
                    this.rom.append(String.valueOf(Msg.toHexString(jCMethod.getMethodHeader(), ", ")) + ", " + Msg.eol);
                    if (Modifier.isAbstract(jCMethod.getAttributes())) continue;
                    if (Modifier.isNative(jCMethod.getAttributes())) {
                        int n11 = jCMethod.getRelocAddr();
                        this.rom.append(String.valueOf(Msg.toHexString((byte)(n11 >> 8))) + ", " + Msg.toHexString((byte)n11) + ", " + Msg.eol);
                        continue;
                    }
                    Enumeration enumeration3 = jCMethod.statementElements();
                    while (enumeration3.hasMoreElements()) {
                        object5 = (Statement)enumeration3.nextElement();
                        this.format((Statement)object5);
                        this.rom.append(", " + Msg.eol);
                    }
                    object5 = jCMethod.getExceptionTable();
                    if (object5 == null) continue;
                    Enumeration enumeration4 = ((ExceptionTable)object5).elements();
                    while (enumeration4.hasMoreElements()) {
                        object3 = (ExceptionTableEntry)enumeration4.nextElement();
                        this.exceptionTable.append("{ ");
                        this.exceptionTable.append(String.valueOf(Msg.toHexString((short)((ExceptionTableEntry)object3).getStartOffset())) + ", ");
                        int n12 = ((ExceptionTableEntry)object3).getActiveLength();
                        if (((ExceptionTableEntry)object3).isOuterMost()) {
                            n12 |= 0x8000;
                        }
                        this.exceptionTable.append(String.valueOf(Msg.toHexString((short)n12)) + ", ");
                        this.exceptionTable.append(String.valueOf(Msg.toHexString((short)((ExceptionTableEntry)object3).getHandlerOffset())) + ", ");
                        this.exceptionTable.append(String.valueOf(Msg.toHexString((short)((ExceptionTableEntry)object3).getCatchIndex())) + ", ");
                        this.exceptionTable.append(" }," + Msg.eol);
                        ++this.nExceptionEntries;
                    }
                }
            }
            object = exportComponent.toByteArray();
            this.exportComponent.append("/* " + jCPackage.getName() + " */" + Msg.eol);
            n = 0;
            while (n < ((Object)object).length) {
                this.exportComponent.append(String.valueOf(Msg.toHexString((byte)object[n])) + ", ");
                if (n % 8 == 7) {
                    this.exportComponent.append(Msg.eol);
                }
                ++n;
            }
            this.exportComponent.append(Msg.eol);
            this.exportComponentLength += ((Object)object).length;
        }
    }

    protected void format(Statement statement) {
        if (statement.getInstruction() == null) {
            return;
        }
        this.format(statement.getInstruction());
    }

    protected void format(Instruction instruction) {
        this.rom.append("_" + instruction.getMnemonic().toUpperCase());
        Enumeration enumeration = instruction.operandElements();
        while (enumeration.hasMoreElements()) {
            Operand operand = (Operand)enumeration.nextElement();
            this.format(operand);
        }
    }

    protected void format(Operand operand) {
        if (operand.getType() == 8) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int n = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + Msg.toHexString((short)n) + "), LOW(" + Msg.toHexString((short)n) + ")");
                    return;
                }
                case 5: {
                    int n = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + Msg.toHexString((short)n) + "), LOW(" + Msg.toHexString((short)n) + ")");
                    return;
                }
                case 3: {
                    JCMethod jCMethod = (JCMethod)info.resolve();
                    MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
                    int n = methodIdentifier.getMethodToken();
                    int n2 = jCMethod.getParams();
                    this.rom.append(", " + Msg.toHexString((byte)n2) + ", " + Msg.toHexString((byte)n));
                    return;
                }
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n3 = n + jCClass.getInstanceBase();
                    this.rom.append(", " + Msg.toHexString((byte)n3 >> 8) + ", " + Msg.toHexString((byte)n3));
                    return;
                }
            }
            throw new InternalError();
        }
        if (operand.getType() == 7) {
            Info info = operand.resolve();
            switch (info.getType()) {
                case 2: {
                    Field field = (Field)info.resolve();
                    JCClass jCClass = field.getParentClass();
                    int n = field.getFieldIdentifier().getFieldToken();
                    int n4 = n + jCClass.getInstanceBase();
                    this.rom.append(", " + Msg.toHexString((byte)n4));
                    return;
                }
            }
            throw new InternalError();
        }
        if (operand.size() == 1) {
            this.rom.append(", " + operand.getValue());
            return;
        }
        if (operand.size() == 2) {
            this.rom.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
            return;
        }
        if (operand.size() == 4) {
            this.rom.append(", " + (operand.getValue() >> 24 & 0xFF) + ", " + (operand.getValue() >> 16 & 0xFF));
            this.rom.append(", " + (operand.getValue() >> 8 & 0xFF) + ", " + (operand.getValue() & 0xFF));
        }
    }

    public void write(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("#ifdef __MASK_HEADER__" + Msg.eol);
        printWriter.println(this.defineList.toString());
        printWriter.println("#else" + Msg.eol);
        printWriter.println(this.preamble.toString());
        printWriter.println("const unsigned char rommask[] = {");
        printWriter.println(String.valueOf(this.rom.toString()) + "};");
        printWriter.println("const unsigned short romsize = sizeof rommask;" + Msg.eol);
        if (this.nExceptionEntries == 0) {
            printWriter.println("const struct exception exceptiontable[] = { NULL };");
        } else {
            printWriter.println("const struct exception exceptiontable[] = {");
            printWriter.println(String.valueOf(this.exceptionTable.toString()) + "};");
        }
        printWriter.println("const unsigned short exceptiontablesize = sizeof exceptiontable / sizeof (struct exception);" + Msg.eol);
        printWriter.println("const unsigned short staticfieldsize = " + (this.relocFieldPc - this.m_e2Base) + ";" + Msg.eol);
        printWriter.println("const unsigned char staticinit[] = {");
        if (this.staticInit.length() == 0) {
            printWriter.println(" NULL ");
        } else {
            printWriter.print(this.staticInit.toString());
        }
        printWriter.println("};");
        printWriter.println("const struct applet applets[] = {");
        if (this.applets.length() == 0) {
            printWriter.println(" NULL ");
        } else {
            printWriter.print(this.applets.toString());
        }
        printWriter.println("};" + Msg.eol + "const unsigned short napplets = (sizeof applets / sizeof (struct applet));" + Msg.eol);
        printWriter.println("#ifdef POST_ISSUANCE_INSTALL");
        printWriter.println("const struct package packages[] = {");
        printWriter.print(this.packages.toString());
        printWriter.println("};" + Msg.eol + "const unsigned short npackages = (sizeof packages / sizeof (struct package));" + Msg.eol);
        printWriter.println("const unsigned char exportComponent[] = {");
        printWriter.print(this.exportComponent.toString());
        printWriter.println("};");
        printWriter.println("const unsigned short exportComponentSize = sizeof exportComponent;" + Msg.eol);
        printWriter.println("#endif /* __POST_ISSUANCE_INSTALL__ */");
        printWriter.println("#endif /* __MASK_HEADER__ */" + Msg.eol);
        printWriter.flush();
    }
}

