/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class StaticFieldComponent
extends Component {
    protected Vector primitiveInitVector;
    protected Vector arrayInitVector = new Vector();
    protected int reference_count;
    protected int non_default_value_count;
    protected int default_value_count;
    protected Vector segment1;
    protected Vector segment2;
    protected Vector segment3;
    protected Vector segment4;

    public StaticFieldComponent(JCPackage jCPackage) {
        super(jCPackage);
        this.primitiveInitVector = new Vector();
        this.segment1 = new Vector();
        this.segment2 = new Vector();
        this.segment3 = new Vector();
        this.segment4 = new Vector();
    }

    int getImageSize() {
        return this.default_value_count + this.non_default_value_count + this.reference_count * 2;
    }

    int getArrayInitCount() {
        return this.arrayInitVector.size();
    }

    int getArrayInitSize() {
        int n = 0;
        Enumeration enumeration = this.arrayInitVector.elements();
        while (enumeration.hasMoreElements()) {
            NonDefaultValue nonDefaultValue = (NonDefaultValue)enumeration.nextElement();
            n += nonDefaultValue.size();
        }
        return n;
    }

    public int dataSize() {
        int n = 10;
        Enumeration enumeration = this.arrayInitVector.elements();
        while (enumeration.hasMoreElements()) {
            NonDefaultValue nonDefaultValue = (NonDefaultValue)enumeration.nextElement();
            n += nonDefaultValue.size();
        }
        return n += this.non_default_value_count;
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object;
            Object object2;
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeShort(this.getImageSize());
            dataOutputStream.writeShort(this.reference_count);
            dataOutputStream.writeShort(this.arrayInitVector.size());
            Enumeration enumeration = this.arrayInitVector.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (NonDefaultValue)enumeration.nextElement();
                object = ((NonDefaultValue)object2).toByteArray();
                dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
            }
            dataOutputStream.writeShort(this.default_value_count);
            dataOutputStream.writeShort(this.non_default_value_count);
            object2 = this.primitiveInitVector.elements();
            while (object2.hasMoreElements()) {
                object = (NonDefaultValue)object2.nextElement();
                byte[] byArray2 = ((NonDefaultValue)object).toByteArray();
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    void add(JCClass jCClass) {
        Enumeration enumeration = jCClass.fieldElements();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            if (!Modifier.isStatic(field.getAttributes()) || Modifier.isFinal(field.getAttributes()) && field.getDescriptor().isPrimitive()) continue;
            FieldDescriptor fieldDescriptor = field.getDescriptor();
            StaticFieldInitializer staticFieldInitializer = field.getFieldInitializer();
            if (fieldDescriptor.isPrimitive()) {
                if (staticFieldInitializer != null) {
                    this.non_default_value_count += field.size();
                    this.primitiveInitVector.addElement(new NonDefaultValue(field.size(), staticFieldInitializer.getPrimitiveData()));
                    this.segment4.addElement(field);
                    continue;
                }
                this.default_value_count += field.size();
                this.segment3.addElement(field);
                continue;
            }
            ++this.reference_count;
            if (staticFieldInitializer == null) {
                this.segment2.addElement(field);
                continue;
            }
            this.arrayInitVector.addElement(new NonDefaultValue(fieldDescriptor.getDescriptorString(), staticFieldInitializer.getArrayData()));
            this.segment1.addElement(field);
        }
    }

    void assignAddresses() {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        Enumeration enumeration = this.segment1.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (Field)enumeration.nextElement();
            ((Member)object3).relocate(n);
            n += ((Field)object3).size();
        }
        object3 = this.segment2.elements();
        while (object3.hasMoreElements()) {
            object2 = (Field)object3.nextElement();
            ((Member)object2).relocate(n);
            n += ((Field)object2).size();
        }
        object2 = this.segment3.elements();
        while (object2.hasMoreElements()) {
            object = (Field)object2.nextElement();
            ((Member)object).relocate(n);
            n += ((Field)object).size();
        }
        object = this.segment4.elements();
        while (object.hasMoreElements()) {
            Field field = (Field)object.nextElement();
            field.relocate(n);
            n += field.size();
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Image Size: " + this.getImageSize() + Msg.eol);
        stringBuffer.append("First Reference Count: " + this.reference_count + Msg.eol);
        stringBuffer.append("Array Init Count: " + this.arrayInitVector.size() + Msg.eol);
        Enumeration enumeration = this.arrayInitVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (NonDefaultValue)enumeration.nextElement();
            stringBuffer.append("Array Init: " + Msg.toHexString(((NonDefaultValue)object).toByteArray()) + Msg.eol);
        }
        stringBuffer.append("Default Value Count: " + this.default_value_count + Msg.eol);
        stringBuffer.append("Non-Default Value Count: " + this.non_default_value_count + Msg.eol);
        object = this.primitiveInitVector.elements();
        while (object.hasMoreElements()) {
            NonDefaultValue nonDefaultValue = (NonDefaultValue)object.nextElement();
            stringBuffer.append("Primitive Init: " + Msg.toHexString(nonDefaultValue.toByteArray()) + Msg.eol);
        }
        return stringBuffer.toString();
    }

    static class NonDefaultValue {
        protected int width;
        protected int value;
        protected String descriptor;
        protected int[] arrayValue;
        private boolean isPrimitive;

        NonDefaultValue(int n, int n2) {
            this.width = n;
            this.value = n2;
            this.isPrimitive = true;
        }

        NonDefaultValue(String string, int[] nArray) {
            this.descriptor = string;
            this.arrayValue = nArray;
            if (string.equals("[B")) {
                this.width = 1;
                return;
            }
            if (string.equals("[Z")) {
                this.width = 1;
                return;
            }
            if (string.equals("[S")) {
                this.width = 2;
                return;
            }
            if (string.equals("[I")) {
                this.width = 4;
            }
        }

        int size() {
            if (this.isPrimitive) {
                return this.width;
            }
            return 3 + this.width * this.arrayValue.length;
        }

        byte[] toByteArray() {
            byte[] byArray = new byte[this.size()];
            if (this.isPrimitive) {
                this.setArrayElement(byArray, 0, this.width, this.value);
            } else {
                if (this.descriptor.equals("[B")) {
                    byArray[0] = 3;
                } else if (this.descriptor.equals("[Z")) {
                    byArray[0] = 2;
                } else if (this.descriptor.equals("[S")) {
                    byArray[0] = 4;
                } else if (this.descriptor.equals("[I")) {
                    byArray[0] = 5;
                }
                this.setArrayElement(byArray, 1, 2, this.arrayValue.length * this.width);
                int n = 3;
                int n2 = 0;
                while (n2 < this.arrayValue.length) {
                    this.setArrayElement(byArray, n, this.width, this.arrayValue[n2]);
                    n += this.width;
                    ++n2;
                }
            }
            return byArray;
        }

        private void setArrayElement(byte[] byArray, int n, int n2, int n3) {
            switch (n2) {
                case 1: {
                    byArray[n] = (byte)n3;
                    return;
                }
                case 2: {
                    byArray[n] = (byte)(n3 >> 8 & 0xFF);
                    byArray[n + 1] = (byte)(n3 & 0xFF);
                    return;
                }
                case 4: {
                    byArray[n] = (byte)(n3 >> 24 & 0xFF);
                    byArray[n + 1] = (byte)(n3 >> 16 & 0xFF);
                    byArray[n + 2] = (byte)(n3 >> 8 & 0xFF);
                    byArray[n + 3] = (byte)(n3 & 0xFF);
                    return;
                }
            }
        }

        public String toString() {
            return Msg.toHexString(this.toByteArray());
        }
    }
}

