/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class MethodComponent
extends Component {
    public static final int ACC_EXTENDED = 8;
    public static final int ACC_ABSTRACT = 4;
    protected Vector methodVector = new Vector();
    protected Vector exceptionVector = new Vector();
    protected int handlerCount;

    public MethodComponent(JCPackage jCPackage) {
        super(jCPackage);
    }

    public int dataSize() {
        Object object;
        int n = 1;
        Enumeration enumeration = this.exceptionVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ExceptionTable)enumeration.nextElement();
            n += ((ExceptionTable)object).size();
        }
        object = this.methodVector.elements();
        while (object.hasMoreElements()) {
            JCMethod jCMethod = (JCMethod)object.nextElement();
            n += jCMethod.size();
        }
        return n;
    }

    public void add(JCClass jCClass) {
        if (Modifier.isInterface(jCClass.getAttributes())) {
            return;
        }
        Enumeration enumeration = jCClass.methodElements();
        while (enumeration.hasMoreElements()) {
            JCMethod jCMethod = (JCMethod)enumeration.nextElement();
            this.methodVector.addElement(jCMethod);
            ExceptionTable exceptionTable = jCMethod.getExceptionTable();
            if (exceptionTable == null) continue;
            this.exceptionVector.addElement(exceptionTable);
            this.handlerCount += exceptionTable.count();
        }
    }

    void assignAddresses() {
        Object object;
        int n = 1;
        Enumeration enumeration = this.exceptionVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ExceptionTable)enumeration.nextElement();
            ((ExceptionTable)object).relocate(n);
            n += ((ExceptionTable)object).size();
        }
        object = this.methodVector.elements();
        while (object.hasMoreElements()) {
            JCMethod jCMethod = (JCMethod)object.nextElement();
            jCMethod.relocate(n);
            n += jCMethod.size();
        }
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object;
            Object object2;
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeByte(this.handlerCount);
            Enumeration enumeration = this.exceptionVector.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (ExceptionTable)enumeration.nextElement();
                object = ((ExceptionTable)object2).toByteArray();
                dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
            }
            object2 = this.methodVector.elements();
            while (object2.hasMoreElements()) {
                object = (JCMethod)object2.nextElement();
                byte[] byArray2 = ((JCMethod)object).toByteArray();
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Handler count: " + this.handlerCount + Msg.eol);
        Enumeration enumeration = this.exceptionVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ExceptionTable)enumeration.nextElement();
            stringBuffer.append(String.valueOf(((ExceptionTable)object).toString()) + Msg.eol);
        }
        object = this.methodVector.elements();
        while (object.hasMoreElements()) {
            JCMethod jCMethod = (JCMethod)object.nextElement();
            stringBuffer.append(jCMethod.toString());
        }
        return stringBuffer.toString();
    }
}

