/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DirectoryComponent
extends Component {
    protected final int basicCount = 11;
    protected final int customCount = 0;
    protected Component[] component;

    DirectoryComponent(JCPackage jCPackage, HeaderComponent headerComponent, AppletComponent appletComponent, ImportComponent importComponent, ConstantPoolComponent constantPoolComponent, ClassComponent classComponent, MethodComponent methodComponent, StaticFieldComponent staticFieldComponent, ReferenceLocationComponent referenceLocationComponent, ExportComponent exportComponent, DescriptorComponent descriptorComponent) {
        super(jCPackage);
        if (headerComponent == null || importComponent == null || constantPoolComponent == null || classComponent == null || methodComponent == null || staticFieldComponent == null || referenceLocationComponent == null) {
            throw new IllegalArgumentException();
        }
        this.component = new Component[12];
        this.component[1] = headerComponent;
        this.component[2] = this;
        this.component[3] = appletComponent;
        this.component[4] = importComponent;
        this.component[5] = constantPoolComponent;
        this.component[6] = classComponent;
        this.component[7] = methodComponent;
        this.component[8] = staticFieldComponent;
        this.component[9] = referenceLocationComponent;
        this.component[10] = exportComponent;
        this.component[11] = descriptorComponent;
    }

    public int dataSize() {
        return 31;
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            int n = 1;
            while (n < this.component.length) {
                if (this.component[n] == null) {
                    dataOutputStream.writeShort(0);
                } else {
                    dataOutputStream.writeShort(this.component[n].dataSize());
                }
                ++n;
            }
            dataOutputStream.writeShort(((StaticFieldComponent)this.component[8]).getImageSize());
            dataOutputStream.writeShort(((StaticFieldComponent)this.component[8]).getArrayInitCount());
            dataOutputStream.writeShort(((StaticFieldComponent)this.component[8]).getArrayInitSize());
            dataOutputStream.writeByte(((ImportComponent)this.component[4]).count());
            if (this.component[3] != null) {
                dataOutputStream.writeByte(((AppletComponent)this.component[3]).count());
            } else {
                dataOutputStream.writeByte(0);
            }
            dataOutputStream.writeByte(0);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Component Sizes:");
        int n = 1;
        while (n < this.component.length) {
            if (this.component[n] == null) {
                stringBuffer.append(" " + 0);
            } else {
                stringBuffer.append(" " + this.component[n].dataSize());
            }
            ++n;
        }
        stringBuffer.append(Msg.eol);
        StaticFieldComponent staticFieldComponent = (StaticFieldComponent)this.component[8];
        stringBuffer.append("Image Size: " + staticFieldComponent.getImageSize() + Msg.eol);
        stringBuffer.append("Array Init Count: " + staticFieldComponent.getArrayInitCount() + Msg.eol);
        stringBuffer.append("Array Init Size: " + staticFieldComponent.getArrayInitSize() + Msg.eol);
        stringBuffer.append("Import Count: " + ((ImportComponent)this.component[4]).count() + Msg.eol);
        AppletComponent appletComponent = (AppletComponent)this.component[3];
        stringBuffer.append("Applet Count: " + (appletComponent != null ? appletComponent.count() : 0) + Msg.eol);
        stringBuffer.append("Custom Count: " + 0 + Msg.eol);
        return stringBuffer.toString();
    }
}

