/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CapWriter {
    protected File file;
    protected String packageName;
    protected long timeStamp;

    public CapWriter(File file, String string) {
        this.file = file;
        this.packageName = string;
        this.timeStamp = System.currentTimeMillis();
    }

    public void publish(HeaderComponent headerComponent, DirectoryComponent directoryComponent, AppletComponent appletComponent, ImportComponent importComponent, ConstantPoolComponent constantPoolComponent, ClassComponent classComponent, MethodComponent methodComponent, StaticFieldComponent staticFieldComponent, ReferenceLocationComponent referenceLocationComponent, ExportComponent exportComponent, DescriptorComponent descriptorComponent) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.file));
        zipOutputStream.setMethod(0);
        this.addZipEntry(zipOutputStream, "Header.cap", headerComponent);
        this.addZipEntry(zipOutputStream, "Directory.cap", directoryComponent);
        if (appletComponent != null) {
            this.addZipEntry(zipOutputStream, "Applet.cap", appletComponent);
        }
        this.addZipEntry(zipOutputStream, "Import.cap", importComponent);
        this.addZipEntry(zipOutputStream, "ConstantPool.cap", constantPoolComponent);
        this.addZipEntry(zipOutputStream, "Class.cap", classComponent);
        this.addZipEntry(zipOutputStream, "Method.cap", methodComponent);
        this.addZipEntry(zipOutputStream, "StaticField.cap", staticFieldComponent);
        this.addZipEntry(zipOutputStream, "RefLocation.cap", referenceLocationComponent);
        if (exportComponent != null) {
            this.addZipEntry(zipOutputStream, "Export.cap", exportComponent);
        }
        if (descriptorComponent != null) {
            this.addZipEntry(zipOutputStream, "Descriptor.cap", descriptorComponent);
        }
        zipOutputStream.close();
    }

    private void addZipEntry(ZipOutputStream zipOutputStream, String string, Component component) throws IOException {
        byte[] byArray = component.toByteArray();
        ZipEntry zipEntry = new ZipEntry(String.valueOf(this.packageName) + "/javacard/" + string);
        zipEntry.setSize(byArray.length);
        zipEntry.setTime(this.timeStamp);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        zipEntry.setCrc(cRC32.getValue());
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray, 0, byArray.length);
    }
}

