/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.AppletComponent;
import com.sun.javacard.jcasm.cap.CapWriter;
import com.sun.javacard.jcasm.cap.ClassComponent;
import com.sun.javacard.jcasm.cap.ConstantPoolComponent;
import com.sun.javacard.jcasm.cap.DescriptorComponent;
import com.sun.javacard.jcasm.cap.DirectoryComponent;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.HeaderComponent;
import com.sun.javacard.jcasm.cap.ImportComponent;
import com.sun.javacard.jcasm.cap.MethodComponent;
import com.sun.javacard.jcasm.cap.ReferenceLocationComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;

public class CapGen {
    public static final int ACC_INT = 1;
    public static final int ACC_EXPORT = 2;
    public static final int ACC_APPLET = 4;
    JCPackage f_package;
    HeaderComponent f_header;
    ImportComponent f_import;
    AppletComponent f_applet;
    ConstantPoolComponent f_constantPool;
    ClassComponent f_class;
    MethodComponent f_method;
    StaticFieldComponent f_staticField;
    ExportComponent f_export;
    ReferenceLocationComponent f_refLocation;
    DescriptorComponent f_descriptor;
    DirectoryComponent f_directory;

    public void gen(JCPackage jCPackage, File file) throws IOException {
        Object object;
        this.f_package = jCPackage;
        this.f_method = this.genMethodComponent(this.f_package);
        this.f_staticField = this.genStaticFieldComponent(this.f_package);
        this.f_class = this.genClassComponent(this.f_package);
        this.f_import = this.genImportComponent(this.f_package);
        this.f_applet = this.genAppletComponent(this.f_package);
        this.f_constantPool = this.genConstantPoolComponent(this.f_package);
        this.f_export = this.genExportComponent(this.f_package);
        this.f_refLocation = this.genReferenceLocationComponent(this.f_package);
        this.f_descriptor = this.genDescriptorComponent(this.f_package);
        this.f_header = this.genHeaderComponent(this.f_package);
        this.f_directory = new DirectoryComponent(this.f_package, this.f_header, this.f_applet, this.f_import, this.f_constantPool, this.f_class, this.f_method, this.f_staticField, this.f_refLocation, this.f_export, this.f_descriptor);
        if (Globals.errors == 0 && Globals.debug) {
            object = "// " + this.f_package.getName() + "/javacard/";
            if ((Globals.debugLevel & 1) != 0) {
                System.out.println(String.valueOf(object) + "Header.cap" + Msg.eol + this.f_header);
            }
            if ((Globals.debugLevel & 2) != 0) {
                System.out.println(String.valueOf(object) + "Directory.cap" + Msg.eol + this.f_directory);
            }
            if ((Globals.debugLevel & 4) != 0 && this.f_applet != null) {
                System.out.println(String.valueOf(object) + "Applet.cap" + Msg.eol + this.f_applet);
            }
            if ((Globals.debugLevel & 8) != 0) {
                System.out.println(String.valueOf(object) + "Import.cap" + Msg.eol + this.f_import);
            }
            if ((Globals.debugLevel & 0x10) != 0) {
                System.out.println(String.valueOf(object) + "ConstantPool.cap" + Msg.eol + this.f_constantPool);
            }
            if ((Globals.debugLevel & 0x20) != 0) {
                System.out.println(String.valueOf(object) + "Class.cap" + Msg.eol + this.f_class);
            }
            if ((Globals.debugLevel & 0x40) != 0) {
                System.out.println(String.valueOf(object) + "Method.cap" + Msg.eol + this.f_method);
            }
            if ((Globals.debugLevel & 0x80) != 0) {
                System.out.println(String.valueOf(object) + "StaticField.cap" + Msg.eol + this.f_staticField);
            }
            if ((Globals.debugLevel & 0x100) != 0) {
                System.out.println(String.valueOf(object) + "RefLocation.cap" + Msg.eol + this.f_refLocation);
            }
            if ((Globals.debugLevel & 0x200) != 0 && this.f_export != null) {
                System.out.println(String.valueOf(object) + "Export.cap" + Msg.eol + this.f_export);
            }
            if ((Globals.debugLevel & 0x400) != 0) {
                System.out.println(String.valueOf(object) + "Descriptor.cap" + Msg.eol + this.f_descriptor);
            }
        }
        object = new CapWriter(file, this.f_package.getName());
        ((CapWriter)object).publish(this.f_header, this.f_directory, this.f_applet, this.f_import, this.f_constantPool, this.f_class, this.f_method, this.f_staticField, this.f_refLocation, this.f_export, this.f_descriptor);
    }

    HeaderComponent genHeaderComponent(JCPackage jCPackage) {
        int n = 0;
        if (jCPackage.usesIntegers()) {
            n = 1;
        }
        if (this.f_export != null && this.f_export.size() >= 4) {
            n |= 2;
        }
        if (jCPackage.appletCount() > 0) {
            n |= 4;
        }
        return new HeaderComponent(jCPackage, jCPackage.getIdentifier().getAid(), jCPackage.getIdentifier().getMajorVersion(), jCPackage.getIdentifier().getMinorVersion(), n);
    }

    ClassComponent genClassComponent(JCPackage jCPackage) {
        ClassComponent classComponent = new ClassComponent(jCPackage);
        Enumeration enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            classComponent.add((JCClass)enumeration.nextElement());
        }
        classComponent.assignAddresses();
        return classComponent;
    }

    MethodComponent genMethodComponent(JCPackage jCPackage) {
        MethodComponent methodComponent = new MethodComponent(jCPackage);
        Enumeration enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            methodComponent.add((JCClass)enumeration.nextElement());
        }
        methodComponent.assignAddresses();
        return methodComponent;
    }

    ConstantPoolComponent genConstantPoolComponent(JCPackage jCPackage) {
        ConstantPoolComponent constantPoolComponent = new ConstantPoolComponent(jCPackage);
        Enumeration enumeration = jCPackage.constantPoolElements();
        while (enumeration.hasMoreElements()) {
            constantPoolComponent.add((Info)enumeration.nextElement());
        }
        return constantPoolComponent;
    }

    ImportComponent genImportComponent(JCPackage jCPackage) {
        ImportComponent importComponent = new ImportComponent(jCPackage);
        Enumeration enumeration = jCPackage.importElements();
        while (enumeration.hasMoreElements()) {
            importComponent.add((PackageIdentifier)enumeration.nextElement());
        }
        return importComponent;
    }

    AppletComponent genAppletComponent(JCPackage jCPackage) {
        if (jCPackage.appletCount() == 0) {
            return null;
        }
        AppletComponent appletComponent = new AppletComponent(jCPackage);
        Enumeration enumeration = jCPackage.appletElements();
        while (enumeration.hasMoreElements()) {
            appletComponent.add((AppletDeclarator)enumeration.nextElement());
        }
        return appletComponent;
    }

    ExportComponent genExportComponent(JCPackage jCPackage) {
        ExportComponent exportComponent = new ExportComponent(jCPackage);
        Enumeration enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            exportComponent.add((JCClass)enumeration.nextElement());
        }
        if (exportComponent.dataSize() > 1) {
            return exportComponent;
        }
        return null;
    }

    StaticFieldComponent genStaticFieldComponent(JCPackage jCPackage) {
        StaticFieldComponent staticFieldComponent = new StaticFieldComponent(jCPackage);
        Enumeration enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            staticFieldComponent.add((JCClass)enumeration.nextElement());
        }
        staticFieldComponent.assignAddresses();
        return staticFieldComponent;
    }

    ReferenceLocationComponent genReferenceLocationComponent(JCPackage jCPackage) {
        ReferenceLocationComponent referenceLocationComponent = new ReferenceLocationComponent(jCPackage);
        Enumeration enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            referenceLocationComponent.addException((JCClass)enumeration.nextElement());
        }
        Enumeration enumeration2 = jCPackage.classElements();
        while (enumeration2.hasMoreElements()) {
            referenceLocationComponent.add((JCClass)enumeration2.nextElement());
        }
        return referenceLocationComponent;
    }

    DescriptorComponent genDescriptorComponent(JCPackage jCPackage) {
        DescriptorComponent descriptorComponent = new DescriptorComponent(jCPackage);
        Enumeration enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            descriptorComponent.add((JCClass)enumeration.nextElement());
        }
        return descriptorComponent;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "// " + this.f_package.getName() + "/javacard/";
        stringBuffer.append(String.valueOf(string) + "Header.cap" + Msg.eol + this.f_header);
        stringBuffer.append(String.valueOf(string) + "Directory.cap" + Msg.eol + this.f_directory);
        if (this.f_applet != null) {
            stringBuffer.append(String.valueOf(string) + "Applet.cap" + Msg.eol + this.f_applet);
        }
        stringBuffer.append(String.valueOf(string) + "Import.cap" + Msg.eol + this.f_import);
        stringBuffer.append(String.valueOf(string) + "ConstantPool.cap" + Msg.eol + this.f_constantPool);
        stringBuffer.append(String.valueOf(string) + "Class.cap" + Msg.eol + this.f_class);
        stringBuffer.append(String.valueOf(string) + "Method.cap" + Msg.eol + this.f_method);
        stringBuffer.append(String.valueOf(string) + "StaticField.cap" + Msg.eol + this.f_staticField);
        stringBuffer.append(String.valueOf(string) + "RefLocation.cap" + Msg.eol + this.f_refLocation);
        if (this.f_export != null) {
            stringBuffer.append(String.valueOf(string) + "Export.cap" + Msg.eol + this.f_export);
        }
        stringBuffer.append(String.valueOf(string) + "Descriptor.cap" + Msg.eol + this.f_descriptor);
        return stringBuffer.toString();
    }
}

