/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AppletComponent
extends Component {
    protected Vector appletVector = new Vector();

    AppletComponent(JCPackage jCPackage) {
        super(jCPackage);
    }

    void add(AppletDeclarator appletDeclarator) {
        this.appletVector.addElement(new AppletEntry(appletDeclarator.getAid(), appletDeclarator.resolve().getRelocAddr()));
    }

    public int size() {
        if (this.count() == 0) {
            return 0;
        }
        return super.size();
    }

    public int dataSize() {
        if (this.count() == 0) {
            return 0;
        }
        int n = 1;
        Enumeration enumeration = this.appletVector.elements();
        while (enumeration.hasMoreElements()) {
            AppletEntry appletEntry = (AppletEntry)enumeration.nextElement();
            n += appletEntry.getSize();
        }
        return n;
    }

    int count() {
        return this.appletVector.size();
    }

    protected byte[] toByteArray() {
        if (this.size() == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeByte(this.appletVector.size());
            Enumeration enumeration = this.appletVector.elements();
            while (enumeration.hasMoreElements()) {
                AppletEntry appletEntry = (AppletEntry)enumeration.nextElement();
                byte[] byArray2 = appletEntry.toByteArray();
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Count: " + this.appletVector.size() + Msg.eol);
        Enumeration enumeration = this.appletVector.elements();
        while (enumeration.hasMoreElements()) {
            AppletEntry appletEntry = (AppletEntry)enumeration.nextElement();
            stringBuffer.append(String.valueOf(appletEntry.toString()) + Msg.eol);
        }
        return stringBuffer.toString();
    }

    static class AppletEntry {
        private Aid aid;
        private int offset;

        AppletEntry(Aid aid, int n) {
            this.aid = aid;
            this.offset = n;
        }

        int getSize() {
            return this.aid.getSize() + 3;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeByte(this.aid.getSize());
                byte[] byArray = this.aid.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
                dataOutputStream.writeShort(this.offset);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("AID_length: " + this.aid.getSize());
            stringBuffer.append(", AID: " + this.aid.toString());
            stringBuffer.append(", install_method_offset: " + this.offset);
            return stringBuffer.toString();
        }
    }
}

