/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.MethodTable;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Sortable;
import com.sun.javacard.jcasm.SuperInterface;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCClass
extends Member
implements Sortable {
    public static final int MAX_INTERFACES = 15;
    public static final int MAX_FIELDS = 255;
    public static final int ACC_INTERFACE = 128;
    public static final int ACC_SHAREABLE = 64;
    protected ClassIdentifier classId;
    protected JCPackage parentPackage;
    protected JCClass superClass;
    protected String superClassName;
    protected ClassIdentifier superClassIdentifier;
    protected Vector fieldVector;
    protected boolean isShareable;
    public MethodTable publicMethodTable;
    public MethodTable packageMethodTable;
    public Vector interfaceVector;
    public Vector superInterfaceVector;
    protected int referenceCount;
    protected int firstReferenceToken;
    protected int instanceSize;
    protected Vector methodVector;
    public Hashtable methodSymbolTable;
    public Hashtable fieldSymbolTable;

    public JCClass(JCPackage jCPackage, int n, String string, ClassIdentifier classIdentifier, int n2) {
        super(n, string, n2, 0);
        Assert.PreCondition(classIdentifier != null, "id != null");
        this.parentPackage = jCPackage;
        this.classId = classIdentifier;
        this.methodSymbolTable = new Hashtable();
        this.fieldSymbolTable = new Hashtable();
        this.fieldVector = new Vector();
        this.interfaceVector = new Vector(4);
        this.methodVector = new Vector();
        this.firstReferenceToken = 255;
        this.isShareable = false;
        if (Modifier.isInterface(n)) {
            this.superInterfaceVector = new Vector();
        }
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classId;
    }

    public JCPackage getParentPackage() {
        return this.parentPackage;
    }

    public void setSuperClass(JCClass jCClass) {
        this.superClass = jCClass;
        this.superClassName = jCClass.getName();
        this.superClassIdentifier = jCClass.getClassIdentifier();
    }

    public JCClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClassName(String string) {
        this.superClassName = string;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassIdentifier(ClassIdentifier classIdentifier) {
        this.superClassIdentifier = classIdentifier;
    }

    public ClassIdentifier getSuperClassIdentifier() {
        return this.superClassIdentifier;
    }

    public void addMethod(JCMethod jCMethod) {
        Assert.PreCondition(jCMethod != null, "jcMethod != null");
        String string = jCMethod.getName();
        if (this.methodSymbolTable.containsKey(string)) {
            Object[] objectArray = new Object[]{string, this.name};
            Msg.error("class.1", objectArray);
            return;
        }
        if (Modifier.isInterface(this.attributes) && !Modifier.isAbstract(jCMethod.getAttributes())) {
            Object[] objectArray = new Object[]{jCMethod.getName(), this.name};
            Msg.error("class.9", objectArray);
            return;
        }
        MethodIdentifier methodIdentifier = jCMethod.getMethodIdentifier();
        if (methodIdentifier != null) {
            if (this.methodSymbolTable.containsKey(methodIdentifier)) {
                Object[] objectArray = new Object[]{new Integer(methodIdentifier.getMethodToken()), this.name};
                Msg.error("class.2", objectArray);
                return;
            }
            this.methodSymbolTable.put(methodIdentifier, jCMethod);
        }
        jCMethod.methodFixup();
        this.methodSymbolTable.put(string, jCMethod);
        this.methodVector.addElement(jCMethod);
    }

    public Enumeration methodElements() {
        return this.methodVector.elements();
    }

    public void addField(Field field) {
        Assert.PreCondition(field != null, "field != null");
        String string = field.getName();
        if (this.fieldSymbolTable.containsKey(string)) {
            Object[] objectArray = new Object[]{string, this.name};
            Msg.error("class.3", objectArray);
            return;
        }
        if (!(!Modifier.isInterface(this.attributes) || Modifier.isFinal(field.getAttributes()) && Modifier.isStatic(field.getAttributes()))) {
            Object[] objectArray = new Object[]{field.getName(), this.name};
            Msg.error("class.10", objectArray);
            return;
        }
        FieldIdentifier fieldIdentifier = field.getFieldIdentifier();
        if (fieldIdentifier != null) {
            if (this.fieldSymbolTable.containsKey(fieldIdentifier)) {
                Object[] objectArray = new Object[]{new Integer(fieldIdentifier.getFieldToken()), this.name};
                Msg.error("class.4", objectArray);
                return;
            }
            this.fieldSymbolTable.put(fieldIdentifier, field);
        }
        this.fieldSymbolTable.put(string, field);
        this.fieldVector.addElement(field);
    }

    public Enumeration fieldElements() {
        return this.fieldVector.elements();
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getFirstReferenceToken() {
        return this.firstReferenceToken;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    void makeShareable() {
        this.isShareable = true;
    }

    public int getInstanceBase() {
        int n = 0;
        JCClass jCClass = this.getSuperClass();
        while (jCClass != null) {
            n += jCClass.getInstanceSize();
            jCClass = jCClass.getSuperClass();
        }
        return n;
    }

    public int compare(Object object) {
        JCClass jCClass = (JCClass)object;
        if (Modifier.isInterface(jCClass.getAttributes()) && !Modifier.isInterface(this.getAttributes())) {
            return 1;
        }
        if (!Modifier.isInterface(jCClass.getAttributes()) && Modifier.isInterface(this.getAttributes())) {
            return -1;
        }
        JCClass jCClass2 = jCClass;
        while (jCClass2 != null) {
            if (jCClass2.equals(this)) {
                return -1;
            }
            jCClass2 = jCClass2.getSuperClass();
        }
        jCClass2 = this;
        while (jCClass2 != null) {
            if (jCClass2.equals(jCClass)) {
                return 1;
            }
            jCClass2 = jCClass2.getSuperClass();
        }
        return 0;
    }

    public void sortFields() {
        int n;
        int n2;
        Object object;
        this.instanceSize = 0;
        this.firstReferenceToken = 255;
        this.referenceCount = 0;
        int n3 = this.fieldVector.size() * 2;
        Field[][] fieldArray = new Field[4][n3];
        Field[] fieldArray2 = new Field[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Enumeration enumeration = this.fieldVector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            object = (Field)enumeration.nextElement();
            n2 = ((Member)object).getAttributes();
            if (Modifier.isStatic(n2)) {
                if (!((Field)object).getDescriptor().isPrimitive()) {
                    if (((Field)object).getDescriptor().isArray() && ((Field)object).getFieldInitializer() != null) {
                        fieldArray[0][n4++] = object;
                        continue;
                    }
                    fieldArray[1][n5++] = object;
                    continue;
                }
                if (((Field)object).getFieldInitializer() == null) {
                    fieldArray[2][n6++] = object;
                    continue;
                }
                fieldArray[3][n7++] = object;
                continue;
            }
            n = ((Field)object).getFieldIdentifier().getFieldToken();
            if (n > n3) {
                objectArray = new Object[]{((Member)object).getName(), ((Field)object).getParentClass().getName()};
                Msg.error("class.7", objectArray);
                continue;
            }
            if (fieldArray2[n] != null) {
                objectArray = new Object[]{((Member)object).getName(), ((Field)object).getParentClass().getName()};
                Msg.error("class.8", objectArray);
                continue;
            }
            fieldArray2[n] = object;
        }
        object = new Vector(this.fieldVector.size());
        n2 = 0;
        while (n2 < 4) {
            n = 0;
            while (n < fieldArray[0].length && fieldArray[n2][n] != null) {
                ((Vector)object).addElement(fieldArray[n2][n++]);
            }
            ++n2;
        }
        n = 0;
        int n8 = 0;
        while (n8 < fieldArray2.length) {
            Field field = fieldArray2[n8];
            if (field != null) {
                int n9 = field.getFieldIdentifier().getFieldToken();
                int n10 = Math.max(2, field.size()) / 2;
                if (n9 != n) {
                    Object[] objectArray = new Object[]{field.getName(), field.getParentClass().getName()};
                    Msg.error("class.7", objectArray);
                }
                n = n9 + n10;
                if (!field.getDescriptor().isPrimitive()) {
                    ++this.referenceCount;
                    if (this.firstReferenceToken == 255) {
                        this.firstReferenceToken = n9;
                    }
                }
                this.instanceSize += n10;
                ((Vector)object).addElement(field);
            }
            ++n8;
        }
        this.fieldVector = object;
    }

    public void addInterface(InterfaceTable interfaceTable) {
        Assert.PreCondition(interfaceTable != null, "inter != null");
        if (this.interfaceVector.size() >= 15) {
            Object[] objectArray = new Object[]{this.name};
            Msg.error("class.5", objectArray);
        }
        this.interfaceVector.addElement(interfaceTable);
    }

    public void addSuperInterface(String string) {
        Assert.PreCondition(Modifier.isInterface(this.attributes), "!isInterface");
        this.superInterfaceVector.addElement(new SuperInterface(this, string));
    }

    public void addSuperInterface(ClassIdentifier classIdentifier) {
        Assert.PreCondition(Modifier.isInterface(this.attributes), "!isInterface");
        this.superInterfaceVector.addElement(new SuperInterface(this, classIdentifier));
    }

    public Enumeration interfaceElements() {
        return this.interfaceVector.elements();
    }

    public Enumeration superInterfaceElements() {
        return this.superInterfaceVector.elements();
    }

    public byte[] toByteArray() {
        int n;
        byte[] byArray = new byte[this.size()];
        int n2 = 0;
        int n3 = n = this.isShareable ? 64 : 0;
        if (Modifier.isInterface(this.attributes)) {
            byArray[n2++] = (byte)((n |= 0x80) | this.superInterfaceVector.size() & 0xF);
            Enumeration enumeration = this.superInterfaceVector.elements();
            while (enumeration.hasMoreElements()) {
                SuperInterface superInterface = (SuperInterface)enumeration.nextElement();
                if (superInterface.isResolved()) {
                    int n4 = superInterface.resolve().getRelocAddr();
                    byArray[n2++] = (byte)(n4 >> 8 & 0xFF);
                    byArray[n2++] = (byte)(n4 & 0xFF);
                    continue;
                }
                ClassIdentifier classIdentifier = superInterface.getClassIdentifier();
                PackageIdentifier packageIdentifier = classIdentifier.getPackageIdentifier();
                byArray[n2++] = (byte)(this.parentPackage.getPackageToken(packageIdentifier) | 0x80);
                byArray[n2++] = (byte)classIdentifier.getClassToken();
            }
        } else {
            Object object;
            byArray[n2++] = (byte)(n | this.interfaceVector.size() & 0xF);
            if (this.superClass == null && this.superClassIdentifier == null) {
                byArray[n2++] = -1;
                byArray[n2++] = -1;
            } else if (this.superClass == null) {
                PackageIdentifier packageIdentifier = this.superClassIdentifier.getPackageIdentifier();
                byArray[n2++] = (byte)(this.parentPackage.getPackageToken(packageIdentifier) | 0x80);
                byArray[n2++] = (byte)this.superClassIdentifier.getClassToken();
            } else {
                int n5 = this.superClass.getRelocAddr();
                byArray[n2++] = (byte)(n5 >> 8 & 0xFF);
                byArray[n2++] = (byte)(n5 & 0xFF);
            }
            byArray[n2++] = (byte)this.instanceSize;
            byArray[n2++] = (byte)this.firstReferenceToken;
            byArray[n2++] = (byte)this.referenceCount;
            byArray[n2++] = (byte)this.publicMethodTable.getBase();
            byArray[n2++] = (byte)this.publicMethodTable.getCount();
            byArray[n2++] = (byte)this.packageMethodTable.getBase();
            byArray[n2++] = (byte)this.packageMethodTable.getCount();
            Enumeration enumeration = this.publicMethodTable.elements();
            while (enumeration.hasMoreElements()) {
                object = (JCMethod)enumeration.nextElement();
                if (object != null) {
                    int n6 = ((Member)object).getRelocAddr();
                    byArray[n2++] = (byte)(n6 >> 8 & 0xFF);
                    byArray[n2++] = (byte)(n6 & 0xFF);
                    continue;
                }
                byArray[n2++] = -1;
                byArray[n2++] = -1;
            }
            object = this.packageMethodTable.elements();
            while (object.hasMoreElements()) {
                JCMethod jCMethod = (JCMethod)object.nextElement();
                Assert.Assert(jCMethod != null, "m!= null");
                int n7 = jCMethod.getRelocAddr();
                byArray[n2++] = (byte)(n7 >> 8 & 0xFF);
                byArray[n2++] = (byte)(n7 & 0xFF);
            }
            Enumeration enumeration2 = this.interfaceVector.elements();
            while (enumeration2.hasMoreElements()) {
                InterfaceTable interfaceTable = (InterfaceTable)enumeration2.nextElement();
                byte[] byArray2 = interfaceTable.toByteArray();
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
            }
        }
        return byArray;
    }

    public int size() {
        if (Modifier.isInterface(this.attributes)) {
            return 1 + this.superInterfaceVector.size() * 2;
        }
        int n = 10 + 2 * this.packageMethodTable.getCount() + 2 * this.publicMethodTable.getCount();
        Enumeration enumeration = this.interfaceVector.elements();
        while (enumeration.hasMoreElements()) {
            InterfaceTable interfaceTable = (InterfaceTable)enumeration.nextElement();
            n += interfaceTable.size();
        }
        return n;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        if (Modifier.isInterface(this.attributes)) {
            stringBuffer.append(".interface");
        } else {
            stringBuffer.append(".class");
        }
        stringBuffer.append(" " + super.toString());
        if (this.classId != null) {
            stringBuffer.append(" <" + this.classId + ">");
        }
        stringBuffer.append(" {" + Msg.eol);
        stringBuffer.append(".fields {" + Msg.eol);
        Enumeration enumeration = this.fieldElements();
        while (enumeration.hasMoreElements()) {
            object2 = (Field)enumeration.nextElement();
            stringBuffer.append(String.valueOf(object2) + ";" + Msg.eol);
        }
        stringBuffer.append("}" + Msg.eol);
        if (this.publicMethodTable != null) {
            stringBuffer.append("public method table base: " + this.publicMethodTable.getBase() + ", ");
            stringBuffer.append("public method table count: " + this.publicMethodTable.getCount() + Msg.eol);
            object2 = this.publicMethodTable.elements();
            while (object2.hasMoreElements()) {
                object2.nextElement();
            }
        }
        if (this.packageMethodTable != null) {
            stringBuffer.append("package method table base: " + this.packageMethodTable.getBase() + ", ");
            stringBuffer.append("package method table count: " + this.packageMethodTable.getCount() + Msg.eol);
            object2 = this.publicMethodTable.elements();
            while (object2.hasMoreElements()) {
                object2.nextElement();
            }
        }
        object2 = this.interfaceVector.elements();
        while (object2.hasMoreElements()) {
            object = (InterfaceTable)object2.nextElement();
            stringBuffer.append(String.valueOf(object) + Msg.eol);
        }
        object = this.methodVector.elements();
        while (object.hasMoreElements()) {
            JCMethod jCMethod = (JCMethod)object.nextElement();
            stringBuffer.append(jCMethod);
        }
        stringBuffer.append("}" + Msg.eol);
        return stringBuffer.toString();
    }
}

