/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import java.util.Hashtable;

public class ExceptionTableEntry {
    protected JCMethod parent;
    protected String startBlock;
    protected int startOffset;
    protected String endBlock;
    protected int endOffset;
    protected String catchBlock;
    protected int catchOffset;
    protected Operand index;
    protected boolean isOuterMost;

    ExceptionTableEntry(JCMethod jCMethod, String string, Operand operand, String string2, Operand operand2, String string3, Operand operand3, Operand operand4) {
        this.parent = jCMethod;
        this.startBlock = string.toLowerCase();
        if (operand != null) {
            this.startOffset = operand.getValue();
        }
        this.endBlock = string2.toLowerCase();
        if (operand2 != null) {
            this.endOffset = operand2.getValue();
        }
        this.catchBlock = string3.toLowerCase();
        if (operand3 != null) {
            this.catchOffset = operand3.getValue();
        }
        this.index = operand4;
    }

    public int getStartOffset() {
        return this.startOffset + this.base();
    }

    public int getActiveLength() {
        return this.endOffset - this.startOffset;
    }

    public int getHandlerOffset() {
        return this.catchOffset + this.base();
    }

    public int getCatchIndex() {
        int n = 0;
        if (this.index.getType() == 8) {
            if (Globals.mode == 1) {
                n = this.index.getValue();
            } else {
                Info info = this.index.resolve();
                if (info.isResolved()) {
                    JCClass jCClass = (JCClass)info.resolve();
                    n = jCClass.getRelocAddr();
                } else {
                    n = this.index.getValue();
                }
            }
        }
        return n;
    }

    public boolean isOuterMost() {
        return this.isOuterMost;
    }

    public void fixup(Hashtable hashtable) {
        Assert.PreCondition(hashtable != null, "symbolTable != null");
        if (this.startBlock != null) {
            this.startOffset = this.lookup(hashtable, this.startBlock);
        }
        if (this.endBlock != null) {
            this.endOffset = this.lookup(hashtable, this.endBlock);
        }
        if (this.catchBlock != null) {
            this.catchOffset = this.lookup(hashtable, this.catchBlock);
        }
        if (this.endOffset < this.startOffset) {
            Object[] objectArray = new Object[]{this.parent.getName()};
            Msg.error("exceptiontable.1", objectArray);
        }
    }

    private int lookup(Hashtable hashtable, String string) {
        Integer n = (Integer)hashtable.get(string);
        if (n == null) {
            Object[] objectArray = new Object[]{string, this.parent.getName()};
            Msg.error("exceptiontable.0", objectArray);
            return 0;
        }
        return n;
    }

    public static int size() {
        return 8;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[8];
        int n = this.endOffset - this.startOffset;
        byArray[0] = (byte)(this.startOffset + this.base() >> 8);
        byArray[1] = (byte)(this.startOffset + this.base() & 0xFF);
        byArray[2] = (byte)(n >> 8 | (this.isOuterMost ? 128 : 0));
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(this.catchOffset + this.base() >> 8);
        byArray[5] = (byte)(this.catchOffset + this.base() & 0xFF);
        int n2 = this.index.getValue();
        if (Globals.mode == 1) {
            byArray[6] = (byte)(n2 >> 8 & 0xFF);
            byArray[7] = (byte)(n2 & 0xFF);
        } else if (this.index.getType() == 8) {
            Info info = this.index.resolve();
            if (info.isResolved()) {
                JCClass jCClass = (JCClass)info.resolve();
                byArray[6] = (byte)(jCClass.getRelocAddr() >> 8);
                byArray[7] = (byte)(jCClass.getRelocAddr() & 0xFF);
            } else {
                byArray[6] = (byte)(n2 >> 8 & 0xFF);
                byArray[7] = (byte)(n2 & 0xFF);
            }
        }
        return byArray;
    }

    private int base() {
        int n = this.parent.getMethodHeader().length;
        if (this.parent.isRelocated()) {
            n += this.parent.getRelocAddr();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.endOffset - this.startOffset;
        int n2 = this.isOuterMost ? 32768 : 0;
        stringBuffer.append(String.valueOf(Msg.toHexString((short)(this.startOffset + this.base()))) + " ");
        stringBuffer.append(String.valueOf(Msg.toHexString((short)(n |= n2))) + " ");
        stringBuffer.append(String.valueOf(Msg.toHexString((short)(this.catchOffset + this.base()))) + " ");
        if (this.index.getType() == 8) {
            Info info = this.index.resolve();
            if (info.isResolved()) {
                JCClass jCClass = (JCClass)info.resolve();
                if (jCClass.isRelocated()) {
                    stringBuffer.append(Msg.toHexString((short)jCClass.getRelocAddr()));
                } else {
                    stringBuffer.append(Msg.toHexString((short)0));
                }
            } else {
                stringBuffer.append(Msg.toHexString((short)this.index.getValue()));
            }
        } else {
            stringBuffer.append(Msg.toHexString((short)0));
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }
}

