/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ExceptionTable {
    protected Vector entryVector;
    protected int relocAddr;
    protected boolean relocated;
    protected JCMethod parentMethod;

    ExceptionTable(JCMethod jCMethod) {
        this.parentMethod = jCMethod;
        this.entryVector = new Vector();
    }

    public void addExceptionEntry(ExceptionTableEntry exceptionTableEntry) {
        this.entryVector.addElement(exceptionTableEntry);
    }

    public Enumeration elements() {
        return this.entryVector.elements();
    }

    public int size() {
        return this.entryVector.size() * 8;
    }

    public int count() {
        return this.entryVector.size();
    }

    public void relocate(int n) {
        this.relocAddr = n;
        this.relocated = true;
    }

    public boolean isRelocated() {
        return this.relocated;
    }

    public int getRelocAddr() {
        Assert.PreCondition(this.relocated, "!relocated");
        return this.relocAddr;
    }

    protected void fixup(Hashtable hashtable) {
        ExceptionTableEntry exceptionTableEntry;
        if (this.entryVector.size() == 0) {
            return;
        }
        Vector<ExceptionTableEntry> vector = new Vector<ExceptionTableEntry>(this.entryVector.size());
        Enumeration enumeration = this.entryVector.elements();
        while (enumeration.hasMoreElements()) {
            exceptionTableEntry = (ExceptionTableEntry)enumeration.nextElement();
            exceptionTableEntry.fixup(hashtable);
            vector.insertElementAt(exceptionTableEntry, 0);
        }
        exceptionTableEntry = null;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            ExceptionTableEntry exceptionTableEntry2 = (ExceptionTableEntry)enumeration2.nextElement();
            if (exceptionTableEntry == null) {
                exceptionTableEntry2.isOuterMost = true;
                exceptionTableEntry = exceptionTableEntry2;
                continue;
            }
            if (exceptionTableEntry.getStartOffset() <= exceptionTableEntry2.getStartOffset() && exceptionTableEntry.getStartOffset() + exceptionTableEntry.getActiveLength() >= exceptionTableEntry2.getStartOffset() + exceptionTableEntry2.getActiveLength()) continue;
            exceptionTableEntry2.isOuterMost = true;
            exceptionTableEntry = exceptionTableEntry2;
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        int n = 0;
        Enumeration enumeration = this.entryVector.elements();
        while (enumeration.hasMoreElements()) {
            ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)enumeration.nextElement();
            byte[] byArray2 = exceptionTableEntry.toByteArray();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".exceptionTable {" + Msg.eol);
        Enumeration enumeration = this.entryVector.elements();
        while (enumeration.hasMoreElements()) {
            ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)enumeration.nextElement();
            stringBuffer.append(String.valueOf(exceptionTableEntry.toString()) + Msg.eol);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

