/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.installer;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.installer.Component;
import com.sun.javacard.installer.InstallerException;

class ClassComponent
extends Component {
    static final short MODE_PUB = 1;
    static final short MODE_PKG = 2;

    void process() throws InstallerException {
        Component.load();
    }

    void postProcess() throws InstallerException {
        short m_offset = 0;
        short m_classCompAddr = Component.g_componentAddresses[6];
        while (m_offset < Component.g_compSize) {
            short i;
            short m_curClassAddr = (short)(m_classCompAddr + m_offset);
            byte m_b1 = NativeMethods.readByte(m_curClassAddr, (short)0);
            short m_interfaceCount = (short)(m_b1 & 0xF);
            if (ClassComponent.isInterface(m_b1)) {
                m_offset = (short)(m_offset + 1);
                i = 0;
                while (i < m_interfaceCount) {
                    Component.resolve(m_classCompAddr, m_offset, (byte)6);
                    m_offset = (short)(m_offset + 2);
                    i = (short)(i + 1);
                }
                continue;
            }
            short m_superClassAddr = Component.resolve(m_curClassAddr, (short)1, (byte)6);
            short m_s1 = (short)(ClassComponent.getInstanceSize(m_superClassAddr) + ClassComponent.getInstanceSize(m_curClassAddr));
            if (m_s1 > 255) {
                InstallerException.throwIt((short)24645);
            }
            NativeMethods.writeByte(m_curClassAddr, (short)3, (byte)m_s1);
            short m_base = NativeMethods.readByte(m_curClassAddr, (short)6);
            m_base = (short)(m_base & 0xFF);
            short m_count = NativeMethods.readByte(m_curClassAddr, (short)7);
            m_count = (short)(m_count & 0xFF);
            m_offset = (short)(m_offset + 10);
            i = 0;
            while (i < m_count) {
                m_s1 = NativeMethods.readShort(m_classCompAddr, m_offset);
                m_s1 = m_s1 == -1 ? ClassComponent.getVirtualMethodAddress(m_superClassAddr, (byte)(i + m_base)) : (short)(Component.g_componentAddresses[7] + m_s1);
                NativeMethods.writeShort(m_classCompAddr, m_offset, m_s1);
                m_offset = (short)(m_offset + 2);
                i = (short)(i + 1);
            }
            m_base = NativeMethods.readByte(m_curClassAddr, (short)8);
            m_base = (short)(m_base & 0xFF);
            m_base = (short)(m_base + ClassComponent.getPkgMethodBaseAdjustment(m_curClassAddr));
            m_count = NativeMethods.readByte(m_curClassAddr, (short)9);
            if ((short)(m_base + (m_count = (short)(m_count & 0xFF))) > 127) {
                InstallerException.throwIt((short)24642);
            }
            short i2 = 0;
            while (i2 < m_count) {
                Component.resolve(m_classCompAddr, m_offset, (byte)7);
                m_offset = (short)(m_offset + 2);
                i2 = (short)(i2 + 1);
            }
            short i3 = 0;
            while (i3 < m_interfaceCount) {
                Component.resolve(m_classCompAddr, m_offset, (byte)6);
                m_b1 = NativeMethods.readByte(m_classCompAddr, (short)(m_offset + 2));
                m_offset = (short)(m_offset + (short)((short)m_b1 + 3));
                i3 = (short)(i3 + 1);
            }
        }
        Component.setComplete((short)6);
    }

    static short getMethodAddress(short classAddr, byte methodToken) throws InstallerException {
        int methodType;
        short m_pubMethodCount = NativeMethods.readByte(classAddr, (short)7);
        short m_offset = 10;
        if (Component.isHighbitOn(methodToken)) {
            m_offset = (short)(m_offset + (short)(m_pubMethodCount * 2));
            methodToken = (byte)(methodToken & 0x7F);
            methodType = 2;
        } else {
            methodType = 1;
        }
        byte m_base = ClassComponent.getMethodBase(classAddr, (short)methodType);
        m_offset = (short)(m_offset + (short)((short)(methodToken - m_base) * 2));
        return NativeMethods.readShort(classAddr, m_offset);
    }

    static short getInstanceSize(short classAddr) throws InstallerException {
        short m_instanceSize = NativeMethods.readByte(classAddr, (short)3);
        m_instanceSize = (short)(m_instanceSize & 0xFF);
        return m_instanceSize;
    }

    static byte getMethodBase(short classAddr, short mode) {
        return NativeMethods.readByte(classAddr, mode == 1 ? (short)6 : 8);
    }

    static boolean isInterface(byte bitfield) {
        return (bitfield & 0xFFFFFF80) == -128;
    }

    static byte calcInstanceSize(short classAddr, byte token) throws InstallerException {
        short superAddr = NativeMethods.readShort(classAddr, (short)1);
        short m_instanceSize = ClassComponent.getInstanceSize(superAddr);
        if ((m_instanceSize = (short)(m_instanceSize + (short)((short)token & 0xFF))) > 255) {
            InstallerException.throwIt((short)24645);
        }
        return (byte)m_instanceSize;
    }

    static short getVirtualMethodAddress(short classAddr, byte methodToken) throws InstallerException {
        boolean m_goSuper = false;
        if (Component.isHighbitOn(methodToken)) {
            m_goSuper = ClassComponent.getMethodBase(classAddr, (short)2) > (byte)(methodToken & 0x7F);
        } else {
            boolean bl = m_goSuper = ClassComponent.getMethodBase(classAddr, (short)1) > methodToken;
        }
        if (m_goSuper) {
            short superAddress = NativeMethods.readShort(classAddr, (short)1);
            return ClassComponent.getVirtualMethodAddress(superAddress, methodToken);
        }
        return ClassComponent.getMethodAddress(classAddr, methodToken);
    }

    static short getPkgMethodBaseAdjustment(short classAddress) {
        if (classAddress >= Component.g_componentAddresses[6] && classAddress <= Component.g_classComponentLastOffset) {
            return ClassComponent.getPkgMethodBaseAdjustment(NativeMethods.readShort(classAddress, (short)1));
        }
        short m_pkgBase = NativeMethods.readByte(classAddress, (short)8);
        m_pkgBase = (short)(m_pkgBase & 0xFF);
        short m_pkgCount = NativeMethods.readByte(classAddress, (short)9);
        m_pkgCount = (short)(m_pkgCount & 0xFF);
        return (short)(m_pkgBase + m_pkgCount);
    }

    ClassComponent() {
    }
}

