/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import com.sun.javacard.impl.AppTable;
import com.sun.javacard.impl.Installer;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackedBoolean;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.JCSystem;
import javacard.framework.Shareable;

public class PrivAccess {
    public static final byte APP_FIRST = 0;
    public static final byte APPS_MAX = 16;
    public static final byte APP_NULL = -1;
    public static final byte JCRE_CONTEXTID = 0;
    public static final byte NULL_CONTEXTID = 15;
    public static final byte APPID_BITMASK = 15;
    private static byte defaultAppID;
    private static PackedBoolean thePackedBoolean;
    private static PrivAccess thePrivAccess;
    private static final byte NUMBER_SYSTEM_BOOLS = 16;
    private static byte selectingAppletFlag;
    public static final byte APP_STATE_NONE = 0;
    public static final byte APP_STATE_PRELOAD = 1;
    public static final byte APP_STATE_LOADED = 2;
    public static final byte APP_STATE_REGISTERED = 3;
    public static final byte APP_STATE_SELECTABLE = 4;

    public PrivAccess() {
        thePrivAccess = this;
    }

    public static PackedBoolean getPackedBoolean() {
        if (thePackedBoolean == null) {
            thePackedBoolean = new PackedBoolean(2);
        }
        return thePackedBoolean;
    }

    public static PrivAccess getPrivAccess() {
        return thePrivAccess;
    }

    public static void setSelectingAppletFlag() {
        thePackedBoolean.set(selectingAppletFlag);
    }

    public static void resetSelectingAppletFlag() {
        thePackedBoolean.reset(selectingAppletFlag);
    }

    public static byte getSelectedAppID() {
        byte contextId = NativeMethods.getSelectedContext();
        if (contextId == 15) {
            return -1;
        }
        return (byte)(contextId & 0xF);
    }

    public static Applet getSelectedApplet() {
        return AppTable.theAppTable[PrivAccess.getSelectedAppID()].theApplet;
    }

    public static void selectDefaultApplet() {
        PrivAccess.selectOnly(defaultAppID);
    }

    public static void selectOnly(byte theAppID) {
        boolean success = false;
        PrivAccess.setSelectingAppletFlag();
        try {
            NativeMethods.setSelectedContext(PrivAccess.getContextId(theAppID));
            success = PrivAccess.getSelectedApplet().select();
        }
        finally {
            Object var3_2 = null;
            if (JCSystem.getTransactionDepth() != 0) {
                success = false;
                JCSystem.abortTransaction();
            }
            if (success) {
                return;
            }
        }
        NativeMethods.setSelectedContext((byte)15);
    }

    public static void deselectOnly() {
        Applet theApp = PrivAccess.getSelectedApplet();
        if (theApp == null) {
            return;
        }
        try {
            theApp.deselect();
        }
        finally {
            Object var2_1 = null;
            NativeMethods.clearTransientObjs((byte)2);
            if (JCSystem.getTransactionDepth() != 0) {
                JCSystem.abortTransaction();
            }
        }
    }

    public static void selectApplet(byte theAppID) {
        PrivAccess.deselectOnly();
        PrivAccess.selectOnly(theAppID);
    }

    public static byte getAppState(AID theAID) {
        byte appID = AppTable.findApplet(theAID);
        if (appID != -1) {
            return AppTable.theAppState[appID];
        }
        appID = AppTable.findAppletByClass(theAID);
        if (appID != -1) {
            return 2;
        }
        return 0;
    }

    public static void setAppState(AID theAID, byte theState) {
        byte appID = AppTable.findApplet(theAID);
        AppTable.theAppState[appID] = theState;
    }

    public static byte getCurrentAppID() {
        byte contextId = NativeMethods.getCurrentContext();
        if (contextId == 15) {
            return -1;
        }
        return (byte)(contextId & 0xF);
    }

    public static byte getPreviousAppID() {
        byte contextId = NativeMethods.getPreviousContext();
        if (contextId == 15) {
            return -1;
        }
        return (byte)(contextId & 0xF);
    }

    public static byte getContextId(byte appID) {
        return (byte)(AppTable.theAppTable[appID].theContext << 4 | appID);
    }

    public static byte getAppEntry(AID theClassAID) {
        byte appID = AppTable.findAppletByClass(theClassAID);
        if (appID != -1 && AppTable.theAppState[appID] != 2) {
            byte theContext = AppTable.theAppTable[appID].theContext;
            short theAddress = AppTable.theAppTable[appID].theInstallMethod;
            appID = AppTable.addApplet(theClassAID);
            AppTable.theAppTable[appID].theContext = theContext;
            AppTable.theAppTable[appID].theInstallMethod = theAddress;
        }
        return appID;
    }

    public static void initialize(APDU theAPDU) {
        selectingAppletFlag = PrivAccess.getPackedBoolean().allocate();
        byte[] temp = theAPDU.getBuffer();
        byte i = 0;
        while (true) {
            byte appID;
            byte[] bArray = null;
            short bOffset = 0;
            byte bLength = 0;
            short methodAddr = NativeMethods.getInstallMethod(i, temp);
            if (methodAddr == -1) break;
            AID theClassAID = new AID(temp, 2, temp[1]);
            NativeMethods.setJCREentry(theClassAID, false);
            if (i == 0) {
                appID = Installer.addApplet(theClassAID, (byte)0, methodAddr);
                AppTable.theAppState[appID] = 2;
                AID theAID = Installer.installApplet(bArray, bOffset, bLength, theClassAID);
                if (theAID != null) {
                    PrivAccess.setAppState(theAID, (byte)4);
                }
            } else {
                appID = Installer.addApplet(theClassAID, temp[0], methodAddr);
                AppTable.theAppState[appID] = 2;
            }
            i = (byte)(i + 1);
        }
    }

    public boolean selectingApplet() {
        return thePackedBoolean.get(selectingAppletFlag);
    }

    public final void register(Applet theApplet) {
        AppTable.register(theApplet, null);
    }

    public final void register(Applet theApplet, byte[] bArray, short bOffset, byte bLength) {
        AID theAID = new AID(bArray, bOffset, bLength);
        NativeMethods.setJCREentry(theAID, false);
        AppTable.register(theApplet, theAID);
    }

    public Shareable getSharedObject(AID serverAID, byte param) {
        AID clientAID = this.getAID((byte)(NativeMethods.getPreviousContext() & 0xF));
        byte appID = AppTable.findApplet(serverAID);
        if (appID != -1) {
            return AppTable.theAppTable[appID].theApplet.getShareableInterfaceObject(clientAID, param);
        }
        return null;
    }

    public AID getAID(byte[] aidArray, short aidOff, byte aidLength) {
        byte appID = AppTable.findApplet(aidArray, aidOff, aidLength);
        if (appID != -1) {
            return AppTable.theAppTable[appID].theAID;
        }
        return null;
    }

    public AID getAID(byte appID) {
        return AppTable.theAppTable[appID].theAID;
    }
}

