/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.PackageEntry;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimulationException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javacard.framework.AID;

public class MaskedApplets {
    private static final int MAX_APPS = 16;
    private static final int MAX_AID_LENGTH = 16;
    private static final int MAX_PARM_LENGTH = 32;
    private static final byte INSTALL_METHOD_ADDRESS = 1;
    private static final byte PACKAGE_ID = 2;
    private static int appIndex = 0;
    private static int pkgIndex = 0;
    private static String[] romAppPkgName = new String[16];
    private static String[] romAppClass = new String[16];
    private static Method[] romAppInstallMethod = new Method[16];
    private static byte[][] romAppAID = new byte[16][];
    private static int maxAppNum = 15;
    static Vector pkgTableVector;

    public static void readConfigFile(String configFile) {
        pkgTableVector = new Vector();
        PackageMgr.packageContextTable = new byte[16];
        PackageMgr.f_pkgTable = new PackageEntry[33];
        try {
            String aString;
            BufferedReader in = new BufferedReader(new FileReader(configFile));
            while ((aString = in.readLine()) != null) {
                if ((aString = aString.trim().replace('\t', ' ')).startsWith("//") || aString.length() == 0) continue;
                int spIndex = aString.indexOf(" ");
                int lastSpIndex = aString.lastIndexOf(" ");
                if (spIndex == -1 || aString.substring(spIndex, lastSpIndex).trim().length() != 0) {
                    System.err.println(Globals._messages.getString("BadCFG") + aString);
                    throw new SimulationException();
                }
                String classStr = aString.substring(0, spIndex);
                String aidStr = aString.substring(lastSpIndex).trim();
                if (aidStr.indexOf(" ") != -1) {
                    System.err.println(Globals._messages.getString("BadCFG") + aString);
                    throw new SimulationException();
                }
                MaskedApplets.addAppletToPackageTable(classStr, aidStr);
                int appIndex = MaskedApplets.addApplet(classStr);
                MaskedApplets.setAppletAID(appIndex, aidStr);
            }
            for (int i = 0; i < pkgTableVector.size(); ++i) {
                TempPkgTableEntry entry = (TempPkgTableEntry)pkgTableVector.elementAt(i);
                entry.addToPackageTable((byte)i);
            }
        }
        catch (IOException e) {
            System.err.println(e);
            throw new SimulationException();
        }
        if (MaskedApplets.getNumberOfROMApplets() == 0) {
            System.err.println(Globals._messages.getString("CFGError") + configFile);
            throw new SimulationException();
        }
    }

    static void addAppletToPackageTable(String pkgName, String aidStr) {
        boolean pkgFound = false;
        pkgName = pkgName.substring(0, pkgName.lastIndexOf(46));
        for (int i = 0; i < pkgTableVector.size(); ++i) {
            TempPkgTableEntry entry = (TempPkgTableEntry)pkgTableVector.elementAt(i);
            if (!entry.pkgName.equals(pkgName)) continue;
            pkgFound = true;
            entry.addApplet(aidStr);
        }
        if (!pkgFound) {
            TempPkgTableEntry entry = new TempPkgTableEntry(pkgName, aidStr);
            pkgTableVector.addElement(entry);
        }
    }

    public static int addApplet(String name) {
        if (appIndex >= 16) {
            System.err.println(Globals._messages.getString("MaxApp"));
            throw new RuntimeException();
        }
        MaskedApplets.romAppClass[MaskedApplets.appIndex] = name;
        String pkgName = name.substring(0, name.lastIndexOf(46));
        int pkgIdx = MaskedApplets.pkgInTable(pkgName);
        if (pkgIdx == -1) {
            MaskedApplets.romAppPkgName[MaskedApplets.pkgIndex] = pkgName;
            ++pkgIndex;
        }
        return appIndex++;
    }

    private static int pkgInTable(String pkgName) {
        for (int i = 0; i < pkgIndex; ++i) {
            if (!pkgName.equals(romAppPkgName[i])) continue;
            return i;
        }
        return -1;
    }

    public static int getNumberOfROMApplets() {
        return appIndex;
    }

    private static byte[] convertStringToBytes(String aidString, int maxLength) {
        byte[] bArray = new byte[maxLength];
        int digitNumber = 0;
        aidString = aidString.trim();
        int beginOffset = 0;
        int endOffset = 0;
        Integer num = null;
        while (beginOffset < aidString.length()) {
            endOffset = aidString.indexOf(":", beginOffset);
            num = endOffset == -1 ? Integer.decode(aidString.substring(beginOffset)) : Integer.decode(aidString.substring(beginOffset, endOffset));
            if (digitNumber >= maxLength) {
                System.err.println(Globals._messages.getString("BadAID") + aidString);
                throw new SimulationException();
            }
            bArray[digitNumber++] = num.byteValue();
            if (endOffset == -1) break;
            beginOffset = ++endOffset;
        }
        byte[] returnArray = new byte[digitNumber];
        System.arraycopy(bArray, 0, returnArray, 0, returnArray.length);
        return returnArray;
    }

    public static void setAppletAID(int appIndex, String aidString) {
        MaskedApplets.romAppAID[appIndex] = MaskedApplets.getAppletAID(aidString);
    }

    private static byte[] getAppletAID(String aidString) {
        byte[] aidArray;
        if ((aidString = aidString.trim()).startsWith("\"") && aidString.endsWith("\"")) {
            aidString = aidString.substring(1, aidString.length() - 1);
            aidArray = aidString.getBytes();
        } else {
            aidArray = MaskedApplets.convertStringToBytes(aidString, 16);
        }
        if (aidArray == null || aidArray.length < 5) {
            System.err.println(Globals._messages.getString("ShortAID") + aidString);
            throw new RuntimeException();
        }
        return aidArray;
    }

    public static short getAppInstallMethod(byte[] bArray, short offset, byte length) {
        int index = -1;
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            byte[] aidArray = romAppAID[i];
            if (aidArray == null || aidArray.length != length) continue;
            index = i;
            for (byte j = 0; j < length; j = (byte)(j + 1)) {
                if (aidArray[j] == bArray[offset + j]) continue;
                index = -1;
                break;
            }
            if (index == -1) continue;
            return MaskedApplets.getInstallInstance((byte)index);
        }
        return -1;
    }

    public static short getInstallInstance(byte index) {
        Method appInstall = null;
        try {
            Class<?> myAppletClass = Class.forName(romAppClass[index]);
            Object[] installParms = new Object[]{null, new Short(0), new Byte(0)};
            Class[] installParmsClass = new Class[]{Class.forName("[B"), Short.TYPE, Byte.TYPE};
            appInstall = myAppletClass.getMethod("install", installParmsClass);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println(e);
            throw new SimulationException();
        }
        if (appInstall == null) {
            return -1;
        }
        MaskedApplets.romAppInstallMethod[index] = appInstall;
        return index;
    }

    public static void install(byte index, byte[] bArray, short bOffset, byte bLength) {
        Object[] installParms = new Object[]{bArray, new Short(bOffset), new Byte(bLength)};
        try {
            AppletMgr.installTransactionFlag = true;
            romAppInstallMethod[index].invoke(null, installParms);
        }
        catch (InvocationTargetException ex) {
            System.err.println(Globals._messages.getString("SickChd") + romAppInstallMethod[index]);
            throw new SimulationException();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println(e);
            throw new SimulationException();
        }
        finally {
            AppletMgr.installTransactionFlag = false;
        }
    }

    static class TempPkgTableEntry {
        String pkgName;
        Vector appletAIDs;
        int appletCount;

        TempPkgTableEntry(String pkg, String app) {
            this.pkgName = pkg;
            this.appletAIDs = new Vector();
            this.appletAIDs.addElement(app);
            this.appletCount = 1;
        }

        void addApplet(String app) {
            this.appletAIDs.addElement(app);
            ++this.appletCount;
        }

        void addToPackageTable(byte pkgId) {
            PackageMgr.f_pkgTable[pkgId] = new PackageEntry(null, 0, 0, 0);
            PackageMgr.f_pkgTable[pkgId].initializeAppletArray((byte)this.appletCount);
            for (int i = 0; i < this.appletCount; ++i) {
                String aidStr = (String)this.appletAIDs.elementAt(i);
                byte[] aid = MaskedApplets.getAppletAID(aidStr);
                short installMethodAddress = MaskedApplets.getAppInstallMethod(aid, (short)0, (byte)aid.length);
                AID aidObject = new AID(aid, 0, (byte)aid.length);
                PackageMgr.f_pkgTable[pkgId].addAppletInfo(aidObject, installMethodAddress);
            }
            PackageMgr.packageContextTable[pkgId] = pkgId;
        }
    }
}

