/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeNull;

class TypeClass
extends Type {
    int classref;

    TypeClass(int cref) {
        this.classref = cref;
    }

    @Override
    Type normalize() {
        if ((Classref.checkAndGetAccessFlags(this.classref) & 0x40) != 0) {
            TypeClass ty = new TypeClass(Classref.Object);
            ty.beforeNormalization = this;
            return ty;
        }
        return this;
    }

    public boolean equals(Object ty) {
        return ty != null && ty instanceof TypeClass && ((TypeClass)ty).classref == this.classref;
    }

    @Override
    boolean isSubtype(Type ty) {
        return ty instanceof TypeClass && Classref.isSubclass(this.classref, ((TypeClass)ty).classref);
    }

    @Override
    Type lub(Type ty) {
        if (ty instanceof TypeClass) {
            return new TypeClass(Classref.lub(this.classref, ((TypeClass)ty).classref));
        }
        if (ty instanceof TypeArray) {
            return new TypeClass(Classref.Object);
        }
        if (ty instanceof TypeNull) {
            return this;
        }
        return null;
    }

    public int hashCode() {
        return this.classref;
    }

    @Override
    String toStringAux() {
        return Classref.pretty(this.classref);
    }
}

