/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.RemoteMethodInfo;
import com.sun.javacard.jcasm.SignaturePool;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.cap.StaticFieldComponent;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.PackageTableEntry;
import com.sun.javacard.jcasm.mask.PackageTableManager;
import com.sun.javacard.jcasm.mask.RomMask;
import com.sun.javacard.jcasm.mask.TableManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class CrefOutputFormatter
extends OutputFormatter {
    public static final int METHOD_LIMIT = Short.MAX_VALUE;
    public static CrefOutputFormatter cof;
    protected StringBuffer preamble;
    protected StringBuffer rom;
    protected StringBuffer rom_AidAndPkgTblEntries;
    protected StringBuffer rom_GrtObjectPkgFilledTable;
    protected StringBuffer exceptionsAndExports;
    protected StringBuffer exceptionTableLinkedList;
    protected int romLength = 0;
    protected StringBuffer staticFields;
    protected String packageTableField;
    protected String packageContextTableField;
    protected StringBuffer staticInit;
    protected int staticInitSize = 0;
    protected int npackages = 0;
    static final int exceptionEntrySize = 8;
    static int exceptionTableHeaderSize;
    static final String BYTE_CLASS_NAME = "[B";
    protected int exportComponentLength;
    protected int nExceptionEntries = 0;
    protected int nextExceptionTable = 0;
    protected StringBuffer defineList;
    protected int m_apiPkgCount = -1;
    protected Hashtable<JCPackage, StaticFieldComponent> packageFields;
    PackageDirectory packageDirectory;
    protected Vector<String> suppressionVector;
    static TableManager objectManager;
    static TableManager exportedRefManager;
    static PackageTableManager ptm;
    static StringBuffer initializedArrays;
    private JCPackage currentPackage;
    private int currentEEPROMAddr;
    private int m_romBase = 0;
    private int m_e2Base = 32768;
    private int romAddrForExceptionsAndExports = 0;
    public static final int ARRAY_HEADER_SIZE = 7;
    static final byte OBJECT_TYPE_BYTE_ARRAY = -128;
    static final byte OBJECT_TYPE_BOOLEAN_ARRAY = 96;
    static final byte OBJECT_TYPE_SHORT_ARRAY = -96;
    static final byte OBJECT_TYPE_INT_ARRAY = -64;
    int currentRomAddr;

    public CrefOutputFormatter(BufferedReader configFile) throws IOException {
        super(configFile);
        cof = this;
        this.preamble = new StringBuffer();
        this.preamble.append("#include \"profile.h\"" + Msg.eol);
        this.preamble.append("#include \"opcode.h\"" + Msg.eol);
        this.preamble.append("#include \"mask.h\"" + Msg.eol);
        this.rom = new StringBuffer();
        this.rom_AidAndPkgTblEntries = new StringBuffer();
        this.rom_GrtObjectPkgFilledTable = new StringBuffer();
        this.exceptionsAndExports = new StringBuffer();
        this.staticFields = new StringBuffer();
        this.staticInit = new StringBuffer();
        this.defineList = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
        this.suppressionVector = new Vector();
        this.packageFields = new Hashtable();
        objectManager = new TableManager(1);
        exportedRefManager = new TableManager(0);
        ptm = new PackageTableManager();
        initializedArrays = new StringBuffer();
        try {
            String strRomBase = this.getMapEntry("ROMBASE");
            if (strRomBase != null) {
                this.m_romBase = Integer.decode(strRomBase);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.0", null);
        }
        try {
            String strE2Base = this.getMapEntry("E2BASE");
            if (strE2Base != null) {
                this.m_e2Base = Integer.decode(strE2Base);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.1", null);
        }
        try {
            String apiPkgCountStr = this.getMapEntry("API_PACKAGES_COUNT");
            if (apiPkgCountStr != null) {
                this.m_apiPkgCount = Integer.decode(apiPkgCountStr);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.0", null);
        }
        String noExportComponent = this.getMapEntry("NOEXPORTCOMPONENT");
        if (noExportComponent != null) {
            StringTokenizer parser = new StringTokenizer(noExportComponent, ",");
            while (parser.hasMoreTokens()) {
                this.suppressionVector.addElement(parser.nextToken().trim());
            }
        }
        this.packageTableField = this.getMapEntry("PACKAGE_TABLE");
        this.packageContextTableField = this.getMapEntry("PACKAGE_CONTEXT_TABLE");
        if (this.packageTableField == null || this.packageContextTableField == null) {
            Msg.error("cref.4", null);
            Main.printStatus();
        }
        this.currentEEPROMAddr = this.m_e2Base;
        if (Main.FLAG_32_BIT) {
            exceptionTableHeaderSize = 9;
        }
    }

    public static TableManager getExportedRefManager() {
        return exportedRefManager;
    }

    public static JCPackage getCurrentPackage() {
        return CrefOutputFormatter.cof.currentPackage;
    }

    @Override
    public void format(RomMask r) {
        this.pass1(r);
        if (Globals.errors == 0) {
            this.pass2(r);
        }
    }

    int getCurrentEEPROMAddr() {
        return this.currentEEPROMAddr;
    }

    void setCurrentEEPROMAddr(int newAddr) {
        this.currentEEPROMAddr = newAddr;
    }

    private int prepareRemotePackageForMasking(JCPackage p) {
        int addr = 0;
        int size = 0;
        Enumeration<JCClass> f = p.classElements();
        while (f.hasMoreElements()) {
            JCClass c = f.nextElement();
            c.relocate(addr++);
        }
        size = p.getSignaturePool().getSize();
        return size;
    }

    protected void pass1(RomMask r) {
        String installerPkgName = this.getMapEntry("INSTALLER_APPLET_PACKAGE");
        short nativeToken = 1;
        this.currentRomAddr = this.m_romBase;
        int pkgId = -1;
        Enumeration<JCPackage> e = r.packageElements();
        while (e.hasMoreElements()) {
            int classCompOffset = 0;
            int staticFieldCompOffset = 0;
            int methodCompOffset = 0;
            JCPackage p = e.nextElement();
            this.packageDirectory.addPackage(p.getIdentifier());
            if (p.appletCount() > 0) {
                if (p.getName().equals(installerPkgName)) {
                    ptm.addAppletPackageContext(this.packageDirectory.indexOf(p.getIdentifier()), true);
                } else {
                    ptm.addAppletPackageContext(this.packageDirectory.indexOf(p.getIdentifier()), false);
                }
            }
            ++pkgId;
            PackageTableEntry pe = ptm.addPackage(p);
            StaticFieldComponent sfc = new StaticFieldComponent(p);
            this.packageFields.put(p, sfc);
            if (p.hasRemote()) {
                pe.setPkgNameInfo(p.getName().getBytes());
                int sigSize = this.prepareRemotePackageForMasking(p);
                p.getSignaturePool().relocate(classCompOffset);
                classCompOffset += 2;
                classCompOffset += p.getSignaturePool().getSize();
                p.purgeSignaturePool();
            }
            Enumeration<JCClass> f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = f.nextElement();
                sfc.add(c);
                c.relocate(classCompOffset);
                if (c.isExported()) {
                    exportedRefManager.addExportedReference(c, classCompOffset, pkgId);
                }
                classCompOffset += c.size();
                if (Modifier.isInterface(c.getAttributes())) continue;
                Enumeration<JCMethod> g = c.methodElements();
                while (g.hasMoreElements()) {
                    JCMethod m = g.nextElement();
                    m.relocate(methodCompOffset);
                    if (m.isGRTCandidate()) {
                        exportedRefManager.addExportedReference(m, methodCompOffset, pkgId);
                    }
                    methodCompOffset += m.size();
                    if (!Modifier.isNative(m.getAttributes())) continue;
                    m.setNativeToken(nativeToken);
                    nativeToken = (short)(nativeToken + 1);
                    ++methodCompOffset;
                }
            }
            for (int i = 1; i <= 4; ++i) {
                for (Field field : sfc.getSegment(i)) {
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                    if (field.isExportCompCandidate()) {
                        exportedRefManager.addExportedReference(field, staticFieldCompOffset, pkgId);
                    }
                    field.relocate(staticFieldCompOffset);
                    staticFieldCompOffset += field.size();
                }
            }
            pe.setStaticRefFieldCount(sfc.getReferenceFieldCount());
            pe.setPackageComponentLocation(0, this.currentRomAddr, classCompOffset);
            this.currentRomAddr += classCompOffset;
            pe.setPackageComponentLocation(1, this.currentRomAddr, methodCompOffset);
            this.currentRomAddr += methodCompOffset;
            pe.setPackageComponentLocation(2, this.currentEEPROMAddr, staticFieldCompOffset);
            this.currentEEPROMAddr += staticFieldCompOffset;
        }
        exportedRefManager.resolveExportAddresses();
        ptm.createAndAddPackageTableInfo(r);
        this.romAddrForExceptionsAndExports = CrefOutputFormatter.cof.currentRomAddr;
        initializedArrays.append("/* Static Initialized Array Data @" + Msg.toAddressString(this.currentEEPROMAddr) + "*/" + Msg.eol);
    }

    protected void pass2(RomMask r) {
        int exceptionAndExportBase = this.romAddrForExceptionsAndExports;
        Enumeration<JCPackage> e = r.packageElements();
        while (e.hasMoreElements()) {
            int i;
            this.nExceptionEntries = 0;
            StringBuffer classCompBuff = new StringBuffer();
            StringBuffer methodCompBuff = new StringBuffer();
            StringBuffer exceptionTable = new StringBuffer();
            this.currentPackage = e.nextElement();
            PackageTableEntry pe = ptm.getPackageEntry(this.currentPackage);
            boolean suppressExportComponent = this.suppressionVector.contains(this.currentPackage.getName());
            ExportComponent export = new ExportComponent(this.currentPackage);
            ExportComponent.setOutputMode(1);
            String mapTo = this.getMapEntry(this.currentPackage.getName());
            if (mapTo != null) {
                this.defineList.append("#define " + mapTo + " " + this.npackages + "\t/* " + this.currentPackage.getName() + " */" + Msg.eol);
            }
            ++this.npackages;
            if (this.currentPackage.is22Package()) {
                classCompBuff.append(Msg.eol + "/* " + this.currentPackage.getName() + " Signature Pool Length and Signature Pool */" + Msg.eol);
                classCompBuff.append("HIGH(" + Msg.toHexString((short)this.currentPackage.getSignaturePool().getSize()) + "), ");
                classCompBuff.append("LOW(" + Msg.toHexString((short)this.currentPackage.getSignaturePool().getSize()) + "), ");
                if (this.currentPackage.getSignaturePool().getSize() > 0) {
                    SignaturePool sp = this.currentPackage.getSignaturePool();
                    for (i = 0; i < sp.methodSignaturePool.size(); ++i) {
                        TypeDescriptorEntry desc = sp.methodSignaturePool.elementAt(i);
                        byte[] data = desc.getData();
                        classCompBuff.append(Msg.toHexString(data, ", ") + ", ");
                    }
                    classCompBuff.append(Msg.eol);
                }
            }
            Enumeration<JCClass> f = this.currentPackage.classElements();
            while (f.hasMoreElements()) {
                JCClass c = f.nextElement();
                if (!suppressExportComponent) {
                    export.add(c);
                }
                if (!this.outputClassInfo(c, classCompBuff, pe)) continue;
                this.outputFieldMappingInfo(c);
                this.outputMethods(c, methodCompBuff, exceptionTable, pe);
            }
            if (this.nExceptionEntries > 0) {
                StringBuffer temp = this.getExceptionTableHeader();
                this.exceptionsAndExports.append(temp.toString());
                this.exceptionsAndExports.append(exceptionTable.toString());
            }
            this.rom.append(Msg.eol + "/* Class Component for " + this.currentPackage.getName() + " */" + Msg.eol);
            this.rom.append(classCompBuff);
            this.rom.append(Msg.eol + "/* Method Component for " + this.currentPackage.getName() + " */" + Msg.eol);
            this.rom.append(methodCompBuff);
            byte[] exportComponentByteArray = export.toByteArray();
            this.exceptionsAndExports.append("/* Export Component for " + this.currentPackage.getName() + "@" + Msg.toAddressString(this.romAddrForExceptionsAndExports) + " */" + Msg.eol);
            for (i = 3; i < exportComponentByteArray.length; ++i) {
                this.exceptionsAndExports.append(Msg.toHexString(exportComponentByteArray[i]) + ", ");
                if (i % 8 != 7) continue;
                this.exceptionsAndExports.append(Msg.eol);
            }
            ptm.getPackageEntry(this.currentPackage).setPackageComponentLocation(3, this.romAddrForExceptionsAndExports, exportComponentByteArray.length - 3);
            this.exceptionsAndExports.append(Msg.eol);
            this.exportComponentLength += exportComponentByteArray.length - 3;
            this.romAddrForExceptionsAndExports += exportComponentByteArray.length - 3;
            this.outputStaticFields(r, pe);
        }
        this.defineList.append("#define VM_ARRAY_IMPLEMENTATION_PKG " + this.packageDirectory.indexOf(this.currentPackage.getIdentifier()));
        this.defineList.append(Msg.eol);
        this.defineList.append(Msg.eol);
        this.currentRomAddr = this.romAddrForExceptionsAndExports;
        this.staticInitSize += exportedRefManager.addToMask(initializedArrays);
        this.defineList.append("#define GLOBAL_REFERENCE_TABLE_ADDRESS " + Msg.toAddressString(CrefOutputFormatter.exportedRefManager.tableLocation) + Msg.eol);
        this.staticInitSize += objectManager.addToMask(initializedArrays);
        this.defineList.append("#define OBJECT_TABLE_ADDRESS " + Msg.toAddressString(CrefOutputFormatter.objectManager.tableLocation) + Msg.eol);
        this.staticInitSize += ptm.createAndAddPackageLocTable(initializedArrays);
        this.defineList.append("#define PACKAGE_LOCATION_TABLE_ADDRESS " + Msg.toAddressString(CrefOutputFormatter.ptm.packageLocTableAddress) + Msg.eol);
        this.defineList.append(Msg.eol);
        this.defineList.append("#define EXPORT_COMPONENT_BASE " + Msg.toAddressString(exceptionAndExportBase) + Msg.eol);
        this.romLength = this.currentRomAddr - this.m_romBase;
        this.defineList.append("#define INITIAL_EXCEPTION_TABLE_LIST " + Msg.toAddressString(this.nextExceptionTable) + Msg.eol);
        this.rom.append(this.rom_AidAndPkgTblEntries);
        this.rom.append(Msg.eol + "/* Exception and Export information */" + Msg.eol);
        this.rom.append(this.exceptionsAndExports);
        this.rom.append(this.rom_GrtObjectPkgFilledTable);
        if (this.m_romBase + this.romLength >= this.m_e2Base) {
            Msg.error("cref.2", null);
            Main.printStatus();
        }
        this.defineList.append("#define ROMSIZE " + this.romLength + Msg.eol);
        this.defineList.append("#define EEPROM_IMAGE_SIZE " + (this.currentEEPROMAddr - this.m_e2Base) + Msg.eol);
        this.defineList.append("#define NPACKAGES " + this.npackages + Msg.eol);
        this.staticInit.append(initializedArrays);
        if (this.m_apiPkgCount != -1) {
            this.defineList.append("#define API_PACKAGES_COUNT " + this.m_apiPkgCount + Msg.eol);
        }
    }

    protected boolean outputClassInfo(JCClass c, StringBuffer classCompBuff, PackageTableEntry pe) {
        JCMethod m;
        int flags;
        String mapTo = null;
        int componentBase = pe.componentInfoReference[0].compLocation;
        int addr = c.getRelocAddr();
        classCompBuff.append(Msg.eol + "/* class@" + Msg.toAddressString(addr + componentBase) + ":" + Msg.toHexString((short)addr) + ": " + Modifier.toString(c.getAttributes()) + " " + c.getName() + " */" + Msg.eol);
        mapTo = this.getMapEntry(c.getName());
        if (mapTo != null) {
            this.defineList.append("#define " + mapTo + " " + Msg.toHexString((short)addr) + "\t/* " + c.getName() + " */" + Msg.eol);
        }
        int n = flags = c.isShareable() ? 64 : 0;
        if (Modifier.isInterface(c.getAttributes())) {
            int superCount;
            flags |= 0x80;
            if (c.isRemote()) {
                flags |= 0x20;
            }
            if ((superCount = c.superInterfaceVector.size()) > 15) {
                Object[] args = new Object[]{c.getName()};
                Msg.error("cref.3", args);
                Main.printStatus();
            }
            classCompBuff.append(Msg.toHexString((byte)(flags | superCount & 0xF)) + ", ");
            for (SuperInterface si : c.superInterfaceVector) {
                addr = si.resolve().getRelocAddr();
                if (!si.resolve().getParentPackage().equals(this.currentPackage)) {
                    addr = exportedRefManager.getExportedReference(si.resolve());
                }
                classCompBuff.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
                classCompBuff.append("LOW(" + Msg.toHexString((short)addr) + "), ");
                classCompBuff.append(Msg.eol);
            }
            if (c.isRemote()) {
                this.addRemoteClassInfo(c, classCompBuff);
            }
            return false;
        }
        flags |= c.interfaceVector.size() & 0xF;
        if (c.isRemote()) {
            flags |= 0x20;
        }
        classCompBuff.append(Msg.toHexString((byte)flags) + ", ");
        JCClass superClass = c.getSuperClass();
        addr = superClass == null ? 65535 : (!superClass.getParentPackage().equals(this.currentPackage) ? exportedRefManager.getExportedReference(superClass) : superClass.getRelocAddr());
        classCompBuff.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
        classCompBuff.append("LOW(" + Msg.toHexString((short)addr) + "), ");
        int instanceSize = 0;
        for (JCClass currentClass = c; currentClass != null; currentClass = currentClass.getSuperClass()) {
            instanceSize += currentClass.getInstanceSize();
        }
        classCompBuff.append(Msg.toHexString((byte)instanceSize) + ", ");
        int firstReferenceToken = c.getFirstReferenceToken();
        if (firstReferenceToken != 255) {
            firstReferenceToken += c.getInstanceBase();
        }
        classCompBuff.append(Msg.toHexString((byte)firstReferenceToken) + ", ");
        classCompBuff.append(Msg.toHexString((byte)c.getReferenceCount()) + ", ");
        classCompBuff.append(Msg.toHexString((byte)c.publicMethodTable.getBase()) + ", ");
        classCompBuff.append(Msg.toHexString((byte)c.publicMethodTable.getCount()) + ", ");
        int fixedUpPkgMethodBase = c.packageMethodTable.getFixedPkgMethodTableBase();
        classCompBuff.append(Msg.toHexString((byte)fixedUpPkgMethodBase) + ", ");
        classCompBuff.append(Msg.toHexString((byte)c.packageMethodTable.getCount()) + ", ");
        classCompBuff.append(Msg.eol);
        Enumeration<JCMethod> g = c.publicMethodTable.elements();
        while (g.hasMoreElements()) {
            m = g.nextElement();
            addr = m.getParentClass().getParentPackage().equals(this.currentPackage) ? (m.isGRTCandidate() ? exportedRefManager.getExportedReference(m) : m.getRelocAddr()) : exportedRefManager.getExportedReference(m);
            classCompBuff.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
            classCompBuff.append("LOW(" + Msg.toHexString((short)addr) + "),\t\t/* " + m.getName() + " */" + Msg.eol);
        }
        g = c.packageMethodTable.elements();
        while (g.hasMoreElements()) {
            m = g.nextElement();
            addr = m.getRelocAddr();
            if (addr > Short.MAX_VALUE) {
                addr = exportedRefManager.getExportedReference(m);
            }
            classCompBuff.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
            classCompBuff.append("LOW(" + Msg.toHexString((short)addr) + "),\t\t/* " + m.getName() + " */" + Msg.eol);
        }
        if (c.interfaceVector.size() > 0) {
            classCompBuff.append(Msg.eol + "/* Implemented interface info */" + Msg.eol);
        }
        for (InterfaceTable itbl : c.interfaceVector) {
            byte[] table = itbl.toByteArray();
            JCClass resolved = itbl.resolve();
            addr = resolved.getParentPackage().equals(this.currentPackage) ? resolved.getRelocAddr() : exportedRefManager.getExportedReference(resolved);
            classCompBuff.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
            classCompBuff.append("LOW(" + Msg.toHexString((short)addr) + "), ");
            for (int i = 2; i < table.length; ++i) {
                classCompBuff.append(table[i] + ", ");
            }
            classCompBuff.append(Msg.eol);
        }
        if (c.isRemote()) {
            this.addRemoteClassInfo(c, classCompBuff);
        }
        return true;
    }

    void outputFieldMappingInfo(JCClass c) {
        Enumeration<Field> g = c.fieldElements();
        while (g.hasMoreElements()) {
            String mapTo;
            Field field = g.nextElement();
            int mod = field.getAttributes();
            if (Modifier.isStatic(mod) && !Modifier.isFinal(mod)) {
                int staticFieldCompBaseAddr = PackageTableManager.getCompBaseAddress(this.currentPackage, 2);
                mapTo = this.getMapEntry(field.getName());
                if (mapTo != null) {
                    int addr = field.getRelocAddr();
                    this.defineList.append("#define " + mapTo + " " + Msg.toAddressString(addr += staticFieldCompBaseAddr) + "\t/* " + field.getName() + " */" + Msg.eol);
                }
            }
            if (Modifier.isStatic(mod) || (mapTo = this.getMapEntry(field.getName())) == null) continue;
            this.defineList.append("#define " + mapTo + " " + field.getFieldIdentifier().getFieldToken() + "\t/* " + field.getName() + " */" + Msg.eol);
        }
    }

    protected void addRemoteClassInfo(JCClass c, StringBuffer classCompBuff) {
        JCPackage p = c.getParentPackage();
        if (Modifier.isInterface(c.getAttributes())) {
            String interfaceName = c.getName();
            interfaceName = interfaceName.substring(interfaceName.lastIndexOf("/") + 1);
            classCompBuff.append(Msg.eol + "/* Remote interface name length name for " + interfaceName + " */" + Msg.eol);
            classCompBuff.append(Msg.toHexString((byte)interfaceName.length()) + ", ");
            byte[] nameBytes = interfaceName.getBytes();
            classCompBuff.append(Msg.toHexString(nameBytes, ", ") + ", " + Msg.eol);
        } else {
            classCompBuff.append(Msg.eol + "/* Remote Method Information Table Count */" + Msg.eol);
            classCompBuff.append(Msg.toHexString((byte)c.remoteMethods.size()) + ", " + Msg.eol);
            if (c.remoteMethods.size() > 0) {
                classCompBuff.append(Msg.eol + "/* Remote Method Information Table */" + Msg.eol);
                for (RemoteMethodInfo rmi : c.remoteMethods) {
                    int remoteMethodSignatureOffset = p.getSignaturePool().getAddressForOffset(rmi.methodSigOffset);
                    classCompBuff.append("HIGH(" + Msg.toHexString(rmi.remoteMethodHash) + "), ");
                    classCompBuff.append("LOW(" + Msg.toHexString(rmi.remoteMethodHash) + "), ");
                    classCompBuff.append("HIGH(" + Msg.toHexString((short)remoteMethodSignatureOffset) + "), ");
                    classCompBuff.append("LOW(" + Msg.toHexString((short)remoteMethodSignatureOffset) + "), ");
                    classCompBuff.append(Msg.toHexString(rmi.flagAndToken) + ", ");
                    classCompBuff.append("\t\t/* " + rmi.methodNameAndDesc + " */" + Msg.eol);
                }
            }
            classCompBuff.append(Msg.eol + "/* Anti Hash Collision String Length and String itself */" + Msg.eol);
            if (c.getAntiHashCollisionString() == null) {
                classCompBuff.append(Msg.toHexString((byte)0) + ", ");
            } else {
                String hashCollisionString = c.getAntiHashCollisionString();
                classCompBuff.append(Msg.toHexString((byte)hashCollisionString.length()) + ", ");
                classCompBuff.append(Msg.toHexString(hashCollisionString.getBytes(), ", ") + ", " + Msg.eol);
            }
            String className = c.getName();
            className = className.substring(className.lastIndexOf("/") + 1);
            classCompBuff.append(Msg.eol + "/* Class Name Length and Class Name */" + Msg.eol);
            classCompBuff.append(Msg.toHexString((byte)className.length()) + ", ");
            byte[] nameBytes = className.getBytes();
            classCompBuff.append(Msg.toHexString(nameBytes, ", ") + ", " + Msg.eol);
            classCompBuff.append(Msg.eol + "/* Remote interface count and information */" + Msg.eol);
            classCompBuff.append(Msg.toHexString((byte)c.remoteInterfaceVector.size()) + ", ");
            classCompBuff.append(Msg.eol);
            for (InterfaceTable itbl : c.remoteInterfaceVector) {
                int addr = 0;
                JCClass resolved = itbl.resolve();
                addr = resolved.getParentPackage().equals(this.currentPackage) ? resolved.getRelocAddr() : exportedRefManager.getExportedReference(resolved);
                classCompBuff.append("HIGH(" + Msg.toHexString((short)addr) + "), ");
                classCompBuff.append("LOW(" + Msg.toHexString((short)addr) + "), ");
                classCompBuff.append("\t\t/*" + itbl.resolve().getName() + "*/");
            }
        }
    }

    protected StringBuffer getExceptionTableHeader() {
        int totalSize = exceptionTableHeaderSize;
        StringBuffer tempExceptionTable = new StringBuffer();
        tempExceptionTable.append("/* Exception table information for " + this.currentPackage.getName() + "@" + Msg.toAddressString(this.romAddrForExceptionsAndExports) + " */" + Msg.eol);
        if (Main.FLAG_32_BIT) {
            tempExceptionTable.append(Msg.toHexString((byte)(this.nextExceptionTable >> 24)) + ", ");
            tempExceptionTable.append(Msg.toHexString((byte)(this.nextExceptionTable >> 16)) + ", ");
            tempExceptionTable.append(Msg.toHexString((byte)(this.nextExceptionTable >> 8)) + ", ");
            tempExceptionTable.append(Msg.toHexString((byte)this.nextExceptionTable) + ", ");
        } else {
            tempExceptionTable.append("HIGH(" + Msg.toHexString((short)this.nextExceptionTable) + "), ");
            tempExceptionTable.append("LOW(" + Msg.toHexString((short)this.nextExceptionTable) + "), ");
        }
        this.nextExceptionTable = this.romAddrForExceptionsAndExports;
        this.romAddrForExceptionsAndExports += exceptionTableHeaderSize;
        if (Main.FLAG_32_BIT) {
            tempExceptionTable.append(Msg.toHexString((byte)(this.romAddrForExceptionsAndExports >> 24)) + ", ");
            tempExceptionTable.append(Msg.toHexString((byte)(this.romAddrForExceptionsAndExports >> 16)) + ", ");
            tempExceptionTable.append(Msg.toHexString((byte)(this.romAddrForExceptionsAndExports >> 8)) + ", ");
            tempExceptionTable.append(Msg.toHexString((byte)this.romAddrForExceptionsAndExports) + ", ");
        } else {
            tempExceptionTable.append("HIGH(" + Msg.toHexString((short)this.romAddrForExceptionsAndExports) + "), ");
            tempExceptionTable.append("LOW(" + Msg.toHexString((short)this.romAddrForExceptionsAndExports) + "), ");
        }
        tempExceptionTable.append(Msg.toHexString((byte)this.packageDirectory.indexOf(this.currentPackage.getIdentifier())) + ", " + Msg.eol);
        tempExceptionTable.append(this.nExceptionEntries + ", ");
        tempExceptionTable.append(Msg.eol);
        this.romAddrForExceptionsAndExports += this.nExceptionEntries * 8 + 1;
        this.romLength += (totalSize += this.nExceptionEntries * 8 + 1);
        return tempExceptionTable;
    }

    protected void outputMethods(JCClass c, StringBuffer methodCompBuff, StringBuffer exceptionTable, PackageTableEntry pe) {
        int componentBase = pe.componentInfoReference[1].compLocation;
        Enumeration<JCMethod> g = c.methodElements();
        while (g.hasMoreElements()) {
            JCMethod m = g.nextElement();
            int addr = 0;
            addr = Modifier.isNative(m.getAttributes()) ? m.getNativeToken() : m.getRelocAddr();
            String mapTo = this.getMapEntry(m.getName());
            if (mapTo != null) {
                this.defineList.append("#define " + mapTo + " " + Msg.toHexString((short)addr) + "\t/* " + m.getName() + " */" + Msg.eol);
                if (mapTo.equals("MAIN_METHOD_OFFSET")) {
                    this.defineList.append("#define MAIN_METHOD_PKGID " + Msg.toHexString((short)this.packageDirectory.indexOf(this.currentPackage.getIdentifier())) + "\t/* " + this.currentPackage.getName() + " */" + Msg.eol);
                }
            }
            int methodAddress = m.getRelocAddr();
            methodCompBuff.append(Msg.eol + "/* method@" + Msg.toAddressString(methodAddress + componentBase) + ":" + Msg.toHexString((short)methodAddress) + ": " + Modifier.toString(m.getAttributes()) + " " + m.getName() + " */" + Msg.eol);
            byte[] methodHeader = m.getMethodHeader();
            methodCompBuff.append(Msg.toHexString(methodHeader, ", ") + ", " + Msg.eol);
            if (Modifier.isAbstract(m.getAttributes())) continue;
            if (Modifier.isNative(m.getAttributes())) {
                short tag = m.getNativeToken();
                methodCompBuff.append(Msg.toHexString((byte)tag) + ", " + Msg.eol);
                continue;
            }
            Enumeration<Statement> h = m.statementElements();
            while (h.hasMoreElements()) {
                Statement s = h.nextElement();
                this.format(s, m, methodCompBuff, componentBase);
                methodCompBuff.append(", " + Msg.eol);
            }
            ExceptionTable exTbl = m.getExceptionTable();
            if (exTbl == null) continue;
            Enumeration<ExceptionTableEntry> h2 = exTbl.elements();
            while (h2.hasMoreElements()) {
                ExceptionTableEntry entry = h2.nextElement();
                short start = (short)entry.getStartOffset();
                short activeLength = (short)entry.getActiveLength();
                if (entry.isOuterMost()) {
                    activeLength = (short)(activeLength | 0x8000);
                }
                short handlerOffset = (short)entry.getHandlerOffset();
                short catchIndex = (short)entry.getCatchIndex();
                exceptionTable.append(this.formatBigEndian(start) + ", " + this.formatBigEndian(activeLength) + ", " + this.formatBigEndian(handlerOffset) + ", " + this.formatBigEndian(catchIndex) + ", " + Msg.eol);
                ++this.nExceptionEntries;
            }
        }
    }

    protected void outputStaticFields(RomMask r, PackageTableEntry pe) {
        int compBase = pe.componentInfoReference[2].compLocation;
        int relativeAddr = 0;
        int absoluteAddr = 0;
        StaticFieldComponent sfc = this.packageFields.get(this.currentPackage);
        for (int j = 1; j <= 4; ++j) {
            for (Field field : sfc.getSegment(j)) {
                int mod = field.getAttributes();
                if (!Modifier.isStatic(mod)) continue;
                FieldDescriptor descriptor = field.getDescriptor();
                if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                relativeAddr = field.getRelocAddr();
                absoluteAddr = relativeAddr + compBase;
                StaticFieldInitializer init = field.getFieldInitializer();
                if (init != null && init.isPrimitive()) {
                    int data = init.getPrimitiveData();
                    switch (field.size()) {
                        case 1: {
                            this.staticInit.append(Msg.toHexString((byte)data) + ",");
                            ++this.staticInitSize;
                            break;
                        }
                        case 2: {
                            this.staticInit.append(Msg.to16BitHexString(data));
                            this.staticInitSize += 2;
                            break;
                        }
                        case 4: {
                            this.staticInit.append(Msg.to32BitHexString(data));
                            this.staticInitSize += 4;
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(absoluteAddr) + ":" + Msg.toHexString((short)relativeAddr) + " */" + Msg.eol);
                    continue;
                }
                if (init != null && !init.isPrimitive()) {
                    int i;
                    int addr;
                    byte[] obj;
                    int objectRef = objectManager.addObject(this.currentEEPROMAddr);
                    this.staticInit.append(Msg.to16BitHexString(objectRef));
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(absoluteAddr) + ":" + Msg.toHexString((short)relativeAddr) + " */" + Msg.eol);
                    this.staticInitSize += 2;
                    String descStr = descriptor.getDescriptorString();
                    int[] data = init.getArrayData();
                    if (descStr.equals(BYTE_CLASS_NAME)) {
                        obj = new byte[data.length + 7];
                        obj[0] = -128;
                        addr = ((JCClass)r.classSymbolTable.get(BYTE_CLASS_NAME)).getRelocAddr();
                        for (i = 0; i < data.length; ++i) {
                            obj[7 + i] = (byte)data[i];
                        }
                        this.currentEEPROMAddr += 7 + data.length;
                    } else if (descStr.equals("[Z")) {
                        obj = new byte[data.length + 7];
                        obj[0] = 96;
                        addr = ((JCClass)r.classSymbolTable.get("[Z")).getRelocAddr();
                        for (i = 0; i < data.length; ++i) {
                            obj[7 + i] = (byte)data[i];
                        }
                        this.currentEEPROMAddr += 7 + data.length;
                    } else if (descStr.equals("[S")) {
                        obj = new byte[data.length * 2 + 7];
                        obj[0] = -96;
                        addr = ((JCClass)r.classSymbolTable.get("[S")).getRelocAddr();
                        for (i = 0; i < data.length; ++i) {
                            obj[7 + i * 2] = (byte)(data[i] >> 8);
                            obj[7 + i * 2 + 1] = (byte)data[i];
                        }
                        this.currentEEPROMAddr += 7 + data.length * 2;
                    } else if (descStr.equals("[I")) {
                        obj = new byte[data.length * 4 + 7];
                        obj[0] = -64;
                        addr = ((JCClass)r.classSymbolTable.get("[I")).getRelocAddr();
                        for (i = 0; i < data.length; ++i) {
                            obj[7 + i * 4] = (byte)(data[i] >> 24);
                            obj[7 + i * 4 + 1] = (byte)(data[i] >> 16);
                            obj[7 + i * 4 + 2] = (byte)(data[i] >> 8);
                            obj[7 + i * 4 + 3] = (byte)data[i];
                        }
                        this.currentEEPROMAddr += 7 + data.length * 4;
                    } else {
                        throw new InternalError();
                    }
                    byte pkgCntxt = ptm.getPkgContextForIndex(this.packageDirectory.indexOf(this.currentPackage.getIdentifier()));
                    obj[1] = (byte)(pkgCntxt << 4);
                    obj[2] = (byte)(addr >> 8);
                    obj[3] = (byte)addr;
                    obj[4] = (byte)PackageTableManager.VMArrayImplementationPkg;
                    obj[5] = (byte)(data.length >> 8);
                    obj[6] = (byte)data.length;
                    initializedArrays.append(Msg.toHexString(obj, ", ") + "," + Msg.eol);
                    this.staticInitSize += obj.length;
                    continue;
                }
                if (field.getName().equals(this.packageTableField)) {
                    this.staticInit.append(Msg.to16BitHexString(PackageTableManager.packageTableReference));
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(absoluteAddr) + ":" + Msg.toHexString((short)relativeAddr) + " */" + Msg.eol);
                    continue;
                }
                if (field.getName().equals(this.packageContextTableField)) {
                    this.staticInit.append(Msg.to16BitHexString(PackageTableManager.packageContextTableReference));
                    this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(absoluteAddr) + ":" + Msg.toHexString((short)relativeAddr) + " */" + Msg.eol);
                    continue;
                }
                switch (field.size()) {
                    case 1: {
                        this.staticInit.append("0,");
                        ++this.staticInitSize;
                        break;
                    }
                    case 2: {
                        this.staticInit.append("0, 0,");
                        this.staticInitSize += 2;
                        break;
                    }
                    case 4: {
                        this.staticInit.append("0, 0, 0, 0,");
                        this.staticInitSize += 4;
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                this.staticInit.append("\t/* " + field.getName() + " @ " + Msg.toAddressString(absoluteAddr) + ":" + Msg.toHexString((short)relativeAddr) + " */" + Msg.eol);
            }
        }
    }

    protected void format(Statement s, JCMethod m, StringBuffer methodCompBuff, int methodCompBase) {
        if (s.getInstruction() == null) {
            return;
        }
        int relativeAddr = m.getRelocAddr() + m.getHeaderSize() + s.getRelPc();
        int absoluteAddr = relativeAddr + methodCompBase;
        methodCompBuff.append("/* " + Msg.toAddressString(absoluteAddr) + ":" + Msg.toHexString((short)relativeAddr) + ": */ ");
        this.format(s.getInstruction(), methodCompBuff);
    }

    protected void format(Instruction i, StringBuffer methodCompBuff) {
        methodCompBuff.append("_" + i.getMnemonic().toUpperCase());
        Enumeration<Operand> e = i.operandElements();
        while (e.hasMoreElements()) {
            Operand o = e.nextElement();
            this.format(o, methodCompBuff);
        }
    }

    protected void format(Operand o, StringBuffer methodCompBuff) {
        if (o.getType() == 8) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int addr;
                    if (info.resolve() instanceof JCMethod) {
                        JCPackage parentPackage = ((JCMethod)info.resolve()).getParentClass().getParentPackage();
                        if (parentPackage.equals(this.currentPackage)) {
                            addr = ((JCMethod)info.resolve()).getRelocAddr();
                            if (addr > Short.MAX_VALUE) {
                                addr = exportedRefManager.getExportedReference(info.resolve());
                            }
                        } else {
                            addr = exportedRefManager.getExportedReference(info.resolve());
                        }
                    } else {
                        JCPackage parentPackage = ((JCClass)info.resolve()).getParentPackage();
                        addr = parentPackage.equals(this.currentPackage) ? info.resolve().getRelocAddr() : exportedRefManager.getExportedReference(info.resolve());
                    }
                    methodCompBuff.append(", HIGH(" + Msg.toHexString((short)addr) + "), LOW(" + Msg.toHexString((short)addr) + ")");
                    break;
                }
                case 5: {
                    JCPackage parentPackage = ((Field)info.resolve()).getParentClass().getParentPackage();
                    int addr = parentPackage.equals(this.currentPackage) ? info.resolve().getRelocAddr() : exportedRefManager.getExportedReference(info.resolve());
                    methodCompBuff.append(", HIGH(" + Msg.toHexString((short)addr) + "), LOW(" + Msg.toHexString((short)addr) + ")");
                    break;
                }
                case 3: {
                    JCMethod m = (JCMethod)info.resolve();
                    MethodIdentifier mid = m.getMethodIdentifier();
                    int token = mid.getMethodToken();
                    JCClass parentClass = m.getParentClass();
                    if (parentClass.packageMethodTable.isPkgMethod(m)) {
                        int tokenDiff = parentClass.packageMethodTable.getFixedPkgMethodTableBase() - parentClass.packageMethodTable.getBase();
                        token += tokenDiff;
                    }
                    int params = m.getParams();
                    methodCompBuff.append(", " + Msg.toHexString((byte)params) + ", " + Msg.toHexString((byte)token));
                    break;
                }
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    methodCompBuff.append(", " + Msg.toHexString((byte)offset >> 8) + ", " + Msg.toHexString((byte)offset));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.getType() == 7) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    methodCompBuff.append(", " + Msg.toHexString((byte)offset));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.size() == 1) {
            if (o.getValue() >= 0) {
                methodCompBuff.append(", " + o.getValue());
            } else {
                methodCompBuff.append(", LOW(" + o.getValue() + ")");
            }
        } else if (o.size() == 2) {
            methodCompBuff.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        } else if (o.size() == 4) {
            methodCompBuff.append(", " + (o.getValue() >> 24 & 0xFF) + ", " + (o.getValue() >> 16 & 0xFF));
            methodCompBuff.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        }
    }

    public String formatBigEndian(short value) {
        return "HIGH(" + Msg.toHexString(value) + "), " + "LOW(" + Msg.toHexString(value) + ")";
    }

    @Override
    public void write(OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/jcasm/MessagesBundle");
        Object[] arguments = new Object[]{new Integer(0), new Integer(55)};
        pw.println("/*");
        pw.println(" * " + MessageFormat.format(messages.getString("crefbanner.1"), null));
        pw.println(" *");
        pw.println(" * " + MessageFormat.format(messages.getString("crefbanner.2"), null));
        pw.println(" * " + MessageFormat.format(messages.getString("maskMain.0"), arguments));
        String copyRight1Message = messages.getString("main.2");
        int Strindex = copyRight1Message.indexOf("\n");
        String cr1 = copyRight1Message.substring(0, Strindex);
        String cr2 = copyRight1Message.substring(Strindex + 1);
        String cr3 = messages.getString("main.3");
        cr2 = cr3 + cr2;
        pw.println(" * " + MessageFormat.format(cr1, null));
        pw.println(" * " + MessageFormat.format(cr2, null));
        pw.println(" */");
        pw.println(" ");
        pw.println("#ifdef __MASK_HEADER__" + Msg.eol);
        pw.println(this.defineList.toString());
        pw.println("#else" + Msg.eol);
        pw.println(this.preamble.toString());
        pw.println("ROM_ARRAY(u8, rommask) = {");
        pw.println(this.rom.toString());
        pw.println("};");
        pw.println("ROM_ARRAY(u8, staticinit) = {");
        if (this.staticInit.length() == 0) {
            pw.println(" NULL ");
        } else {
            pw.print(this.staticInit.toString());
        }
        pw.println("};");
        pw.println("#endif /* __MASK_HEADER__ */" + Msg.eol);
        pw.flush();
    }

    static {
        exceptionTableHeaderSize = 5;
    }
}

