/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class StaticFieldComponent
extends Component {
    protected Vector<NonDefaultValue> primitiveInitVector;
    protected Vector<NonDefaultValue> arrayInitVector = new Vector();
    protected int reference_count;
    protected int non_default_value_count;
    protected int default_value_count;
    protected Vector<Field> segment1;
    protected Vector<Field> segment2;
    protected Vector<Field> segment3;
    protected Vector<Field> segment4;
    boolean isLibrary;

    public StaticFieldComponent(JCPackage p) {
        super(p);
        this.primitiveInitVector = new Vector();
        this.segment1 = new Vector();
        this.segment2 = new Vector();
        this.segment3 = new Vector();
        this.segment4 = new Vector();
        this.isLibrary = p.appletCount() <= 0;
    }

    int getImageSize() {
        return this.default_value_count + this.non_default_value_count + this.reference_count * 2;
    }

    int getArrayInitCount() {
        return this.arrayInitVector.size();
    }

    int getArrayInitSize() {
        int size = 0;
        for (NonDefaultValue init : this.arrayInitVector) {
            int dataSize = init.size() - 3;
            size += dataSize;
        }
        return size;
    }

    @Override
    public int dataSize() {
        int size = 10;
        for (NonDefaultValue init : this.arrayInitVector) {
            size += init.size();
        }
        return size += this.non_default_value_count;
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] array;
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeShort(this.getImageSize());
            dos.writeShort(this.reference_count);
            dos.writeShort(this.arrayInitVector.size());
            for (NonDefaultValue init : this.arrayInitVector) {
                array = init.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.writeShort(this.default_value_count);
            dos.writeShort(this.non_default_value_count);
            for (NonDefaultValue init : this.primitiveInitVector) {
                array = init.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        assert (this.size() == bos.size()) : "size() != bos.size()";
        return bos.toByteArray();
    }

    protected void getDebugOffsets(Map<String, Integer> offsets) {
        Vector[] segments = new Vector[]{this.segment1, this.segment2, this.segment3, this.segment4};
        int offset = 0;
        for (int s = 0; s < 4; ++s) {
            Enumeration e = segments[s].elements();
            while (e.hasMoreElements()) {
                Field f = (Field)e.nextElement();
                offsets.put(f.getName(), new Integer(offset));
                offset += f.size();
            }
        }
    }

    public void add(JCClass c) {
        Enumeration<Field> f = c.fieldElements();
        while (f.hasMoreElements()) {
            Field field = f.nextElement();
            if (!Modifier.isStatic(field.getAttributes()) || Modifier.isFinal(field.getAttributes()) && field.getDescriptor().isPrimitive()) continue;
            FieldDescriptor descriptor = field.getDescriptor();
            StaticFieldInitializer init = field.getFieldInitializer();
            if (descriptor.isPrimitive()) {
                if (init != null) {
                    this.non_default_value_count += field.size();
                    this.primitiveInitVector.addElement(new NonDefaultValue(field.size(), init.getPrimitiveData()));
                    this.segment4.addElement(field);
                    continue;
                }
                this.default_value_count += field.size();
                this.segment3.addElement(field);
                continue;
            }
            ++this.reference_count;
            if (init == null) {
                this.segment2.addElement(field);
                continue;
            }
            if (init.isArrayDataNull()) {
                this.segment2.addElement(field);
                continue;
            }
            if (this.isLibrary) {
                Object[] args = new Object[]{c.getName()};
                Msg.error("static.1", args);
            }
            if (!descriptor.isArray() && init.getType() != null) {
                this.arrayInitVector.addElement(new NonDefaultValue(init.getType().getDescriptorString(), init.getArrayData()));
            } else {
                this.arrayInitVector.addElement(new NonDefaultValue(descriptor.getDescriptorString(), init.getArrayData()));
            }
            this.segment1.addElement(field);
        }
    }

    void assignAddresses() {
        int address = 0;
        for (Field field : this.segment1) {
            field.relocate(address);
            address += field.size();
        }
        for (Field field : this.segment2) {
            field.relocate(address);
            address += field.size();
        }
        for (Field field : this.segment3) {
            field.relocate(address);
            address += field.size();
        }
        for (Field field : this.segment4) {
            field.relocate(address);
            address += field.size();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Image Size: " + this.getImageSize() + Msg.eol);
        sb.append("First Reference Count: " + this.reference_count + Msg.eol);
        sb.append("Array Init Count: " + this.arrayInitVector.size() + Msg.eol);
        for (NonDefaultValue init : this.arrayInitVector) {
            sb.append("Array Init: " + Msg.toHexString(init.toByteArray()) + Msg.eol);
        }
        sb.append("Default Value Count: " + this.default_value_count + Msg.eol);
        sb.append("Non-Default Value Count: " + this.non_default_value_count + Msg.eol);
        for (NonDefaultValue init : this.primitiveInitVector) {
            sb.append("Primitive Init: " + Msg.toHexString(init.toByteArray()) + Msg.eol);
        }
        return sb.toString();
    }

    public short getReferenceFieldCount() {
        return (short)this.reference_count;
    }

    public Vector<Field> getSegment(int segmentNumber) {
        switch (segmentNumber) {
            case 1: {
                return this.segment1;
            }
            case 2: {
                return this.segment2;
            }
            case 3: {
                return this.segment3;
            }
            case 4: {
                return this.segment4;
            }
        }
        return null;
    }

    static class NonDefaultValue {
        protected int width;
        protected int value;
        protected String descriptor;
        protected int[] arrayValue;
        private boolean isPrimitive;

        NonDefaultValue(int width, int value) {
            this.width = width;
            this.value = value;
            this.isPrimitive = true;
        }

        NonDefaultValue(String descriptor, int[] value) {
            this.descriptor = descriptor;
            this.arrayValue = value;
            if (descriptor.equals("[B")) {
                this.width = 1;
            } else if (descriptor.equals("[Z")) {
                this.width = 1;
            } else if (descriptor.equals("[S")) {
                this.width = 2;
            } else if (descriptor.equals("[I")) {
                this.width = 4;
            }
        }

        int size() {
            if (this.isPrimitive) {
                return this.width;
            }
            return 3 + this.width * this.arrayValue.length;
        }

        byte[] toByteArray() {
            byte[] array = new byte[this.size()];
            if (this.isPrimitive) {
                this.setArrayElement(array, 0, this.width, this.value);
            } else {
                if (this.descriptor.equals("[B")) {
                    array[0] = 3;
                } else if (this.descriptor.equals("[Z")) {
                    array[0] = 2;
                } else if (this.descriptor.equals("[S")) {
                    array[0] = 4;
                } else if (this.descriptor.equals("[I")) {
                    array[0] = 5;
                }
                this.setArrayElement(array, 1, 2, this.arrayValue.length * this.width);
                int offset = 3;
                for (int element : this.arrayValue) {
                    this.setArrayElement(array, offset, this.width, element);
                    offset += this.width;
                }
            }
            return array;
        }

        private void setArrayElement(byte[] array, int offset, int width, int data) {
            switch (width) {
                case 1: {
                    array[offset] = (byte)data;
                    break;
                }
                case 2: {
                    array[offset] = (byte)(data >> 8 & 0xFF);
                    array[offset + 1] = (byte)(data & 0xFF);
                    break;
                }
                case 4: {
                    array[offset] = (byte)(data >> 24 & 0xFF);
                    array[offset + 1] = (byte)(data >> 16 & 0xFF);
                    array[offset + 2] = (byte)(data >> 8 & 0xFF);
                    array[offset + 3] = (byte)(data & 0xFF);
                }
            }
        }

        public String toString() {
            return Msg.toHexString(this.toByteArray());
        }
    }
}

