/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class WideInstrOptimizer {
    JcPackage jc_package;

    public WideInstrOptimizer(JcPackage jc_package) {
        this.jc_package = jc_package;
    }

    public JcPackage optimize() {
        JcClass[] jc_classes;
        JcConstantPool jc_cp = this.jc_package.getConstantPool();
        jc_cp.order();
        for (JcClass element : jc_classes = this.jc_package.getClasses()) {
            JcMethod[] jc_methods;
            for (JcMethod jc_method : jc_methods = element.getMethods()) {
                this.passOne(jc_method);
                this.passTwo(jc_method);
            }
        }
        return this.jc_package;
    }

    private void passOne(JcMethod jc_method) {
        block27: for (JcInstruction jc_instr = jc_method.getCode(); jc_instr != null; jc_instr = jc_instr.getNextInstr()) {
            int jc_opcode = jc_instr.getOpcode();
            switch (jc_opcode) {
                case 169: {
                    this.optimizeFieldInstr(jc_instr, 131);
                    continue block27;
                }
                case 170: {
                    this.optimizeFieldInstr(jc_instr, 132);
                    continue block27;
                }
                case 171: {
                    this.optimizeFieldInstr(jc_instr, 133);
                    continue block27;
                }
                case 172: {
                    this.optimizeFieldInstr(jc_instr, 134);
                    continue block27;
                }
                case 177: {
                    this.optimizeFieldInstr(jc_instr, 135);
                    continue block27;
                }
                case 178: {
                    this.optimizeFieldInstr(jc_instr, 136);
                    continue block27;
                }
                case 179: {
                    this.optimizeFieldInstr(jc_instr, 137);
                    continue block27;
                }
                case 180: {
                    this.optimizeFieldInstr(jc_instr, 138);
                    continue block27;
                }
                case 152: {
                    this.setBranchInstr(jc_instr, 96);
                    continue block27;
                }
                case 153: {
                    this.setBranchInstr(jc_instr, 97);
                    continue block27;
                }
                case 154: {
                    this.setBranchInstr(jc_instr, 98);
                    continue block27;
                }
                case 155: {
                    this.setBranchInstr(jc_instr, 99);
                    continue block27;
                }
                case 156: {
                    this.setBranchInstr(jc_instr, 100);
                    continue block27;
                }
                case 157: {
                    this.setBranchInstr(jc_instr, 101);
                    continue block27;
                }
                case 158: {
                    this.setBranchInstr(jc_instr, 102);
                    continue block27;
                }
                case 159: {
                    this.setBranchInstr(jc_instr, 103);
                    continue block27;
                }
                case 160: {
                    this.setBranchInstr(jc_instr, 104);
                    continue block27;
                }
                case 161: {
                    this.setBranchInstr(jc_instr, 105);
                    continue block27;
                }
                case 162: {
                    this.setBranchInstr(jc_instr, 106);
                    continue block27;
                }
                case 163: {
                    this.setBranchInstr(jc_instr, 107);
                    continue block27;
                }
                case 164: {
                    this.setBranchInstr(jc_instr, 108);
                    continue block27;
                }
                case 165: {
                    this.setBranchInstr(jc_instr, 109);
                    continue block27;
                }
                case 166: {
                    this.setBranchInstr(jc_instr, 110);
                    continue block27;
                }
                case 167: {
                    this.setBranchInstr(jc_instr, 111);
                    continue block27;
                }
                case 168: {
                    this.setBranchInstr(jc_instr, 112);
                }
            }
        }
    }

    private void optimizeFieldInstr(JcInstruction jc_instr, int narrow_opcode) {
        JcInstrFieldRef instr_field_ref = (JcInstrFieldRef)jc_instr;
        JcConstantFieldRef const_field_ref = instr_field_ref.getFieldRef();
        if ((const_field_ref.getIndex() & 0xFF00) == 0) {
            instr_field_ref.setWideInstr(false);
            instr_field_ref.setOpcode(narrow_opcode);
        }
    }

    private void setBranchInstr(JcInstruction jc_instr, int narrow_opcode) {
        JcInstrBranch branch_instr = (JcInstrBranch)jc_instr;
        branch_instr.setWideInstr(false);
        branch_instr.setOpcode(narrow_opcode);
    }

    private void passTwo(JcMethod jc_method) {
        JcInstruction code = jc_method.getCode();
        if (code == null) {
            return;
        }
        boolean changed = true;
        while (changed) {
            boolean branch_changed = false;
            changed = false;
            for (JcInstruction jc_instr = code; jc_instr != null; jc_instr = jc_instr.getNextInstr()) {
                int jc_opcode = jc_instr.getOpcode();
                switch (jc_opcode) {
                    case 96: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 152, jc_method);
                        break;
                    }
                    case 97: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 153, jc_method);
                        break;
                    }
                    case 98: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 154, jc_method);
                        break;
                    }
                    case 99: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 155, jc_method);
                        break;
                    }
                    case 100: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 156, jc_method);
                        break;
                    }
                    case 101: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 157, jc_method);
                        break;
                    }
                    case 102: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 158, jc_method);
                        break;
                    }
                    case 103: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 159, jc_method);
                        break;
                    }
                    case 104: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 160, jc_method);
                        break;
                    }
                    case 105: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 161, jc_method);
                        break;
                    }
                    case 106: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 162, jc_method);
                        break;
                    }
                    case 107: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 163, jc_method);
                        break;
                    }
                    case 108: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 164, jc_method);
                        break;
                    }
                    case 109: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 165, jc_method);
                        break;
                    }
                    case 110: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 166, jc_method);
                        break;
                    }
                    case 111: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 167, jc_method);
                        break;
                    }
                    case 112: {
                        branch_changed = this.optimizeBranchInstr(jc_instr, 168, jc_method);
                    }
                }
                if (!branch_changed) continue;
                changed = true;
            }
        }
    }

    private boolean optimizeBranchInstr(JcInstruction jc_instr, int wide_opcode, JcMethod jc_method) {
        JcInstrBranch branch_instr = (JcInstrBranch)jc_instr;
        int label = branch_instr.getBranchLabel();
        int offset = this.computeOffset(jc_instr, label, jc_method);
        if (DataType.getType(offset) != 1) {
            branch_instr.setWideInstr(true);
            branch_instr.setOpcode(wide_opcode);
            return true;
        }
        return false;
    }

    private int computeOffset(JcInstruction jc_instr, int label, JcMethod jc_method) {
        JcInstruction code;
        JcInstruction target_instr = null;
        for (code = jc_method.getCode(); code != null; code = code.getNextInstr()) {
            if (code.getLabel() != label) continue;
            target_instr = code;
            break;
        }
        if (target_instr == null) {
            throw new ConverterInternalError();
        }
        int branch_pc = 0;
        int target_pc = 0;
        int current_pc = 0;
        for (code = jc_method.getCode(); code != null; code = code.getNextInstr()) {
            if (code == jc_instr) {
                branch_pc = current_pc;
            }
            if (code == target_instr) {
                target_pc = current_pc;
            }
            current_pc += code.getSizeInBytes();
        }
        return target_pc - branch_pc;
    }
}

