 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "amr_plus_fx.h"
#include "enc_if_fx.h"
#include "typedef.h"
#include "basic_op.h"
#include "count.h"
#include "wbplus3gplib.h"

void Copy_coder_state(
  Coder_State_Plus_fx *wbP,/* AMR-WB+ state struct */
  void   *st,               /* AMR-WB state struct  */
  Word16 sw,                /* sw=0 -> switch from WB to WB+, sw=1 -> switch from WB+ to WB */
  Word16 use_case_mode
);
void copyright(void) 
{
   fprintf(stderr, "\n");
   fprintf(stderr, "\n");
}
static void usage(char *argv)
{
   fprintf(stderr,
           "Usage: %s -rate <Bit rate> [-mono] | -mi <mode index> [-isf <factor>] [-lc] [-dtx] -ff <3gp/raw> -if <infile.wav> -of <outfile.wb+>\n"
#ifdef CONFORMANCE
           " [-fm <forced mode>] [-stat] "           
#endif
           ,argv);
   fprintf(stderr, "\n");
   fprintf(stderr, "-rate   Bit rate between 6-36 kbps mono or 7-48 kbps stereo \n");
   fprintf(stderr, "-mono   Force mono encoding \n");
   fprintf(stderr, "\n");
   fprintf(stderr, "\n");
   fprintf(stderr, "-mi     Mode Index (0..15  -> AMR WB\n                  16..47 -> AMR WB+) (see ts 26.304 Table 14) \n");
   fprintf(stderr,
                   "-isf    Internal Sampling Frequency (0.5... 1.5, default is 1.0).\n");
   fprintf(stderr, "\n");
   fprintf(stderr, "\n");

   fprintf(stderr, "-lc     low complexity (for AMR-WB+ modes).\n");
   fprintf(stderr,
                   "-dtx    enables VAD/DTX functionality (for AMR-WB modes).\n");
#ifdef CONFORMANCE
   fprintf(stderr, "-fm     Forced Mode\n"
                            "\t-1: Free\n"  
                            "\t0 : Acelp\n"
                            "\t1 : TCX 20ms\n"
                            "\t2 : TCX 40ms\n"
                            "\t3 : TCX 80ms\n"
                            "\t4 : Modes copied from a reference\n\n"
                            );
   fprintf(stderr, "-stat   Print somes encoder statistics\n\n");
#endif

   fprintf(stderr, "\n");
   fprintf(stderr, "-ff     3gp File Format / raw format\n");
   fprintf(stderr, "-if     input audio WAV file.\n");
   fprintf(stderr, "-of     output AMRWB+ 3gp file.\n");
   fprintf(stderr, "-cf     configuration file\n");
   fprintf(stderr, "\n");

}

static Word32 get_bitrate(EncoderConfig * conf)
{
  Word32 Ltmp;
  Word16 tmp16;
  test();
  if(conf->fscale!=0) 
  {
    tmp16 = mult_r(get_nb_bits(conf->extension, conf->mode, conf->st_mode), 26214); /*Q0*Q21 -> Q6*/
    Ltmp = L_mult(conf->fscale, mult_r(tmp16,21845));   /* Q6*Q6 ->Q13 */
    return Ltmp;
  }
  else 
  {
    return L_shr(L_mult(get_nb_bits(conf->extension, conf->mode, conf->st_mode),26214),9); /*Q22 - 9 ->Q13*/
  }

}
void get_raw_3gp_mode(Word16 *mode, Word16 *st_mode, Word16 raw_3gp_mode ,Word16 extension )
{ 
    Word16 index;
    /* Mono mode only */
    test();test();test();test();test();test();test();test();
    if( sub(raw_3gp_mode,8) <= 0 )
    {
        test();
        if (extension != 0)
        {
            fprintf(stderr, "-isf is not supported by amr_wb\n");
            exit(EXIT_FAILURE);
        }

        *mode = raw_3gp_mode;       move16();move16();
        *st_mode = -1;
    }
    else if(sub(raw_3gp_mode, 10)== 0)    /* 14m */
    {
        *mode = 2;      move16();move16();
        *st_mode = -1;
    }
    else if (sub(raw_3gp_mode,11)== 0) /* 18s */
    {
        *mode = 2;      move16();move16();
        *st_mode = 6;
    }
    else if (sub(raw_3gp_mode,12)== 0)   /* 24m*/
    {
        *mode = 7;          move16();move16();
        *st_mode = -1;
    }
    else if (sub(raw_3gp_mode,13) == 0)    /*24s*/
    {
        *mode = 5;          move16();move16();
        *st_mode = 7;
    }  
    else if( (sub(raw_3gp_mode,16) >= 0) && (sub(raw_3gp_mode,24) < 0) )
    {
        *mode =   raw_3gp_mode - 16;  move16();move16();
        *st_mode = -1;
    }
    else if( (sub(raw_3gp_mode,24) >= 0) && (sub(raw_3gp_mode,47) <= 0) )
    {
        index = raw_3gp_mode - 24;  move16();move16();move16();
        *mode = miMode_fx[2*index];
        *st_mode = miMode_fx[2*index+1];
    }
    else
    {
        printf("Invalid Mode Index\n");
        exit(EXIT_FAILURE);
    }

}
static Word16 get_isf_index(Word16 *fscale)
{ 
  Word16 index, i ;
  Word16 dist, tmp16;
  index = 0;    move16();
  dist = 512;     move16();
  /* Mono mode only */
  for (i = 0;i < 14; i++)
  {
    tmp16 = abs_s(sub(*fscale, isfIndex_fx[i]));
    test();
    if(sub(tmp16,dist) < 0)
    {
      dist = tmp16;   move16();
      index = i;      move16();
    }

  }
  *fscale = isfIndex_fx[index];      move16();
  return index;
}
static void parsecmdline(
  int argc,
  char  *argv[],
  char  **input_filename,
  char  **output_filename, 
  char **config_filename, 
  EncoderConfig * conf,
  Word16 *rate 
#ifdef CONFORMANCE
  ,short *forced_mode,
  short *print_stat
#endif

  )
{
   Word16 simple_mode,amr_wb, amr_wbp_carac, mi_mode;
   Word32 srate;
   Word32 mrate;
    
   if (argc == 1)
   {
      usage(argv[0]);
      exit(EXIT_FAILURE);
   }
   conf->extension    = 0;               move16();
   conf->allow_dtx    = 0;               move16();
   conf->use_case_mode= USE_CASE_A;      move16();
   conf->fscale       = 0;               move16();
   conf->mode         = -1;              move16();
   conf->st_mode      = -1;              move16();
   conf->FileFormat   = F3GP;            move16();
   conf->mode_index   = -1;              move16();
   conf->fscale_index = 0;               move16();
   conf->bc           = 0;               move16();
   
   
   simple_mode = 0;                      move16();
   amr_wb = 0;                     move16();
   amr_wbp_carac = 0;                     move16();
   mi_mode = 0;                          move16();
   mrate = -1;                           move16();
   srate = -1;                           move16();
   *rate = -1;                           move16();
#ifdef CONFORMANCE
    *print_stat = -1;
    *forced_mode = -1;
#endif
 
   argc--;
   argv++;

  
      test();
      while (argc > 0)
      { test();
        if (!strcmp(*argv, "-mi"))
        {  test();test();
           if (simple_mode)
           {
              fprintf(stderr, "Can't use -rate with -mi\n");
              exit(EXIT_FAILURE);
           }
           mi_mode = 1;
           argv++;
           argc--;
         
           conf->mode_index = atoi(*argv);   move16();
           test();test();test();test();test();
           if (conf->mode_index < 0 || sub(conf->mode_index,47) > 0)
           {
              fprintf(stderr, "Unknown Mode Index (see TS 26.290)\n");
              exit(EXIT_FAILURE);
           }
           else if (sub(conf->mode_index,9) == 0 || sub(conf->mode_index,14) == 0 || sub(conf->mode_index,15) == 0)
           {
              fprintf(stderr, "Mode Index %d is reserved (see TS 26.290)\n", conf->mode_index);
              exit(EXIT_FAILURE);  
           }
           else
           {
             test();test();test();test();
             if ( (conf->mode_index >= 0) &&  (sub(conf->mode_index,8) <= 0) ) /* amr_wb modes */
             {
                 get_raw_3gp_mode(&(conf->mode), &(conf->st_mode),(Word16) atoi(*argv), conf->extension);
                 amr_wb = 1;
             }
             else if ( (sub(conf->mode_index,10) >= 0) && (sub(conf->mode_index,13) <= 0) )  /* WB+ tested modes */    
             {  
                 get_raw_3gp_mode(&(conf->mode), &(conf->st_mode),(short) atoi(*argv), conf->extension);
                 conf->extension = 1;
                 amr_wbp_carac = 1;
             }
             else
             {
                conf->extension = 1;      move16();
                get_raw_3gp_mode(&(conf->mode), &(conf->st_mode),conf->mode_index, conf->extension );
                test();
                if(conf->fscale == 0)
                {
                  conf->fscale = FSCALE_DENOM;   move16();
                  conf->fscale_index = 8;   
                }

             }
         
           }
        }
        else if (!strcmp(*argv, "-isf"))
        {
           if (simple_mode)
           {
              fprintf(stderr, "No simple mode when using -isf\n");
              exit(EXIT_FAILURE);
           }
           if (amr_wb)
           {
              fprintf(stderr, "-isf is not supported by amr_wb\n");
              exit(EXIT_FAILURE);
           }
           argv++;
           argc--;
           mi_mode = 1;               /* -isf is only allow with -mi */
           conf->extension = 1;   move16();
           if ((atof(*argv) >= 0.5) && (atof(*argv) <= 1.5))
           {
              conf->fscale = (Word16) ((atof(*argv) * FSCALE_DENOM) + 0.5f);   move16();
              /* force scale to be an even number */
              conf->fscale = (conf->fscale >> 1) << 1;   move16();
              /* limit the scale factor */
              test();
              if (sub(conf->fscale,FAC_FSCALE_MAX) > 0)
              {
                 conf->fscale = FAC_FSCALE_MAX;   move16();
              }
              test();
              if (sub(conf->fscale,FAC_FSCALE_MIN) < 0)
              {
                 conf->fscale = FAC_FSCALE_MIN;   move16();
              }
              conf->fscale_index = get_isf_index(&(conf->fscale));        move16(); /* Use "fscale from index" */
           }
           else
           {
              fprintf(stderr, "Unknown Inernal Sampling Frequency factor\n");
              exit(EXIT_FAILURE);
           }
        }
        else if (!strcmp(*argv, "-rate"))
        {
          test();
          if(mi_mode > 0)
          {
            fprintf(stderr, "Can't use -rate with -mi or -isf \n");
            exit(EXIT_FAILURE);
          }
          argv++;
          argc--;
          simple_mode = 1;      move16();
          *rate = (Word16)(atof(*argv)*64+0.5);     move16(); /*Q6*/
          conf->extension = 1;                      move16();
          test();test();
          if(sub(*rate,384) < 0 || sub(*rate,3072) > 0) 
          {
            fprintf(stderr, "Minimum rate is 6.0kbps and maximum rate is 48.0 kbps\n");
            exit(EXIT_FAILURE);
          }
        }
        else if (!strcmp(*argv, "-mono"))
        {
            conf->st_mode = -2; move16(); /* indicate mono is forced */
            test();
            if(sub(*rate,2304) > 0) 
            {
               fprintf(stderr, "Maximum mono rate is 36.0 kbps\n");
               exit(EXIT_FAILURE);
            }
        }
        else if (!strcmp(*argv, "-lc"))
        {
           conf->use_case_mode = USE_CASE_B;   move16();
        }
        else if (!strcmp(*argv, "-dtx"))
        {
           conf->allow_dtx = 1;   move16();
        }
        else if (!strcmp(*argv, "-bc"))
        {
           conf->bc = 1;
        }
        else if (!strcmp(*argv, "-if"))
        {
           argv++;
           argc--;
           *input_filename = *argv;   move16();
        }
        else if (!strcmp(*argv, "-of"))
        {
           argv++;
           argc--;
           *output_filename = *argv;   move16();
        }
        else if (!strcmp(*argv,"-cf")) 
        {
            argv++;
            argc--;
            *config_filename = *argv;   move16();
        }
        else if (!strcmp(*argv, "-ff"))
        {
           argv++;
           argc--;
           if(!strcmp(*argv, "raw"))
           {
              conf->FileFormat = FRAW;
           }
           else
           {
              conf->FileFormat = F3GP;
           }
        }
#ifdef CONFORMANCE
        else if (!strcmp(*argv,"-stat")) 
        {
            *print_stat = 1;
        }
        else if (!strcmp(*argv,"-fm")) 
        {
            argv++;
            argc--;
            *forced_mode = atoi(*argv);
            if(*forced_mode < -1 || *forced_mode >4)
            {
                fprintf(stderr, "Bad forced mode \n");
                exit(EXIT_FAILURE);
            }
            
        }
#endif
        else
        {
           fprintf(stderr, "Unknown RTP/3GP File Format option %s\n", *argv);
           exit(EXIT_FAILURE);
        }
        argv++;
        argc--;
     }
     if (amr_wbp_carac && conf->fscale != 0)
     {
        fprintf(stderr, "-isf is not supported with AMR WB caracterized modes\n");
        exit(EXIT_FAILURE);
     }
     if (conf->st_mode == -2 && simple_mode != 1)
     {
        fprintf(stderr, "Choose right Mode Index to encode mono File\n-mono is only supported with -rate\n");
        exit(EXIT_FAILURE);
     }
   
}


static void set_frame_length(
  Word32  samplingRate, 
  Word16  fscale, 
  Word16  *L_frame,
  Word16  *L_next,
  Word16  *L_next_st,
  Word16 *invsamplingRate)
{
   test(); 
   if (fscale != 0)
   {
     test();test();test();test();test();test();test();test();
      switch (samplingRate)
      {
#ifdef FILTER_48kHz
      case 8000:
      case 16000:
      case 24000:
      case 32000:
      case 48000:
        *L_frame = 2 * L_FRAME48k;      move16();
        *invsamplingRate = 2796;   move16(); /*Q15+12*/
        break;
#endif
#ifdef FILTER_44kHz
      case 11025:
      case 22050:
      case 44100:
        *L_frame = 2 * L_FRAME44k;    move16();
        *invsamplingRate = 3043;   move16(); /*Q15+12*/
        break;
#endif
      default:
         fprintf(stderr, "error in sampling frequency.  choice of filter are: \n");
#ifdef FILTER_44kHz
         fprintf(stderr, "     11, 22, 44 kHz \n");
#endif
#ifdef FILTER_48kHz
         fprintf(stderr, "     8, 16, 24, 32, 48 kHz \n");
#endif
         exit(EXIT_FAILURE);
         break;
      }
   }
   else 
   {
     test();test();test(); 
     switch (samplingRate)
     {
      case 8000:
         *L_frame = L_FRAME8k;     move16();
         *L_next = L_NEXT8k;     move16();
         *L_next_st = L_NEXT_ST8k;     move16();
         *invsamplingRate = 16777;   move16(); /*Q15+12*/
         break;
      case 16000:
         *L_frame = L_FRAME16kPLUS;     move16();
         *L_next = L_NEXT16k;     move16();
         *L_next_st = L_NEXT_ST16k;     move16();
         *invsamplingRate = 8389;   move16(); /*Q15+12*/
         break;
      case 24000:
         *L_frame = L_FRAME24k;     move16();
         *L_next = L_NEXT24k;     move16();
         *L_next_st = L_NEXT_ST24k;     move16();
         *invsamplingRate = 5592;   move16(); /*Q15+12*/
         break;
      default:
         fprintf(stderr, "error in sampling freq: without fsratio(isf) only 8, 16 or 24 kHz are allowed\n");
         exit(EXIT_FAILURE);
         break;
      }
   }
}
static void deinterleave(
  Word16 *buf,
  Word16 *left,
  Word16 *right,
  Word16 length
)
{
  Word16 i;
  for (i=0; i<length; i++) 
  {
    left[i] = buf[i*2];           move16();
    right[i] = buf[(i*2)+1];      move16();
  }

}
static void GetRate(EncoderConfig *conf, Word16 rate, const Word16 *TableRate, Word16 lenght)
{
  Word16 index, i ;
  Word16 dist, ftmp;
  dist = MAX_16;     move16();
  /* Mono mode only */
  for (i = 0;i < lenght; i+=3)
  {
    ftmp = abs_s(sub(rate, TableRate[i]));
    test();
    if(sub(ftmp,dist) < 0)
    {
      dist = ftmp;    move16();
      index = i;      move16();
    }
  }
  conf->mode_index = TableRate[index+1];    move16();
  conf->fscale_index = TableRate[index+2];    move16();
  get_raw_3gp_mode(&conf->mode, &conf->st_mode, conf->mode_index, conf->extension);
  conf->fscale = isfIndex_fx[conf->fscale_index];    move16();
}

long ext_frame = 0;

#ifdef _DEBUG
#include <crtdbg.h>

void DetectMemLeaks() 
{ 
     _CrtSetDbgFlag(_CRTDBG_LEAK_CHECK_DF|_CRTDBG_ALLOC_MEM_DF|_CRTDBG_CHECK_ALWAYS_DF); 
     _CrtSetReportMode(_CRT_ASSERT,_CRTDBG_MODE_FILE); 
     _CrtSetReportFile(_CRT_ASSERT,_CRTDBG_FILE_STDERR); 
} 

#endif
void Close_wbp(Coder_State_Plus_fx *st, Word16 UseCaseB)
{

  if(st->_stClass != NULL && UseCaseB > 0 )
  {
    free(st->_stClass);
    st->_stClass = NULL;
  }
  if(st->_vadSt != NULL && UseCaseB > 0 )
    Wb_vad_exit(&st->_vadSt);
 

  if(st != NULL)
  {
    free(st);
    st = NULL;
  }

}
/* Don't have to be instrumented */
Word16 get_config(FILE *fp, Word32 t[])
{
  Word16 OK = 0;
  
  if (!fp || feof(fp))
    return 0;
  
  /*
    read from config file the following items
    time  extension  mode_index fscale 
    time (in seconds) must always be above 0.0, 0.000001 is OK
  */
  
  while (!OK && !feof(fp)) 
  {
    Word8 s[100], *sp;
    Word32 ix  = 0;
    t[0] = 0;

    fgets(s,99,fp);
    sp = strtok(s," \t");
    
    t[0] = (Word32)(atof(sp)*8192+0.5);    /*Q13*/
    sp = strtok(0," \t");
  
    if (sp)
    {
      t[1] = (Word32)(atoi(sp));    /*extension Q0*/
      sp = strtok(0," \t");
  
      if (sp)
      {
        t[2] = (Word32)(atoi(sp));    /*mi Q0*/
        sp = strtok(0," \t");
        if (sp)
        {
          t[3] = (Word16)((atof(sp) * FSCALE_DENOM) + 0.5f);       /*fscale Q0*/
         /* force scale to be an even number */
          //t[3] = ((t[3]>> 1)<< 1); 
          sp = strtok(0," \t");
        }
      }
    }
    
    if (t[0] != 0)
    {
      return 1;
    }
  }
  return 0;
}

int main(int argc, char *argv[])
{

  FILE *f_speech;         /* File of speech data			 */	
  FILE *f_serial;         /* File of serial bits for transmission  */

  Word16  speech16[L_FRAME_FSMAX*2];
  Word16  serial[NBITS_MAX];			/* serial parameters.			 */
  unsigned char serialAmrwb[NBITS_MAX];		/* serial parameters.			 */

  Word16 channel_right[4*L_FRAME_FSMAX]; // Kan halveras om ett sampel i taget lses in
  Word16 channel_left[2*L_FRAME_FSMAX];

  Coder_State_Plus_fx *st;
  Word16  numOfChannels, bitsPerSample; 	
  void *stAmrwbEnc=NULL;
  Word16 mem_up_right[2*L_FILT_OVER_FS], mem_up_left[2*L_FILT_OVER_FS];
  Word16 frac_up_right, frac_up_left, tmp16;
  Word16 fac_up, fac_down, nb_samp_fs;

  Word32 frame;
  Word16 i, lg, L_frame, nb_bits=0;
  Word32 samplingRate, dataSize;
  Word16 L_next, L_next_st;
  Word16 nb_samp, invsamplingRate, nb_hold = 0;
  Word16 mode, extension;
  Word32 Ltmp;
  Word16 serial_size=0;


  char *input_filename;
  char *output_filename;
  Word16 st_mode, old_st_mode;
  EncoderConfig conf;
  Word16  fst;
  Word16 rate;
  char FileFormatType[25];

  FILE *f_config = NULL;
  Word32 rec_time = 0;
  Word32 config_file_time = 0;
  Word32 t[4]; /* time,conf.extension,conf.mode_index,conf.fscale */
  Word32 old_bitrate;
  Word8 *config_filename = NULL;
  Word16 Chan2mult;

#ifdef CONFORMANCE
  short forced_mode, mode_flp[4];
  short print_stat;
  FILE *fp_st = NULL;
  FILE *fp_stflp = NULL;
  fp_st = fopen("mode_stat.txt", "w+");
  fp_stflp = fopen("mode_statflp.txt","rb");
#endif



  /* Initializations */
  input_filename = NULL;
  output_filename = NULL;
  move16();move16();move16();move16();move16();move16();move16();


#ifdef _DEBUG
DetectMemLeaks() ;
#endif

  /* Display Copyright Banner */
  copyright();

  /* Parse Command Line  */
  parsecmdline(argc, argv, &input_filename, &output_filename,&config_filename, &conf  ,&rate
#ifdef CONFORMANCE
    ,&forced_mode,
    &print_stat
#endif
        );
  
  /* Open input wave file */

  if ((f_speech = Wave_Fopen(input_filename, "rb", &numOfChannels, &samplingRate, 
        &bitsPerSample, &dataSize)) == NULL)
  {
    fprintf(stderr, "Error opening the input file %s.\n", input_filename);
    exit(EXIT_FAILURE);
  }
   /* Simple interface */
  test();
  if (sub(rate,-1) != 0)
  {
    test();test();
    if(sub(conf.st_mode,-2) == 0 || sub(numOfChannels,1) == 0)
    {
        GetRate(&conf, rate, MonoRate, 3*18);
    }
    else
    {
        GetRate(&conf, rate, StereoRate, 3*27);
    }

  }

  /* test if it is stereo input */
  test();test();
  if((conf.st_mode >= 0) && (sub(numOfChannels,2) != 0) ) 
  {
    fprintf(stderr, "Input file %s must be stereo\n", input_filename);
    exit(EXIT_FAILURE);
  }

  /* test if it is 16 bits PCM */
  test();
  if(sub(bitsPerSample,16) != 0) 
  {
    fprintf(stderr, "Input file %s must be 16 bits encoded\n", input_filename);
    exit(EXIT_FAILURE);
  }
  test();
  if (sub(conf.FileFormat,F3GP) == 0)
  {
      strcpy(FileFormatType,"3gp File Format");
      test();
      if(sub(conf.bc,1) == 0) 
      {
        /* create backward compatible file */
        Create3GPAMRWB();
      } 
      else 
      {
        Create3GPAMRWBPlus();
      }
  }
  else
  {
      strcpy(FileFormatType,"Raw File Format");
      /* Open the output bitstream file */
      if ((f_serial = fopen(output_filename, "wb")) == NULL) 
      {
	      fprintf(stderr, "Error opening output bitstream file %s.\n",output_filename);
	      exit(EXIT_FAILURE);
      }
  }
  if ((conf.extension == 0) && (samplingRate != 16000))
  {
    fprintf(stderr, "AMR-WB work only at 16kHz\n");
    exit(EXIT_FAILURE);
  }
  fac_up = fac_down = 12;     move16();/* no oversampling by default */
  invsamplingRate = 2796;   move16(); /*Q15+12*/

  test();
  if (conf.fscale != 0)
  {
    test();test();test();test();test();test();
    switch (samplingRate) 
    {
      case 8000:
        fac_down = 2;            move16();
        samplingRate  = 48000;   move16();
        invsamplingRate = 16777;   move16(); /*Q15+12*/
      break;
      case 16000:
        fac_down = 4;   move16();
        samplingRate  = 48000;   move16();
        invsamplingRate = 8389;   move16(); /*Q15+12*/
      break;
      case 24000:
        fac_down = 6;   move16();
        samplingRate  = 48000;   move16();
        invsamplingRate = 5592;   move16(); /*Q15+12*/
      break;
      case 32000:
        fac_down = 8;   move16();
        samplingRate  = 48000;   move16();
        invsamplingRate = 4194;   move16(); /*Q15+12*/
      break;
      case 11025:
        fac_down = 3;   move16();
        samplingRate  = 44100;   move16();
        invsamplingRate = 12174;   move16(); /*Q15+12*/
      break;
      case 22050:
        fac_down = 6;   move16();
        samplingRate  = 44100;   move16();
        invsamplingRate = 6087;   move16(); /*Q15+12*/
      break;
    }
    Set_zero(mem_up_right, 2*L_FILT_OVER_FS);
    Set_zero(mem_up_left, 2*L_FILT_OVER_FS);
  }
  frac_up_right = 0;   move16();
  frac_up_left = 0;   move16();

  /* Set default buffer lengths */
  set_frame_length(samplingRate,conf.fscale,&L_frame,&L_next,&L_next_st, &invsamplingRate);

  /* reserve memory for encoder and decoder states */
  st = malloc(sizeof(Coder_State_Plus_fx));
  
  /*
   Display Information
  */
  old_bitrate = get_bitrate(&conf);
  fprintf(stderr,"%s\nEncoding @ %6.2fkbps",FileFormatType ,(float)old_bitrate/8192.0);

  /*
   Initialise the Complexity Counters
  */
  Init_WMOPS_counter ();


  /* AMRWB+ extensions*/
  Init_coder_amrwb_plus(st, numOfChannels, conf.fscale, conf.use_case_mode,1);

  stAmrwbEnc = E_IF_init_fx();
  /*
  Fill-up lookahead buffers 
  */
  /* number of sample per channel to read from file */
  /*nb_samp_fs = ((L_frame*fac_down)+frac_up_right) / fac_up;*/
  Ltmp = L_mult(L_frame, fac_down);
  Ltmp = L_mac(Ltmp, frac_up_right, 1);

  nb_samp_fs = div_s(extract_h(L_shl(Ltmp, 11)), 24576);

  tmp16 = add(nb_samp_fs, 1);
  Ltmp = L_msu(Ltmp, tmp16, fac_up);
  test();
  if (Ltmp >= 0)
  {
    nb_samp_fs = tmp16;            move16();
  } 

  lg = Read_data(f_speech, channel_right, (numOfChannels * nb_samp_fs));
  if (L_sub(L_shl(lg,1),L_mult(numOfChannels, nb_samp_fs)) != 0)
  {  
    printf("Error: file too Word16 !\n");
    exit(EXIT_FAILURE);
  }
  test();  
  if (sub(numOfChannels,2) == 0) 
  {
    /* remove interleave of left and right samples */				
    deinterleave(channel_right,channel_left,channel_right,nb_samp_fs);
    Over_fs(channel_left, channel_left, L_frame, fac_down, mem_up_left, &frac_up_left);
  }
  Over_fs(channel_right, channel_right, L_frame, fac_down, mem_up_right, &frac_up_right);
  test();  
  if (conf.extension > 0)
  {
    test();
    nb_samp = Coder_amrwb_plus_first(channel_right, channel_left, numOfChannels,  L_frame,
                                    (numOfChannels == 1) ? L_next : L_next_st, conf.fscale, st);
  }
  else
  {
    E_IF_encode_first_fx(stAmrwbEnc, speech16);
    nb_samp = 320;      move16();
  }

  fprintf(stderr,"\n --- Running ---\n");

  /*---------------------------------------------------------------------------*
  * Loop for every analysis/transmission frame.                               *
  *   -New L_FRAME_PLUS data are read. (L_FRAME_PLUS = number of speech data per frame) *
  *   -Conversion of the speech data from 16 bit integer to real              *
  *   -Call coder_wb to encode the speech.                                    *
  *   -The compressed serial output stream is written to a file.              *
  *   -The synthesis speech is written to a file                              *
  *--------------------------------------------------------------------------*/

  /* set current config */
  mode = conf.mode;                         move16();
  extension = conf.extension;               move16();    
  old_st_mode = st_mode = conf.st_mode;     move16();move16();
  frame=0;                                  move32();

  fst = conf.fscale;                        move16();


  test();
  if (config_filename != 0 ) 
  {
    if(sub(fac_down,12)!=0)
    {
      fprintf(stderr, "Must have 16kHz (to switch amr-wb -> wb+ (mode 10@13))\n"
        "or 48kHz (wb+) input\n\n");
      exit(EXIT_FAILURE);
    }

    if(sub(numOfChannels,1)==0)
    {
      fprintf(stderr, "** Warning **\nDo not switch to stereo... \nyou have mono input\n\n");
    }
    /* Don'T complexity of config file */
    f_config = fopen(config_filename,"r");
    if (!f_config) 
    {
      fprintf(stderr, "Error opening config file %s.\n",config_filename);
      exit(EXIT_FAILURE);
    }
    
    while (!get_config(f_config,t) && !feof(f_config)) 
    {
       printf("%2.3f \n",(float)t[0]/8192.0);
    }
    config_file_time = t[0];   
    rec_time = 0;              
  }



  Chan2mult = sub(numOfChannels,1);
  dataSize = L_shl(dataSize,Chan2mult);
  dataSize = L_sub(dataSize, lg);

#ifdef CONFORMANCE
/* Initialize conformance tool */
st->forced_mode = forced_mode;
st->print_stat = print_stat;

#ifdef NO_ACELP
printf("** NO_ACELP has no meaning in the tested decoder\n");
#endif
if(st->forced_mode == -1)
{
  printf("Modes will be freely chosen between ACELP, TCX20, TCX40 or TCX80\n\n");
}
else if(st->forced_mode == 0)
  printf("mode ACELP is forced\n\n");
else if(st->forced_mode == 1)
  printf("mode TCX 20 is forced\n\n");
else if(st->forced_mode == 2)
  printf("mode TCX 40 is forced\n\n");
else if(st->forced_mode == 3)
  printf("mode TCX 80 is forced\n\n");


else if(st->forced_mode == 4)
{
    st->fp_ms = fopen("ReferenceMode.txt","rb");
    if(st->fp_ms == NULL )
    {
      printf("Invalide filename used to copy modes\n");
      exit(EXIT_FAILURE);
    }
    printf("reading ReferenceMode.txt ");
    printf("==> Use references modes\n\n");

}
st->fp_snrraw = fopen("snrfxd.raw","wb");

if (st->fp_snrraw != NULL)
  printf("writing snrfxd.raw\n");
if (fp_stflp != NULL)
  printf("reading mode_statflp.txt\n");
if (fp_st != NULL)
  printf("writing mode_stat.txt\n");
#endif

  test(); test();
  while (lg != 0 || frame == 0)
  {
      test();test();
      Reset_WMOPS_counter();
#ifdef CONFORMANCE
if(st->forced_mode == 4)
{
    fread(st->coding_mod, sizeof(short), 4, fp_stflp);
}
else if (st->forced_mode >= -1 && st->forced_mode < 4)
{
  for(i = 0;i<4; i++)
      st->coding_mod[i] = st->forced_mode;

}
#endif
      
      fprintf(stderr," Frames processed: %ld    \r", frame);
      /* Update frame counter */
      frame =L_add(frame,1);

      test();
      if (f_config) 
      {  
         Word16 tmp_modeIndex;

         /*Don'T count complexity of reading mode config but count complexity if handling it */
         test(); test();
         if (L_sub(rec_time,config_file_time) >= 0 && L_sub(t[0],-8192) != 0 && !feof(f_config)) {
            extension = extract_l(t[1]); 
            tmp_modeIndex = extract_l(t[2]);  

            test();
            if (extension == 0) 
            {
               mode  = tmp_modeIndex;   move16();
               st_mode = -1;              move16();
               conf.mode = tmp_modeIndex;   move16();
               conf.st_mode = -1;  move16();
               conf.mode_index = tmp_modeIndex; move16();
            } 
            else
            {
               conf.mode_index = tmp_modeIndex;        move16();
               get_raw_3gp_mode(&(conf.mode), &(conf.st_mode),conf.mode_index, extension );
            }
            fst = extract_l(t[3]);  
            get_isf_index(&fst);      /* Use "fst from index" */
            
            while (!get_config(f_config,t)&& !feof(f_config)) 
            {
            }
            config_file_time = t[0];    move32();
         }
      }

      test();
      if (sub(fst,conf.fscale) != 0) 
      {
          conf.fscale = fst;    move16();
          Init_coder_amrwb_plus(st, numOfChannels, conf.fscale,
                              conf.use_case_mode, 0);

          set_frame_length(samplingRate,conf.fscale,&L_frame,&L_next,&L_next_st, &invsamplingRate);
          conf.fscale_index = get_isf_index(&(conf.fscale));      /* Use "fscale from index" */
      }

      nb_hold = sub(L_frame, nb_samp);

      Copy(channel_right+nb_samp, channel_right, nb_hold);
      Copy(channel_left+nb_samp, channel_left, nb_hold);

     /* number of sample per channel to read from file */
     /*nb_samp_fs = ((L_frame*fac_down)+frac_up_right) / fac_up;*/
      Ltmp = L_mult(nb_samp, fac_down);
      Ltmp = L_mac(Ltmp, frac_up_right, 1);

      nb_samp_fs = div_s(extract_h(L_shl(Ltmp, 11)), 24576);

      tmp16 = add(nb_samp_fs, 1);
      Ltmp = L_msu(Ltmp, tmp16, fac_up);
      test();
      if (Ltmp >= 0)
      {
        nb_samp_fs = tmp16;            move16();
      } 

      lg = Read_data(f_speech, channel_right+nb_hold, (numOfChannels * nb_samp_fs));

      dataSize = L_sub(dataSize, lg);
      test();
      if(dataSize<0) /* prevent to read end file wav header */
      {
        break;
      }
      /* Remove interleaving in case of stereo input */
      test();
      if (sub(numOfChannels,2) == 0) 
      {
          deinterleave(channel_right+nb_hold, channel_left+nb_hold, channel_right+nb_hold, nb_samp_fs);
          Over_fs(channel_left+nb_hold, channel_left+nb_hold, nb_samp, fac_down, mem_up_left, &frac_up_left);
      }
      Over_fs(channel_right + nb_hold, channel_right + nb_hold, nb_samp,
              fac_down, mem_up_right, &frac_up_right);
      /* Test if the mode changed and update the config accordingly */
      /* Should only be used for mode switching experiments.... */
      
      test();test();test();test();
      if(((extension==0) && (sub(conf.extension,1) == 0 ))
          || ((sub(extension,1) == 0) && (conf.extension == 0)))
      {
      /* Copy encoder data in case of switch between WB and WB+ modes */
        test();test();test();test();test();
        if ( ((mode >= 0 && sub(mode,9) <= 0) || sub(mode,15) == 0) && (conf.extension>0) )
        {
            /* Switch from WB+ to WB */
            Copy_coder_state(st, stAmrwbEnc, 1, conf.use_case_mode); 
        }
        else if ( (mode >= 0 && sub(mode,8) <= 0) && (conf.extension==0) )
        {
            /* Switch from WB to WB+ */
            Copy_coder_state(st, stAmrwbEnc, 0, conf.use_case_mode);
        }
        conf.extension = extension;        move16();
      }
      test();  
      if (conf.extension > 0) 
      {
        /*     AMRWB+ Extensions */
        /* update needed if mode changes */
         nb_bits = get_nb_bits(conf.extension, conf.mode, conf.st_mode);
         test();
         if (sub(numOfChannels,2) == 0)
         {
              nb_samp = Coder_amrwb_plus_stereo(channel_right, channel_left, conf.mode, 
                                  L_frame, serial, st, conf.use_case_mode, conf.fscale, conf.st_mode);
          }
          else
          {   
              nb_samp = Coder_amrwb_plus_mono(channel_right,  conf.mode, 
                                      L_frame, serial, st, conf.use_case_mode, conf.fscale);
          }
          old_st_mode = conf.st_mode;     move16();
          
         /* write into the bitstream */
          test(); 
          if(sub(conf.FileFormat,F3GP) == 0)
          {
            WriteSamplesAMRWBPlus( conf,serial, nb_bits);
          }
          else
          {
              for (i=0; i<4; i++)
              {
                  WriteHeader(conf, nb_bits, i, f_serial);  
                  WriteBitstreamPlus( nb_bits, i, serial, f_serial);    
              }
          }
      }
      else 
      {
          
          /*        AMRWB                                        */
          
          for (i=0;i<4;i++) 
          {
              serial_size = (Word16 ) E_IF_encode_fx(stAmrwbEnc, (Word16)conf.mode, &channel_right[i*320], serialAmrwb, conf.allow_dtx);
              if(conf.FileFormat == F3GP)
              {
                WriteSamplesAMRWBPlus(conf,serialAmrwb, serial_size);
              }
              else
              {
                WriteHeader(conf, (Word16)serial_size, i, f_serial);  
                WriteBitstream( (Word16)serial_size, serialAmrwb, f_serial);    
              }
          }
          nb_samp = 4 * L_FRAME16k;  move16();

      }
      test();
      if (L_sub(L_abs(L_sub(old_bitrate,get_bitrate(&conf))),1) > 0) 
      {
         old_bitrate = get_bitrate(&conf);
         fprintf(stderr, "Rectime: %2.3f Encoding @ %6.2fkbps\n", (float)rec_time/8193.0f, (float)old_bitrate/8192.0f);
      }
      Ltmp = mult(shl(nb_samp,1), invsamplingRate);
      rec_time = L_add(rec_time, Ltmp);
#ifdef CONFORMANCE
fwrite(st->coding_mod, sizeof(short),4, fp_st);
#endif
      
  }
#ifdef CONFORMANCE
   if (st->print_stat >0)
   {
       int total_cnt;
       if (st->forced_mode >= 0 && st->forced_mode <= 3)
            printf(" \nSeg snr for mode %d is %.2f\n",st->forced_mode, st->seg_snr);
       else
            printf(" \nSeg snr for combined modes is %.2f\n",st->seg_snr);
       
       total_cnt = st->mode0_cnt+st->mode1_cnt+st->mode2_cnt+st->mode3_cnt;
       printf("\nACELP usage = %.2f\n", (float)st->mode0_cnt/total_cnt);
       printf("TCX20 usage = %.2f\n", (float)st->mode1_cnt/total_cnt);
       printf("TCX40 usage = %.2f\n",(float)st->mode2_cnt/total_cnt);
       printf("TCX80 usage = %.2f\n", (float)st->mode3_cnt/total_cnt);
        
       if (fp_stflp != NULL)
       {  int total_mode = 0, idem_mode = 0;
          short mode_fx[4], mode_read;
      
          fseek(fp_st, 0, SEEK_SET);
          fseek(fp_stflp, 0, SEEK_SET);
          while ((mode_read = fread(mode_fx,  sizeof(short), 4, fp_st))==4)
          {
              if(fread(mode_flp, sizeof(short), 4, fp_stflp)==4)
              {
                total_mode +=4;
                for(i = 0;i < 4; i++)
                {
                    if((mode_fx[i] - mode_flp[i]) == 0)
                    {
                      idem_mode++;
                    }
                }
              }
          }

          printf("%d identical decisions over %d Total decisions\n"
                 "Pourcentage of identical decision %.2f%%\n",idem_mode, total_mode, ((float)idem_mode/total_mode)*100);
          fclose(fp_st);
          fclose(fp_stflp);
       }
   }

#endif
    
  if(conf.FileFormat == F3GP)
  {
      Close3GP(output_filename);
  }
  else
  {
      fclose(f_serial);
  }

 
  if(stAmrwbEnc != NULL)
    E_IF_exit_fx(stAmrwbEnc);
  
  Close_wbp(st, conf.use_case_mode);  

  if (fst == 0) fst = FSCALE_DENOM;
  WMOPS_output(1, (float)fst / FSCALE_DENOM );
  
  Wave_Fclose(f_speech, bitsPerSample);
  
  return 0;
}
