echo on
REM *****************************************************************
REM *                           testv_dec.BAT                       *
REM *    script to validate BE of a tested AMR-WB+                  *
REM *     decoder with the 26.273.6.1 reference AMR-WB+ decoder     *
REM ***************************************************************** 
echo off

REM ***********************************
REM * bitstream directory
REM ***********************************
SET BIT_DIR=bit


REM ***********************************
REM * Output reference directory
REM ***********************************
mkdir clean_syn
mkdir fer_syn
SET OUT_DIR_CLEAN=clean_syn
SET OUT_DIR_FER=fer_syn

REM ***********************************
REM * Exe directory
REM ***********************************
SET EXE_DIR=bin

REM ***********************************
REM * Execs
REM ***********************************
SET REFERENCE_EXE=decoder_fxd
	
REM ***********************************
REM * Constants options
REM ***********************************

SET CLEAN_OPTIONS48k=-ff raw -limiter -fs 48000 
SET FER_OPTIONS48k=-ff raw -limiter -fs 48000 -fer fer_10_percent.txt
SET CLEAN_OPTIONS16k=-ff raw -limiter -fs 16000 
SET FER_OPTIONS16k=-ff raw -limiter -fs 16000 -fer fer_10_1percent.txt
SET CLEAN_OPTIONS8k=-ff raw -limiter -fs 8000 
SET FER_OPTIONS8k=-ff raw -limiter -fs 8000 -fer fer_10_2percent.txt

echo on
REM 48kHz reference clean
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS48k% -if %BIT_DIR%\sw_48_lc_fs_mi.bit -of %OUT_DIR_CLEAN%\sw_48_lc_fs_mi_48k.wav
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS48k% -if %BIT_DIR%\sw1_48_hc_fs_mi.bit -of %OUT_DIR_CLEAN%\sw1_48_hc_fs_mi_48k.wav
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS48k% -if %BIT_DIR%\concatener.bit -of %OUT_DIR_CLEAN%\concatener_48k.wav
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS48k% -mono -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_CLEAN%\m_po_x_1_org_48k.wav

REM 16kHz reference clean
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS16k% -if %BIT_DIR%\TH_16s.bit -of %OUT_DIR_CLEAN%\TH_16s.wav
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS16k% -mono -if %BIT_DIR%\TH_16m.bit -of %OUT_DIR_CLEAN%\TH_16m.wav

REM 8kHz reference clean
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS8k% -if %BIT_DIR%\m_po_x_1_orgs.bit -of %OUT_DIR_CLEAN%\m_po_x_1_orgs.wav
%EXE_DIR%\%REFERENCE_EXE% %CLEAN_OPTIONS8k% -mono -if %BIT_DIR%\m_po_x_1_orgm.bit -of %OUT_DIR_CLEAN%\m_po_x_1_orgm.wav
	
REM Frequency swap reference clean

%EXE_DIR%\%REFERENCE_EXE% -ff raw -fs 11025 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_CLEAN%\m_po_x_1_org11k.wav
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mono -fs 22050 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_CLEAN%\m_po_x_1_org22k.wav
%EXE_DIR%\%REFERENCE_EXE% -ff raw -fs 16000 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_CLEAN%\m_po_x_1_org16k.wav  
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mono -fs 24000 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_CLEAN%\m_po_x_1_org24k.wav	
%EXE_DIR%\%REFERENCE_EXE% -ff raw -fs 32000 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_CLEAN%\m_po_x_1_org32k.wav  
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mono -fs 44100 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_CLEAN%\m_po_x_1_org44k.wav

rem pause

REM 48kHz reference fer
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS48k% -if %BIT_DIR%\sw_48_lc_fs_mi.bit -of %OUT_DIR_FER%\sw_48_lc_fs_mi_48k.wav
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS48k% -if %BIT_DIR%\sw1_48_hc_fs_mi.bit -of %OUT_DIR_FER%\sw1_48_hc_fs_mi_48k.wav
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS48k% -if %BIT_DIR%\concatener.bit -of %OUT_DIR_FER%\concatener_48k.wav
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS48k% -mono -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_FER%\m_po_x_1_org_48k.wav


REM 16kHz reference fer
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS16k% -if %BIT_DIR%\TH_16s.bit -of %OUT_DIR_FER%\TH_16s.wav
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS16k% -mono -if %BIT_DIR%\TH_16m.bit -of %OUT_DIR_FER%\TH_16m.wav

REM 8kHz reference fer
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS8k% -if %BIT_DIR%\m_po_x_1_orgs.bit -of %OUT_DIR_FER%\m_po_x_1_orgs.wav
%EXE_DIR%\%REFERENCE_EXE% %FER_OPTIONS8k% -mono -if %BIT_DIR%\m_po_x_1_orgm.bit -of %OUT_DIR_FER%\m_po_x_1_orgm.wav
	
REM Frequency swap reference fer

%EXE_DIR%\%REFERENCE_EXE% -ff raw -fs 11025 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_FER%\m_po_x_1_org11k.wav -fer fer_10_percent.txt
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mono -fs 22050 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_FER%\m_po_x_1_org22k.wav -fer fer_10_percent.txt
%EXE_DIR%\%REFERENCE_EXE% -ff raw -fs 16000 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_FER%\m_po_x_1_org16k.wav   -fer fer_10_percent.txt
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mono -fs 24000 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_FER%\m_po_x_1_org24k.wav -fer fer_10_percent.txt 
%EXE_DIR%\%REFERENCE_EXE% -ff raw -fs 32000 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_FER%\m_po_x_1_org32k.wav  -fer fer_10_percent.txt
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mono -fs 44100 -if %BIT_DIR%\m_po_x_1_org48.bit -of %OUT_DIR_FER%\m_po_x_1_org44k.wav -fer fer_10_percent.txt


