#!/bin/csh
set major=$1
set minor=$2
set logfile=$major.$minor.log
gawk -v major=$major -v minor=$minor ' \
BEGIN { \
    testid = sprintf("%d.%d",major,minor); \
    if (major == 11) { \
	inv_crit=-1; \
	thresh=0.1;  \
	meanthr=0.01;\
    } \
    else { \
	inv_crit=1; \
	if (major == 6) { \
	    thresh=-0.2;  \
	    meanthr=-0.075;\
	} \
	else { \
	    thresh=-0.2;  \
	    meanthr=-0.05;\
	} \
    } \
} \
{ \
    sumODG += $2; c++; \
    if ($2*inv_crit < thresh*inv_crit) { \
	failed = failed || 1; \
	printf "test %s failed on item %s with PEAQ-ODG=%g\n",testid,$1,$2;\
    } \
} \
END { \
    meanODG = sumODG/c; \
    if (meanODG*inv_crit < meanthr*inv_crit) { \
	printf "test %s failed with mean PEAQ-ODG=%g\n",testid,meanODG;\
    } \
    else { \
	if ( ! failed ) printf "test %s passed.\n",testid;\
	else printf "test %s failed.\n",testid;\
    }\
}' $logfile
