REM *****************************************************************
REM *                           testv_enc.BAT                       *
REM *    script to validate BE of a tested AMR-WB+                  *
REM *     decoder with the 26.273.6.1 reference AMR-WB+ encoder     *
REM ***************************************************************** 

ECHO OFF
REM ***********************************
REM * audio files directory
REM ***********************************
SET AUDIO_DIR=audio


REM ***********************************
REM * Output bit stream
REM ***********************************
mkdir bit_out
SET OUT_DIR=bit_out


REM ***********************************
REM * Exe directory
REM ***********************************
SET EXE_DIR=bin

REM ***********************************
REM * Execs
REM ***********************************
SET REFERENCE_EXE=encoder_fxd

REM ***********************************
REM * SET AUDIO FILES
REM ***********************************
SET A1=sw_48
SET A2=sw1_48
SET A3=TH_16s
SET A4=TH_16m
SET A5=concatener_green_test_amr
SET A6=m_po_x_1_org48k
SET A7=m_po_x_1_org48km
SET A8=m_po_x_1_org8km
SET A9=m_po_x_1_org8ks
SET A10=m_po_x_1_org11k
SET A11=m_po_x_1_org16k
SET A12=m_po_x_1_org22k
SET A13=m_po_x_1_org24k
SET A14=m_po_x_1_org32k
SET A15=m_po_x_1_org44k
SET A16=T_mode


echo on
REM 48kHz with switching
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 25 -isf 1.1 -if %AUDIO_DIR%\%A1%.wav -of %OUT_DIR%\%A1%.bit -cf amrwbplus_config_2.txt -lc
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 25 -isf 1.1 -if %AUDIO_DIR%\%A2%.wav -of %OUT_DIR%\%A2%.bit -cf amrwbplus_config_2.txt
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 25 -isf 1.0 -if %AUDIO_DIR%\%A5%.wav -of %OUT_DIR%\%A5%.bit -cf amrwbplus_config_fs_mi.txt -lc
REM 48kHz with low isf
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 23 -isf 0.5 -if %AUDIO_DIR%\%A6%.wav -of %OUT_DIR%\%A6%.bit 
%EXE_DIR%\%REFERENCE_EXE% -ff raw -rate 7 -mono -if %AUDIO_DIR%\%A7%.wav -of %OUT_DIR%\%A7%.bit 


REM 16kHz with switching from mi 10 to mi 13
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 13 -if %AUDIO_DIR%\%A3%.wav -of %OUT_DIR%\%A3%.bit -cf switch_amrwbp.txt
REM 16kHz with switching between AMRWB and AMRWB-E
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 10 -if %AUDIO_DIR%\%A4%.wav -of %OUT_DIR%\%A4%.bit -cf switch_amrwb.txt -dtx -lc

REM 8kHz 
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 10 -if %AUDIO_DIR%\%A8%.wav -of %OUT_DIR%\%A8%.bit 
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 13 -if %AUDIO_DIR%\%A9%.wav -of %OUT_DIR%\%A9%.bit 


REM VARIATION OF INPUT FREQUENCY
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 23 -isf 1.0 -if %AUDIO_DIR%\%A10%.wav -of %OUT_DIR%\%A10%.bit -lc
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 23 -isf 1.0 -if %AUDIO_DIR%\%A11%.wav -of %OUT_DIR%\%A11%.bit 
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 23 -isf 1.0 -if %AUDIO_DIR%\%A12%.wav -of %OUT_DIR%\%A12%.bit -lc
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 23 -isf 1.0 -if %AUDIO_DIR%\%A13%.wav -of %OUT_DIR%\%A13%.bit 
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 23 -isf 1.0 -if %AUDIO_DIR%\%A14%.wav -of %OUT_DIR%\%A14%.bit -lc
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 23 -isf 1.0 -if %AUDIO_DIR%\%A15%.wav -of %OUT_DIR%\%A15%.bit 

REM OPEN LOOP MODE SELECTION
%EXE_DIR%\%REFERENCE_EXE% -ff raw -mi 10 -lc -if %AUDIO_DIR%\%A16%.wav -of %OUT_DIR%\%A16%.bit 


