#!/bin/csh
unset noglob
unset noclobber
#### pathes to executables to be adjusted to local needs ##############################
set PEAQ=/usr/local/bin/PQevalAudio.exe # PEAQ tool, example: PEAQ tool in AFsp library 
set ref_enc=../bin/encoder              # Reference encoder from 3GPP TS 26.304
set ref_dec=../bin/decoder              # Reference decoder from 3GPP TS 26.304
set test_dec=../bin/decoder_fx          # Test decoder to be verified
set audiodir=../audiodir                # Directory containing original files
#######################################################################################

# produced intermediate files
set ofile_test=testfile.wav
set ofile_ref=reffile.wav
set par=ref_par.wb+

# Test conditions
set major_test=5                 # Major test number according to 26.274
@ test= 0                        # Minor test number to be incremented during execution of script
                                 # Minor test options
set enc_opts=('-rate 14' '-rate 24' '-rate 48')
set dec_opts=""
                                 # List of files to be checked
set filelist = 'm_ch_x_1_org,m_cl_x_1_org,m_cl_x_2_org,m_ot_x_1_org,m_ot_x_2_org,m_ot_x_3_org,m_ot_x_4_org,m_ot_x_5_org,m_ot_x_6_org,m_ot_x_7_org,m_ot_x_8_org,m_ot_x_9_org,m_ot_x_a_org,m_ot_x_b.org,m_po_x_1_org,m_po_x_2_org,m_po_x_3_org,m_po_x_4_org,m_po_x_5_org,m_po_x_6_org,m_po_x_7_org,m_si_x_1_org,m_si_x_2_org,m_si_x_3_org,m_vo_x_1_org,s_cl_2t_1_org,s_cl_2t_2_org,s_cl_2t_3_org,s_cl_2t_4_org,s_cl_2t_5_org,s_cl_ft_3_org,s_cl_mt_1_org,s_cl_mt_2_org,s_no_2t_1_org,s_no_2t_2_org,s_no_2t_3_org,s_no_ft_1_org,s_no_ft_2_org,s_no_ft_3_org,s_no_ft_9_org,s_no_mt_1_org,sbm_fi_x_9_org,sbm_js_x_1_org,sbm_js_x_2_org,sbm_ms_x_1_org,sbm_sj_x_1_org,sbm_sm_x_1_org,sbm_sm_x_2_org,sbm_sm_x_3_org,sbm_sm_x_4_org,sbm_sm_x_5_org,sbm_sm_x_6_org,som_ad_x_1_org,som_fi_x_1_org,som_fi_x_2_org,som_fi_x_3_org,som_fi_x_4_org,som_nt_x_1_org,som_ot_x_1_org,som_ot_x_2_org,som_ot_x_3_org,som_ot_x_4_org,som_ot_x_5_org,som_ot_x_6_org,som_ot_x_9_org'

## Execution ########################################################
while ($#enc_opts > 0)
    set enc_opt="$enc_opts[1]"
## Some preparations ################################################
    set logfile=$major_test.$test\.log
    if (-f $logfile) then
	mv $logfile $logfile.bak
    endif
    rm -f $logfile
    touch $logfile
#####################################################################
    foreach infile ($audiodir/{$filelist}.wav)
	set ifile=`basename $infile`
	cp $infile $ifile

	# Execute reference encoder
	echo "Encoding $ifile"
	$ref_enc $enc_opt -ff raw -if $ifile -of $par

	#  Execute reference decoder
	$ref_dec -ff raw -fs 48000 -if $par -of $ofile_ref $dec_opts
	
	#  Execute test decoder
	$test_dec -ff raw -fs 48000 -if $par -of $ofile_test $dec_opts

	# PEAQ-ODG
	set peaq=(`$PEAQ $ofile_ref $ofile_test | grep "Objective Difference Grade:"`)
	echo "`basename $ifile` $peaq[4]" >> $logfile

	# clean up
	rm $ifile $par $ofile_ref $ofile_test
    end

# Check against criteria
    set resfile=$major_test.$test\.res
    csh check_criteria.csh $major_test $test > $resfile
#####################################################################
    shift enc_opts
    @ test++
end

