#!/bin/csh
unset noglob
unset noclobber
#### pathes to executables to be adjusted to local needs ##############################
set RESAMPAUDIO = /usr/local/bin/ResampAudio.exe
set PEAQ=/usr/local/bin/PQevalAudio.exe
set ref_enc=../bin/encoder_modsav       # Patched reference encoder from 3GPP TS 26.304
set ref_dec=../bin/decoder              # Reference decoder from 3GPP TS 26.304
set test_enc=../bin/encoder_modlck_fx   # Test encoder to be verified with mode locking patch
set audiodir=../audiodir                # Directory containing original files
#######################################################################################

# produced intermediate files
set ofile_test=testfile.wav
set ofile_ref=reffile.wav
set par=par.wb+
set par_ref=ref_par.wb+
set par_test=test_par.wb+

# Test conditions
set major_test=11                # Major test number according to 26.274
@ test= 0                        # Minor test number to be incremented during execution of script
                                 # Minor test options
set enc_opts=('-mi 23 -isf 1')  
set dec_opts=""
set del=3568                     # Input/output delay in samples @ 48 kHz sampling rate
                                 # List of files to be checked
set filelist = 'm_ch_x_1_org,m_cl_x_1_org,m_cl_x_2_org,m_ot_x_1_org,m_ot_x_2_org,m_ot_x_3_org,m_ot_x_4_org,m_ot_x_5_org,m_ot_x_6_org,m_ot_x_7_org,m_ot_x_8_org,m_ot_x_9_org,m_ot_x_a_org,m_ot_x_b.org,m_po_x_1_org,m_po_x_2_org,m_po_x_3_org,m_po_x_4_org,m_po_x_5_org,m_po_x_6_org,m_po_x_7_org,m_si_x_1_org,m_si_x_2_org,m_si_x_3_org,m_vo_x_1_org,s_cl_2t_1_org,s_cl_2t_2_org,s_cl_2t_3_org,s_cl_2t_4_org,s_cl_2t_5_org,s_cl_ft_3_org,s_cl_mt_1_org,s_cl_mt_2_org,s_no_2t_1_org,s_no_2t_2_org,s_no_2t_3_org,s_no_ft_1_org,s_no_ft_2_org,s_no_ft_3_org,s_no_ft_4_org,s_no_ft_9_org,s_no_mt_1_org,sbm_fi_x_9_org,sbm_js_x_1_org,sbm_js_x_2_org,sbm_ms_x_1_org,sbm_sj_x_1_org,sbm_sm_x_1_org,sbm_sm_x_2_org,sbm_sm_x_3_org,sbm_sm_x_4_org,sbm_sm_x_5_org,sbm_sm_x_6_org,som_ad_x_1_org,som_fi_x_1_org,som_fi_x_2_org,som_fi_x_3_org,som_fi_x_4_org,som_nt_x_1_org,som_ot_x_1_org,som_ot_x_2_org,som_ot_x_3_org,som_ot_x_4_org,som_ot_x_5_org,som_ot_x_6_org,som_ot_x_9_org'

## Execution ########################################################
while ($#enc_opts > 0)
    set enc_opt="$enc_opts[1]"
## Some preparations ################################################
    set logfile=$major_test.$test\.log
    if (-f $logfile) then
	mv $logfile $logfile.bak
    endif
    rm -f $logfile
    touch $logfile
#####################################################################
    foreach infile ($audiodir/{$filelist}.wav)
	set ifile=`basename $infile`
	cp $infile $ifile

	# Execute reference encoder - decoder combination
	echo "Processing $ifile"
	$ref_enc $enc_opt -ff raw -if $ifile -of $par_ref
	$ref_dec -ff raw -fs 48000 -if $par_ref -of $ofile_ref $dec_opts

	# Execute test encoder - reference decoder combination
	mv core_mode_o.dat core_mode.dat
	$test_enc $enc_opt -ff raw -if $ifile -of $par_test
	$ref_dec -ff raw -fs 48000 -if $par_test -of $ofile_test $dec_opts

	# DELAY compensation
	$RESAMPAUDIO -i 1 -a $del $ofile_ref tmp.wav
	mv tmp.wav $ofile_ref
	$RESAMPAUDIO -i 1 -a $del $ofile_test tmp.wav
	mv tmp.wav $ofile_test

	# PEAQ-ODG wrt original
	set peaq_ref =(`$PEAQ $ifile $ofile_ref | grep "Objective Difference Grade:"`)
	set peaq_test=(`$PEAQ $ifile $ofile_test | grep "Objective Difference Grade:"`)
	set absdiff = `awk -v odg1=$peaq_ref[4] -v odg2=$peaq_test[4] 'BEGIN {d=odg1-odg2; printf "%g",sqrt(d*d)}'`
	echo "`basename $ifile` $absdiff" >> $logfile
	echo "$peaq_ref[4] $peaq_test[4] $absdiff"

	# clean up
	rm $ifile $par_ref $par_test $ofile_ref $ofile_test core_mode.dat
    end

# Check against criteria
    set resfile=$major_test.$test\.res
    csh check_criteria.csh $major_test $test > $resfile
#####################################################################
    shift enc_opts
    @ test++
end

